/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.management.CountStatisticImpl;
import org.apache.activemq.management.MessageFlowStats;
import org.apache.activemq.management.MessageFlowStatsImpl;
import org.apache.activemq.management.PollCountStatisticImpl;
import org.apache.activemq.management.SizeStatisticImpl;
import org.apache.activemq.management.StatsImpl;
import org.apache.activemq.management.TimeStatisticImpl;

public class DestinationStatistics
extends StatsImpl {
    private final CountStatisticImpl enqueues;
    private final CountStatisticImpl dequeues;
    private final CountStatisticImpl forwards;
    private final CountStatisticImpl consumers;
    private final CountStatisticImpl producers;
    private final CountStatisticImpl messages;
    private final PollCountStatisticImpl messagesCached;
    private final CountStatisticImpl dispatched;
    private final CountStatisticImpl duplicateFromStore;
    private final CountStatisticImpl inflight;
    private final CountStatisticImpl expired;
    private final TimeStatisticImpl processTime;
    private final CountStatisticImpl blockedSends;
    private final TimeStatisticImpl blockedTime;
    private final SizeStatisticImpl messageSize;
    private final CountStatisticImpl maxUncommittedExceededCount;
    private final CountStatisticImpl networkEnqueues;
    private final CountStatisticImpl networkDequeues;
    private final AtomicReference<MessageFlowStatsImpl> messageFlowStats = new AtomicReference();

    public DestinationStatistics() {
        this.enqueues = new CountStatisticImpl("enqueues", "The number of messages that have been sent to the destination");
        this.dispatched = new CountStatisticImpl("dispatched", "The number of messages that have been dispatched from the destination");
        this.dequeues = new CountStatisticImpl("dequeues", "The number of messages that have been acknowledged from the destination");
        this.duplicateFromStore = new CountStatisticImpl("duplicateFromStore", "The number of duplicate messages that have been paged-in from the store for this destination");
        this.forwards = new CountStatisticImpl("forwards", "The number of messages that have been forwarded to a networked broker from the destination");
        this.inflight = new CountStatisticImpl("inflight", "The number of messages dispatched but awaiting acknowledgement");
        this.expired = new CountStatisticImpl("expired", "The number of messages that have expired");
        this.consumers = new CountStatisticImpl("consumers", "The number of consumers that that are subscribing to messages from the destination");
        this.consumers.setDoReset(false);
        this.producers = new CountStatisticImpl("producers", "The number of producers that that are publishing messages to the destination");
        this.producers.setDoReset(false);
        this.messages = new CountStatisticImpl("messages", "The number of messages that that are being held by the destination");
        this.messages.setDoReset(false);
        this.messagesCached = new PollCountStatisticImpl("messagesCached", "The number of messages that are held in the destination's memory cache");
        this.processTime = new TimeStatisticImpl("processTime", "information around length of time messages are held by a destination");
        this.blockedSends = new CountStatisticImpl("blockedSends", "number of messages that have to wait for flow control");
        this.blockedTime = new TimeStatisticImpl("blockedTime", "amount of time messages are blocked for flow control");
        this.messageSize = new SizeStatisticImpl("messageSize", "Size of messages passing through the destination");
        this.maxUncommittedExceededCount = new CountStatisticImpl("maxUncommittedExceededCount", "number of times maxUncommittedCount has been exceeded");
        this.networkEnqueues = new CountStatisticImpl("networkEnqueues", "The number of messages that have been sent to the destination via network connection");
        this.networkDequeues = new CountStatisticImpl("networkDequeues", "The number of messages that have been acknowledged from the destination via network connection");
    }

    public CountStatisticImpl getEnqueues() {
        return this.enqueues;
    }

    public CountStatisticImpl getDequeues() {
        return this.dequeues;
    }

    public CountStatisticImpl getForwards() {
        return this.forwards;
    }

    public CountStatisticImpl getInflight() {
        return this.inflight;
    }

    public CountStatisticImpl getExpired() {
        return this.expired;
    }

    public CountStatisticImpl getConsumers() {
        return this.consumers;
    }

    public CountStatisticImpl getProducers() {
        return this.producers;
    }

    public PollCountStatisticImpl getMessagesCached() {
        return this.messagesCached;
    }

    public CountStatisticImpl getMessages() {
        return this.messages;
    }

    public CountStatisticImpl getDispatched() {
        return this.dispatched;
    }

    public CountStatisticImpl getDuplicateFromStore() {
        return this.duplicateFromStore;
    }

    public TimeStatisticImpl getProcessTime() {
        return this.processTime;
    }

    public CountStatisticImpl getBlockedSends() {
        return this.blockedSends;
    }

    public TimeStatisticImpl getBlockedTime() {
        return this.blockedTime;
    }

    public SizeStatisticImpl getMessageSize() {
        return this.messageSize;
    }

    public CountStatisticImpl getMaxUncommittedExceededCount() {
        return this.maxUncommittedExceededCount;
    }

    public CountStatisticImpl getNetworkEnqueues() {
        return this.networkEnqueues;
    }

    public CountStatisticImpl getNetworkDequeues() {
        return this.networkDequeues;
    }

    public MessageFlowStats getMessageFlowStats() {
        return this.messageFlowStats.get();
    }

    @Override
    public void reset() {
        if (this.isDoReset()) {
            super.reset();
            this.enqueues.reset();
            this.dequeues.reset();
            this.forwards.reset();
            this.dispatched.reset();
            this.duplicateFromStore.reset();
            this.inflight.reset();
            this.expired.reset();
            this.blockedSends.reset();
            this.blockedTime.reset();
            this.messageSize.reset();
            this.maxUncommittedExceededCount.reset();
            this.networkEnqueues.reset();
            this.networkDequeues.reset();
            Optional.ofNullable(this.messageFlowStats.get()).ifPresent(StatsImpl::reset);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enqueues.setEnabled(enabled);
        this.dispatched.setEnabled(enabled);
        this.dequeues.setEnabled(enabled);
        this.duplicateFromStore.setEnabled(enabled);
        this.forwards.setEnabled(enabled);
        this.inflight.setEnabled(enabled);
        this.expired.setEnabled(true);
        this.consumers.setEnabled(enabled);
        this.producers.setEnabled(enabled);
        this.messages.setEnabled(enabled);
        this.messagesCached.setEnabled(enabled);
        this.processTime.setEnabled(enabled);
        this.blockedSends.setEnabled(enabled);
        this.blockedTime.setEnabled(enabled);
        this.messageSize.setEnabled(enabled);
        this.maxUncommittedExceededCount.setEnabled(enabled);
        this.networkEnqueues.setEnabled(enabled);
        this.networkDequeues.setEnabled(enabled);
        Optional.ofNullable(this.messageFlowStats.get()).ifPresent(stats -> stats.setEnabled(enabled));
    }

    public void setParent(DestinationStatistics parent) {
        if (parent != null) {
            this.enqueues.setParent(parent.enqueues);
            this.dispatched.setParent(parent.dispatched);
            this.dequeues.setParent(parent.dequeues);
            this.duplicateFromStore.setParent(parent.duplicateFromStore);
            this.forwards.setParent(parent.forwards);
            this.inflight.setParent(parent.inflight);
            this.expired.setParent(parent.expired);
            this.consumers.setParent(parent.consumers);
            this.producers.setParent(parent.producers);
            this.messagesCached.setParent(parent.messagesCached);
            this.messages.setParent(parent.messages);
            this.processTime.setParent(parent.processTime);
            this.blockedSends.setParent(parent.blockedSends);
            this.blockedTime.setParent(parent.blockedTime);
            this.messageSize.setParent(parent.messageSize);
            this.maxUncommittedExceededCount.setParent(parent.maxUncommittedExceededCount);
            this.networkEnqueues.setParent(parent.networkEnqueues);
            this.networkDequeues.setParent(parent.networkDequeues);
        } else {
            this.enqueues.setParent(null);
            this.dispatched.setParent(null);
            this.dequeues.setParent(null);
            this.duplicateFromStore.setParent(null);
            this.forwards.setParent(null);
            this.inflight.setParent(null);
            this.expired.setParent(null);
            this.consumers.setParent(null);
            this.producers.setParent(null);
            this.messagesCached.setParent(null);
            this.messages.setParent(null);
            this.processTime.setParent(null);
            this.blockedSends.setParent(null);
            this.blockedTime.setParent(null);
            this.messageSize.setParent(null);
            this.maxUncommittedExceededCount.setParent(null);
            this.networkEnqueues.setParent(null);
            this.networkDequeues.setParent(null);
        }
    }

    public synchronized void setAdvancedMessageStatisticsEnabled(boolean enabled) {
        if (!enabled) {
            this.messageFlowStats.set(null);
            return;
        }
        if (this.messageFlowStats.get() == null) {
            MessageFlowStatsImpl tmpMessageFlowStatsImpl = new MessageFlowStatsImpl();
            tmpMessageFlowStatsImpl.setEnabled(true);
            this.messageFlowStats.set(tmpMessageFlowStatsImpl);
        }
    }

    public boolean isAdvancedMessageStatisticsEnabled() {
        return this.messageFlowStats.get() != null;
    }
}

