/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#include "data_movement_models_types.h"

#include <algorithm>
#include <ostream>

#include <thrift/TToString.h>

namespace apache { namespace airavata { namespace model { namespace data { namespace movement {

int _kDMTypeValues[] = {
  DMType::COMPUTE_RESOURCE,
  DMType::STORAGE_RESOURCE
};
const char* _kDMTypeNames[] = {
  "COMPUTE_RESOURCE",
  "STORAGE_RESOURCE"
};
const std::map<int, const char*> _DMType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(2, _kDMTypeValues, _kDMTypeNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kSecurityProtocolValues[] = {
  SecurityProtocol::USERNAME_PASSWORD,
  SecurityProtocol::SSH_KEYS,
  SecurityProtocol::GSI,
  SecurityProtocol::KERBEROS,
  SecurityProtocol::OAUTH,
  SecurityProtocol::LOCAL
};
const char* _kSecurityProtocolNames[] = {
  "USERNAME_PASSWORD",
  "SSH_KEYS",
  "GSI",
  "KERBEROS",
  "OAUTH",
  "LOCAL"
};
const std::map<int, const char*> _SecurityProtocol_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(6, _kSecurityProtocolValues, _kSecurityProtocolNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kDataMovementProtocolValues[] = {
  DataMovementProtocol::LOCAL,
  DataMovementProtocol::SCP,
  DataMovementProtocol::SFTP,
  DataMovementProtocol::GridFTP,
  DataMovementProtocol::UNICORE_STORAGE_SERVICE
};
const char* _kDataMovementProtocolNames[] = {
  "LOCAL",
  "SCP",
  "SFTP",
  "GridFTP",
  "UNICORE_STORAGE_SERVICE"
};
const std::map<int, const char*> _DataMovementProtocol_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(5, _kDataMovementProtocolValues, _kDataMovementProtocolNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));


SCPDataMovement::~SCPDataMovement() throw() {
}


void SCPDataMovement::__set_dataMovementInterfaceId(const std::string& val) {
  this->dataMovementInterfaceId = val;
}

void SCPDataMovement::__set_securityProtocol(const SecurityProtocol::type val) {
  this->securityProtocol = val;
}

void SCPDataMovement::__set_alternativeSCPHostName(const std::string& val) {
  this->alternativeSCPHostName = val;
__isset.alternativeSCPHostName = true;
}

void SCPDataMovement::__set_sshPort(const int32_t val) {
  this->sshPort = val;
__isset.sshPort = true;
}

uint32_t SCPDataMovement::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_dataMovementInterfaceId = false;
  bool isset_securityProtocol = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->dataMovementInterfaceId);
          isset_dataMovementInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast0;
          xfer += iprot->readI32(ecast0);
          this->securityProtocol = (SecurityProtocol::type)ecast0;
          isset_securityProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->alternativeSCPHostName);
          this->__isset.alternativeSCPHostName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->sshPort);
          this->__isset.sshPort = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_dataMovementInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_securityProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t SCPDataMovement::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("SCPDataMovement");

  xfer += oprot->writeFieldBegin("dataMovementInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->dataMovementInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("securityProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->securityProtocol);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.alternativeSCPHostName) {
    xfer += oprot->writeFieldBegin("alternativeSCPHostName", ::apache::thrift::protocol::T_STRING, 3);
    xfer += oprot->writeString(this->alternativeSCPHostName);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.sshPort) {
    xfer += oprot->writeFieldBegin("sshPort", ::apache::thrift::protocol::T_I32, 4);
    xfer += oprot->writeI32(this->sshPort);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(SCPDataMovement &a, SCPDataMovement &b) {
  using ::std::swap;
  swap(a.dataMovementInterfaceId, b.dataMovementInterfaceId);
  swap(a.securityProtocol, b.securityProtocol);
  swap(a.alternativeSCPHostName, b.alternativeSCPHostName);
  swap(a.sshPort, b.sshPort);
  swap(a.__isset, b.__isset);
}

SCPDataMovement::SCPDataMovement(const SCPDataMovement& other1) {
  dataMovementInterfaceId = other1.dataMovementInterfaceId;
  securityProtocol = other1.securityProtocol;
  alternativeSCPHostName = other1.alternativeSCPHostName;
  sshPort = other1.sshPort;
  __isset = other1.__isset;
}
SCPDataMovement& SCPDataMovement::operator=(const SCPDataMovement& other2) {
  dataMovementInterfaceId = other2.dataMovementInterfaceId;
  securityProtocol = other2.securityProtocol;
  alternativeSCPHostName = other2.alternativeSCPHostName;
  sshPort = other2.sshPort;
  __isset = other2.__isset;
  return *this;
}
void SCPDataMovement::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "SCPDataMovement(";
  out << "dataMovementInterfaceId=" << to_string(dataMovementInterfaceId);
  out << ", " << "securityProtocol=" << to_string(securityProtocol);
  out << ", " << "alternativeSCPHostName="; (__isset.alternativeSCPHostName ? (out << to_string(alternativeSCPHostName)) : (out << "<null>"));
  out << ", " << "sshPort="; (__isset.sshPort ? (out << to_string(sshPort)) : (out << "<null>"));
  out << ")";
}


GridFTPDataMovement::~GridFTPDataMovement() throw() {
}


void GridFTPDataMovement::__set_dataMovementInterfaceId(const std::string& val) {
  this->dataMovementInterfaceId = val;
}

void GridFTPDataMovement::__set_securityProtocol(const SecurityProtocol::type val) {
  this->securityProtocol = val;
}

void GridFTPDataMovement::__set_gridFTPEndPoints(const std::vector<std::string> & val) {
  this->gridFTPEndPoints = val;
}

uint32_t GridFTPDataMovement::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_dataMovementInterfaceId = false;
  bool isset_securityProtocol = false;
  bool isset_gridFTPEndPoints = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->dataMovementInterfaceId);
          isset_dataMovementInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast3;
          xfer += iprot->readI32(ecast3);
          this->securityProtocol = (SecurityProtocol::type)ecast3;
          isset_securityProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->gridFTPEndPoints.clear();
            uint32_t _size4;
            ::apache::thrift::protocol::TType _etype7;
            xfer += iprot->readListBegin(_etype7, _size4);
            this->gridFTPEndPoints.resize(_size4);
            uint32_t _i8;
            for (_i8 = 0; _i8 < _size4; ++_i8)
            {
              xfer += iprot->readString(this->gridFTPEndPoints[_i8]);
            }
            xfer += iprot->readListEnd();
          }
          isset_gridFTPEndPoints = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_dataMovementInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_securityProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gridFTPEndPoints)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t GridFTPDataMovement::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("GridFTPDataMovement");

  xfer += oprot->writeFieldBegin("dataMovementInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->dataMovementInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("securityProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->securityProtocol);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gridFTPEndPoints", ::apache::thrift::protocol::T_LIST, 3);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->gridFTPEndPoints.size()));
    std::vector<std::string> ::const_iterator _iter9;
    for (_iter9 = this->gridFTPEndPoints.begin(); _iter9 != this->gridFTPEndPoints.end(); ++_iter9)
    {
      xfer += oprot->writeString((*_iter9));
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(GridFTPDataMovement &a, GridFTPDataMovement &b) {
  using ::std::swap;
  swap(a.dataMovementInterfaceId, b.dataMovementInterfaceId);
  swap(a.securityProtocol, b.securityProtocol);
  swap(a.gridFTPEndPoints, b.gridFTPEndPoints);
}

GridFTPDataMovement::GridFTPDataMovement(const GridFTPDataMovement& other10) {
  dataMovementInterfaceId = other10.dataMovementInterfaceId;
  securityProtocol = other10.securityProtocol;
  gridFTPEndPoints = other10.gridFTPEndPoints;
}
GridFTPDataMovement& GridFTPDataMovement::operator=(const GridFTPDataMovement& other11) {
  dataMovementInterfaceId = other11.dataMovementInterfaceId;
  securityProtocol = other11.securityProtocol;
  gridFTPEndPoints = other11.gridFTPEndPoints;
  return *this;
}
void GridFTPDataMovement::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "GridFTPDataMovement(";
  out << "dataMovementInterfaceId=" << to_string(dataMovementInterfaceId);
  out << ", " << "securityProtocol=" << to_string(securityProtocol);
  out << ", " << "gridFTPEndPoints=" << to_string(gridFTPEndPoints);
  out << ")";
}


UnicoreDataMovement::~UnicoreDataMovement() throw() {
}


void UnicoreDataMovement::__set_dataMovementInterfaceId(const std::string& val) {
  this->dataMovementInterfaceId = val;
}

void UnicoreDataMovement::__set_securityProtocol(const SecurityProtocol::type val) {
  this->securityProtocol = val;
}

void UnicoreDataMovement::__set_unicoreEndPointURL(const std::string& val) {
  this->unicoreEndPointURL = val;
}

uint32_t UnicoreDataMovement::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_dataMovementInterfaceId = false;
  bool isset_securityProtocol = false;
  bool isset_unicoreEndPointURL = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->dataMovementInterfaceId);
          isset_dataMovementInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast12;
          xfer += iprot->readI32(ecast12);
          this->securityProtocol = (SecurityProtocol::type)ecast12;
          isset_securityProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->unicoreEndPointURL);
          isset_unicoreEndPointURL = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_dataMovementInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_securityProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_unicoreEndPointURL)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t UnicoreDataMovement::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("UnicoreDataMovement");

  xfer += oprot->writeFieldBegin("dataMovementInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->dataMovementInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("securityProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->securityProtocol);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("unicoreEndPointURL", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->unicoreEndPointURL);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(UnicoreDataMovement &a, UnicoreDataMovement &b) {
  using ::std::swap;
  swap(a.dataMovementInterfaceId, b.dataMovementInterfaceId);
  swap(a.securityProtocol, b.securityProtocol);
  swap(a.unicoreEndPointURL, b.unicoreEndPointURL);
}

UnicoreDataMovement::UnicoreDataMovement(const UnicoreDataMovement& other13) {
  dataMovementInterfaceId = other13.dataMovementInterfaceId;
  securityProtocol = other13.securityProtocol;
  unicoreEndPointURL = other13.unicoreEndPointURL;
}
UnicoreDataMovement& UnicoreDataMovement::operator=(const UnicoreDataMovement& other14) {
  dataMovementInterfaceId = other14.dataMovementInterfaceId;
  securityProtocol = other14.securityProtocol;
  unicoreEndPointURL = other14.unicoreEndPointURL;
  return *this;
}
void UnicoreDataMovement::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "UnicoreDataMovement(";
  out << "dataMovementInterfaceId=" << to_string(dataMovementInterfaceId);
  out << ", " << "securityProtocol=" << to_string(securityProtocol);
  out << ", " << "unicoreEndPointURL=" << to_string(unicoreEndPointURL);
  out << ")";
}


LOCALDataMovement::~LOCALDataMovement() throw() {
}


void LOCALDataMovement::__set_dataMovementInterfaceId(const std::string& val) {
  this->dataMovementInterfaceId = val;
}

uint32_t LOCALDataMovement::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_dataMovementInterfaceId = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->dataMovementInterfaceId);
          isset_dataMovementInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_dataMovementInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t LOCALDataMovement::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("LOCALDataMovement");

  xfer += oprot->writeFieldBegin("dataMovementInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->dataMovementInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(LOCALDataMovement &a, LOCALDataMovement &b) {
  using ::std::swap;
  swap(a.dataMovementInterfaceId, b.dataMovementInterfaceId);
}

LOCALDataMovement::LOCALDataMovement(const LOCALDataMovement& other15) {
  dataMovementInterfaceId = other15.dataMovementInterfaceId;
}
LOCALDataMovement& LOCALDataMovement::operator=(const LOCALDataMovement& other16) {
  dataMovementInterfaceId = other16.dataMovementInterfaceId;
  return *this;
}
void LOCALDataMovement::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "LOCALDataMovement(";
  out << "dataMovementInterfaceId=" << to_string(dataMovementInterfaceId);
  out << ")";
}


DataMovementInterface::~DataMovementInterface() throw() {
}


void DataMovementInterface::__set_dataMovementInterfaceId(const std::string& val) {
  this->dataMovementInterfaceId = val;
}

void DataMovementInterface::__set_dataMovementProtocol(const DataMovementProtocol::type val) {
  this->dataMovementProtocol = val;
}

void DataMovementInterface::__set_priorityOrder(const int32_t val) {
  this->priorityOrder = val;
}

uint32_t DataMovementInterface::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_dataMovementInterfaceId = false;
  bool isset_dataMovementProtocol = false;
  bool isset_priorityOrder = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->dataMovementInterfaceId);
          isset_dataMovementInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast17;
          xfer += iprot->readI32(ecast17);
          this->dataMovementProtocol = (DataMovementProtocol::type)ecast17;
          isset_dataMovementProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->priorityOrder);
          isset_priorityOrder = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_dataMovementInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_dataMovementProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_priorityOrder)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t DataMovementInterface::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("DataMovementInterface");

  xfer += oprot->writeFieldBegin("dataMovementInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->dataMovementInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("dataMovementProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->dataMovementProtocol);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("priorityOrder", ::apache::thrift::protocol::T_I32, 3);
  xfer += oprot->writeI32(this->priorityOrder);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(DataMovementInterface &a, DataMovementInterface &b) {
  using ::std::swap;
  swap(a.dataMovementInterfaceId, b.dataMovementInterfaceId);
  swap(a.dataMovementProtocol, b.dataMovementProtocol);
  swap(a.priorityOrder, b.priorityOrder);
}

DataMovementInterface::DataMovementInterface(const DataMovementInterface& other18) {
  dataMovementInterfaceId = other18.dataMovementInterfaceId;
  dataMovementProtocol = other18.dataMovementProtocol;
  priorityOrder = other18.priorityOrder;
}
DataMovementInterface& DataMovementInterface::operator=(const DataMovementInterface& other19) {
  dataMovementInterfaceId = other19.dataMovementInterfaceId;
  dataMovementProtocol = other19.dataMovementProtocol;
  priorityOrder = other19.priorityOrder;
  return *this;
}
void DataMovementInterface::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "DataMovementInterface(";
  out << "dataMovementInterfaceId=" << to_string(dataMovementInterfaceId);
  out << ", " << "dataMovementProtocol=" << to_string(dataMovementProtocol);
  out << ", " << "priorityOrder=" << to_string(priorityOrder);
  out << ")";
}

}}}}} // namespace
