/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#include "experiment_model_types.h"

#include <algorithm>
#include <ostream>

#include <thrift/TToString.h>

namespace apache { namespace airavata { namespace model { namespace experiment {

int _kExperimentTypeValues[] = {
  ExperimentType::SINGLE_APPLICATION,
  ExperimentType::WORKFLOW
};
const char* _kExperimentTypeNames[] = {
  "SINGLE_APPLICATION",
  "WORKFLOW"
};
const std::map<int, const char*> _ExperimentType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(2, _kExperimentTypeValues, _kExperimentTypeNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kExperimentSearchFieldsValues[] = {
  ExperimentSearchFields::EXPERIMENT_NAME,
  ExperimentSearchFields::EXPERIMENT_DESC,
  ExperimentSearchFields::APPLICATION_ID,
  ExperimentSearchFields::FROM_DATE,
  ExperimentSearchFields::TO_DATE,
  ExperimentSearchFields::STATUS,
  ExperimentSearchFields::PROJECT_ID
};
const char* _kExperimentSearchFieldsNames[] = {
  "EXPERIMENT_NAME",
  "EXPERIMENT_DESC",
  "APPLICATION_ID",
  "FROM_DATE",
  "TO_DATE",
  "STATUS",
  "PROJECT_ID"
};
const std::map<int, const char*> _ExperimentSearchFields_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(7, _kExperimentSearchFieldsValues, _kExperimentSearchFieldsNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kProjectSearchFieldsValues[] = {
  ProjectSearchFields::PROJECT_NAME,
  ProjectSearchFields::PROJECT_DESCRIPTION
};
const char* _kProjectSearchFieldsNames[] = {
  "PROJECT_NAME",
  "PROJECT_DESCRIPTION"
};
const std::map<int, const char*> _ProjectSearchFields_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(2, _kProjectSearchFieldsValues, _kProjectSearchFieldsNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));


UserConfigurationDataModel::~UserConfigurationDataModel() throw() {
}


void UserConfigurationDataModel::__set_airavataAutoSchedule(const bool val) {
  this->airavataAutoSchedule = val;
}

void UserConfigurationDataModel::__set_overrideManualScheduledParams(const bool val) {
  this->overrideManualScheduledParams = val;
}

void UserConfigurationDataModel::__set_shareExperimentPublicly(const bool val) {
  this->shareExperimentPublicly = val;
__isset.shareExperimentPublicly = true;
}

void UserConfigurationDataModel::__set_computationalResourceScheduling(const  ::apache::airavata::model::scheduling::ComputationalResourceSchedulingModel& val) {
  this->computationalResourceScheduling = val;
__isset.computationalResourceScheduling = true;
}

void UserConfigurationDataModel::__set_throttleResources(const bool val) {
  this->throttleResources = val;
__isset.throttleResources = true;
}

void UserConfigurationDataModel::__set_userDN(const std::string& val) {
  this->userDN = val;
__isset.userDN = true;
}

void UserConfigurationDataModel::__set_generateCert(const bool val) {
  this->generateCert = val;
__isset.generateCert = true;
}

void UserConfigurationDataModel::__set_storageId(const std::string& val) {
  this->storageId = val;
__isset.storageId = true;
}

void UserConfigurationDataModel::__set_experimentDataDir(const std::string& val) {
  this->experimentDataDir = val;
__isset.experimentDataDir = true;
}

void UserConfigurationDataModel::__set_useUserCRPref(const bool val) {
  this->useUserCRPref = val;
__isset.useUserCRPref = true;
}

uint32_t UserConfigurationDataModel::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_airavataAutoSchedule = false;
  bool isset_overrideManualScheduledParams = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->airavataAutoSchedule);
          isset_airavataAutoSchedule = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->overrideManualScheduledParams);
          isset_overrideManualScheduledParams = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->shareExperimentPublicly);
          this->__isset.shareExperimentPublicly = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->computationalResourceScheduling.read(iprot);
          this->__isset.computationalResourceScheduling = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->throttleResources);
          this->__isset.throttleResources = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->userDN);
          this->__isset.userDN = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->generateCert);
          this->__isset.generateCert = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->storageId);
          this->__isset.storageId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentDataDir);
          this->__isset.experimentDataDir = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->useUserCRPref);
          this->__isset.useUserCRPref = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_airavataAutoSchedule)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_overrideManualScheduledParams)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t UserConfigurationDataModel::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("UserConfigurationDataModel");

  xfer += oprot->writeFieldBegin("airavataAutoSchedule", ::apache::thrift::protocol::T_BOOL, 1);
  xfer += oprot->writeBool(this->airavataAutoSchedule);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("overrideManualScheduledParams", ::apache::thrift::protocol::T_BOOL, 2);
  xfer += oprot->writeBool(this->overrideManualScheduledParams);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.shareExperimentPublicly) {
    xfer += oprot->writeFieldBegin("shareExperimentPublicly", ::apache::thrift::protocol::T_BOOL, 3);
    xfer += oprot->writeBool(this->shareExperimentPublicly);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.computationalResourceScheduling) {
    xfer += oprot->writeFieldBegin("computationalResourceScheduling", ::apache::thrift::protocol::T_STRUCT, 4);
    xfer += this->computationalResourceScheduling.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.throttleResources) {
    xfer += oprot->writeFieldBegin("throttleResources", ::apache::thrift::protocol::T_BOOL, 5);
    xfer += oprot->writeBool(this->throttleResources);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.userDN) {
    xfer += oprot->writeFieldBegin("userDN", ::apache::thrift::protocol::T_STRING, 6);
    xfer += oprot->writeString(this->userDN);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.generateCert) {
    xfer += oprot->writeFieldBegin("generateCert", ::apache::thrift::protocol::T_BOOL, 7);
    xfer += oprot->writeBool(this->generateCert);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.storageId) {
    xfer += oprot->writeFieldBegin("storageId", ::apache::thrift::protocol::T_STRING, 8);
    xfer += oprot->writeString(this->storageId);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.experimentDataDir) {
    xfer += oprot->writeFieldBegin("experimentDataDir", ::apache::thrift::protocol::T_STRING, 9);
    xfer += oprot->writeString(this->experimentDataDir);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.useUserCRPref) {
    xfer += oprot->writeFieldBegin("useUserCRPref", ::apache::thrift::protocol::T_BOOL, 10);
    xfer += oprot->writeBool(this->useUserCRPref);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(UserConfigurationDataModel &a, UserConfigurationDataModel &b) {
  using ::std::swap;
  swap(a.airavataAutoSchedule, b.airavataAutoSchedule);
  swap(a.overrideManualScheduledParams, b.overrideManualScheduledParams);
  swap(a.shareExperimentPublicly, b.shareExperimentPublicly);
  swap(a.computationalResourceScheduling, b.computationalResourceScheduling);
  swap(a.throttleResources, b.throttleResources);
  swap(a.userDN, b.userDN);
  swap(a.generateCert, b.generateCert);
  swap(a.storageId, b.storageId);
  swap(a.experimentDataDir, b.experimentDataDir);
  swap(a.useUserCRPref, b.useUserCRPref);
  swap(a.__isset, b.__isset);
}

UserConfigurationDataModel::UserConfigurationDataModel(const UserConfigurationDataModel& other0) {
  airavataAutoSchedule = other0.airavataAutoSchedule;
  overrideManualScheduledParams = other0.overrideManualScheduledParams;
  shareExperimentPublicly = other0.shareExperimentPublicly;
  computationalResourceScheduling = other0.computationalResourceScheduling;
  throttleResources = other0.throttleResources;
  userDN = other0.userDN;
  generateCert = other0.generateCert;
  storageId = other0.storageId;
  experimentDataDir = other0.experimentDataDir;
  useUserCRPref = other0.useUserCRPref;
  __isset = other0.__isset;
}
UserConfigurationDataModel& UserConfigurationDataModel::operator=(const UserConfigurationDataModel& other1) {
  airavataAutoSchedule = other1.airavataAutoSchedule;
  overrideManualScheduledParams = other1.overrideManualScheduledParams;
  shareExperimentPublicly = other1.shareExperimentPublicly;
  computationalResourceScheduling = other1.computationalResourceScheduling;
  throttleResources = other1.throttleResources;
  userDN = other1.userDN;
  generateCert = other1.generateCert;
  storageId = other1.storageId;
  experimentDataDir = other1.experimentDataDir;
  useUserCRPref = other1.useUserCRPref;
  __isset = other1.__isset;
  return *this;
}
void UserConfigurationDataModel::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "UserConfigurationDataModel(";
  out << "airavataAutoSchedule=" << to_string(airavataAutoSchedule);
  out << ", " << "overrideManualScheduledParams=" << to_string(overrideManualScheduledParams);
  out << ", " << "shareExperimentPublicly="; (__isset.shareExperimentPublicly ? (out << to_string(shareExperimentPublicly)) : (out << "<null>"));
  out << ", " << "computationalResourceScheduling="; (__isset.computationalResourceScheduling ? (out << to_string(computationalResourceScheduling)) : (out << "<null>"));
  out << ", " << "throttleResources="; (__isset.throttleResources ? (out << to_string(throttleResources)) : (out << "<null>"));
  out << ", " << "userDN="; (__isset.userDN ? (out << to_string(userDN)) : (out << "<null>"));
  out << ", " << "generateCert="; (__isset.generateCert ? (out << to_string(generateCert)) : (out << "<null>"));
  out << ", " << "storageId="; (__isset.storageId ? (out << to_string(storageId)) : (out << "<null>"));
  out << ", " << "experimentDataDir="; (__isset.experimentDataDir ? (out << to_string(experimentDataDir)) : (out << "<null>"));
  out << ", " << "useUserCRPref="; (__isset.useUserCRPref ? (out << to_string(useUserCRPref)) : (out << "<null>"));
  out << ")";
}


ExperimentModel::~ExperimentModel() throw() {
}


void ExperimentModel::__set_experimentId(const std::string& val) {
  this->experimentId = val;
}

void ExperimentModel::__set_projectId(const std::string& val) {
  this->projectId = val;
}

void ExperimentModel::__set_gatewayId(const std::string& val) {
  this->gatewayId = val;
}

void ExperimentModel::__set_experimentType(const ExperimentType::type val) {
  this->experimentType = val;
}

void ExperimentModel::__set_userName(const std::string& val) {
  this->userName = val;
}

void ExperimentModel::__set_experimentName(const std::string& val) {
  this->experimentName = val;
}

void ExperimentModel::__set_creationTime(const int64_t val) {
  this->creationTime = val;
__isset.creationTime = true;
}

void ExperimentModel::__set_description(const std::string& val) {
  this->description = val;
__isset.description = true;
}

void ExperimentModel::__set_executionId(const std::string& val) {
  this->executionId = val;
__isset.executionId = true;
}

void ExperimentModel::__set_gatewayExecutionId(const std::string& val) {
  this->gatewayExecutionId = val;
__isset.gatewayExecutionId = true;
}

void ExperimentModel::__set_gatewayInstanceId(const std::string& val) {
  this->gatewayInstanceId = val;
__isset.gatewayInstanceId = true;
}

void ExperimentModel::__set_enableEmailNotification(const bool val) {
  this->enableEmailNotification = val;
__isset.enableEmailNotification = true;
}

void ExperimentModel::__set_emailAddresses(const std::vector<std::string> & val) {
  this->emailAddresses = val;
__isset.emailAddresses = true;
}

void ExperimentModel::__set_userConfigurationData(const UserConfigurationDataModel& val) {
  this->userConfigurationData = val;
__isset.userConfigurationData = true;
}

void ExperimentModel::__set_experimentInputs(const std::vector< ::apache::airavata::model::application::io::InputDataObjectType> & val) {
  this->experimentInputs = val;
__isset.experimentInputs = true;
}

void ExperimentModel::__set_experimentOutputs(const std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & val) {
  this->experimentOutputs = val;
__isset.experimentOutputs = true;
}

void ExperimentModel::__set_experimentStatus(const std::vector< ::apache::airavata::model::status::ExperimentStatus> & val) {
  this->experimentStatus = val;
__isset.experimentStatus = true;
}

void ExperimentModel::__set_errors(const std::vector< ::apache::airavata::model::commons::ErrorModel> & val) {
  this->errors = val;
__isset.errors = true;
}

void ExperimentModel::__set_processes(const std::vector< ::apache::airavata::model::process::ProcessModel> & val) {
  this->processes = val;
__isset.processes = true;
}

uint32_t ExperimentModel::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_experimentId = false;
  bool isset_projectId = false;
  bool isset_gatewayId = false;
  bool isset_experimentType = false;
  bool isset_userName = false;
  bool isset_experimentName = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentId);
          isset_experimentId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->projectId);
          isset_projectId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayId);
          isset_gatewayId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast2;
          xfer += iprot->readI32(ecast2);
          this->experimentType = (ExperimentType::type)ecast2;
          isset_experimentType = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->userName);
          isset_userName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentName);
          isset_experimentName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->creationTime);
          this->__isset.creationTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->description);
          this->__isset.description = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->executionId);
          this->__isset.executionId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayExecutionId);
          this->__isset.gatewayExecutionId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 11:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayInstanceId);
          this->__isset.gatewayInstanceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 12:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->enableEmailNotification);
          this->__isset.enableEmailNotification = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 13:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->emailAddresses.clear();
            uint32_t _size3;
            ::apache::thrift::protocol::TType _etype6;
            xfer += iprot->readListBegin(_etype6, _size3);
            this->emailAddresses.resize(_size3);
            uint32_t _i7;
            for (_i7 = 0; _i7 < _size3; ++_i7)
            {
              xfer += iprot->readString(this->emailAddresses[_i7]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.emailAddresses = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 14:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->userConfigurationData.read(iprot);
          this->__isset.userConfigurationData = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 15:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->experimentInputs.clear();
            uint32_t _size8;
            ::apache::thrift::protocol::TType _etype11;
            xfer += iprot->readListBegin(_etype11, _size8);
            this->experimentInputs.resize(_size8);
            uint32_t _i12;
            for (_i12 = 0; _i12 < _size8; ++_i12)
            {
              xfer += this->experimentInputs[_i12].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.experimentInputs = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 16:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->experimentOutputs.clear();
            uint32_t _size13;
            ::apache::thrift::protocol::TType _etype16;
            xfer += iprot->readListBegin(_etype16, _size13);
            this->experimentOutputs.resize(_size13);
            uint32_t _i17;
            for (_i17 = 0; _i17 < _size13; ++_i17)
            {
              xfer += this->experimentOutputs[_i17].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.experimentOutputs = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 17:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->experimentStatus.clear();
            uint32_t _size18;
            ::apache::thrift::protocol::TType _etype21;
            xfer += iprot->readListBegin(_etype21, _size18);
            this->experimentStatus.resize(_size18);
            uint32_t _i22;
            for (_i22 = 0; _i22 < _size18; ++_i22)
            {
              xfer += this->experimentStatus[_i22].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.experimentStatus = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 18:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->errors.clear();
            uint32_t _size23;
            ::apache::thrift::protocol::TType _etype26;
            xfer += iprot->readListBegin(_etype26, _size23);
            this->errors.resize(_size23);
            uint32_t _i27;
            for (_i27 = 0; _i27 < _size23; ++_i27)
            {
              xfer += this->errors[_i27].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.errors = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 19:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->processes.clear();
            uint32_t _size28;
            ::apache::thrift::protocol::TType _etype31;
            xfer += iprot->readListBegin(_etype31, _size28);
            this->processes.resize(_size28);
            uint32_t _i32;
            for (_i32 = 0; _i32 < _size28; ++_i32)
            {
              xfer += this->processes[_i32].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.processes = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_experimentId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_projectId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gatewayId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_experimentType)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_userName)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_experimentName)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ExperimentModel::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ExperimentModel");

  xfer += oprot->writeFieldBegin("experimentId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->experimentId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("projectId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->projectId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gatewayId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->gatewayId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("experimentType", ::apache::thrift::protocol::T_I32, 4);
  xfer += oprot->writeI32((int32_t)this->experimentType);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("userName", ::apache::thrift::protocol::T_STRING, 5);
  xfer += oprot->writeString(this->userName);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("experimentName", ::apache::thrift::protocol::T_STRING, 6);
  xfer += oprot->writeString(this->experimentName);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.creationTime) {
    xfer += oprot->writeFieldBegin("creationTime", ::apache::thrift::protocol::T_I64, 7);
    xfer += oprot->writeI64(this->creationTime);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.description) {
    xfer += oprot->writeFieldBegin("description", ::apache::thrift::protocol::T_STRING, 8);
    xfer += oprot->writeString(this->description);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.executionId) {
    xfer += oprot->writeFieldBegin("executionId", ::apache::thrift::protocol::T_STRING, 9);
    xfer += oprot->writeString(this->executionId);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.gatewayExecutionId) {
    xfer += oprot->writeFieldBegin("gatewayExecutionId", ::apache::thrift::protocol::T_STRING, 10);
    xfer += oprot->writeString(this->gatewayExecutionId);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.gatewayInstanceId) {
    xfer += oprot->writeFieldBegin("gatewayInstanceId", ::apache::thrift::protocol::T_STRING, 11);
    xfer += oprot->writeString(this->gatewayInstanceId);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.enableEmailNotification) {
    xfer += oprot->writeFieldBegin("enableEmailNotification", ::apache::thrift::protocol::T_BOOL, 12);
    xfer += oprot->writeBool(this->enableEmailNotification);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.emailAddresses) {
    xfer += oprot->writeFieldBegin("emailAddresses", ::apache::thrift::protocol::T_LIST, 13);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->emailAddresses.size()));
      std::vector<std::string> ::const_iterator _iter33;
      for (_iter33 = this->emailAddresses.begin(); _iter33 != this->emailAddresses.end(); ++_iter33)
      {
        xfer += oprot->writeString((*_iter33));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.userConfigurationData) {
    xfer += oprot->writeFieldBegin("userConfigurationData", ::apache::thrift::protocol::T_STRUCT, 14);
    xfer += this->userConfigurationData.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.experimentInputs) {
    xfer += oprot->writeFieldBegin("experimentInputs", ::apache::thrift::protocol::T_LIST, 15);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->experimentInputs.size()));
      std::vector< ::apache::airavata::model::application::io::InputDataObjectType> ::const_iterator _iter34;
      for (_iter34 = this->experimentInputs.begin(); _iter34 != this->experimentInputs.end(); ++_iter34)
      {
        xfer += (*_iter34).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.experimentOutputs) {
    xfer += oprot->writeFieldBegin("experimentOutputs", ::apache::thrift::protocol::T_LIST, 16);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->experimentOutputs.size()));
      std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> ::const_iterator _iter35;
      for (_iter35 = this->experimentOutputs.begin(); _iter35 != this->experimentOutputs.end(); ++_iter35)
      {
        xfer += (*_iter35).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.experimentStatus) {
    xfer += oprot->writeFieldBegin("experimentStatus", ::apache::thrift::protocol::T_LIST, 17);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->experimentStatus.size()));
      std::vector< ::apache::airavata::model::status::ExperimentStatus> ::const_iterator _iter36;
      for (_iter36 = this->experimentStatus.begin(); _iter36 != this->experimentStatus.end(); ++_iter36)
      {
        xfer += (*_iter36).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.errors) {
    xfer += oprot->writeFieldBegin("errors", ::apache::thrift::protocol::T_LIST, 18);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->errors.size()));
      std::vector< ::apache::airavata::model::commons::ErrorModel> ::const_iterator _iter37;
      for (_iter37 = this->errors.begin(); _iter37 != this->errors.end(); ++_iter37)
      {
        xfer += (*_iter37).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.processes) {
    xfer += oprot->writeFieldBegin("processes", ::apache::thrift::protocol::T_LIST, 19);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->processes.size()));
      std::vector< ::apache::airavata::model::process::ProcessModel> ::const_iterator _iter38;
      for (_iter38 = this->processes.begin(); _iter38 != this->processes.end(); ++_iter38)
      {
        xfer += (*_iter38).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ExperimentModel &a, ExperimentModel &b) {
  using ::std::swap;
  swap(a.experimentId, b.experimentId);
  swap(a.projectId, b.projectId);
  swap(a.gatewayId, b.gatewayId);
  swap(a.experimentType, b.experimentType);
  swap(a.userName, b.userName);
  swap(a.experimentName, b.experimentName);
  swap(a.creationTime, b.creationTime);
  swap(a.description, b.description);
  swap(a.executionId, b.executionId);
  swap(a.gatewayExecutionId, b.gatewayExecutionId);
  swap(a.gatewayInstanceId, b.gatewayInstanceId);
  swap(a.enableEmailNotification, b.enableEmailNotification);
  swap(a.emailAddresses, b.emailAddresses);
  swap(a.userConfigurationData, b.userConfigurationData);
  swap(a.experimentInputs, b.experimentInputs);
  swap(a.experimentOutputs, b.experimentOutputs);
  swap(a.experimentStatus, b.experimentStatus);
  swap(a.errors, b.errors);
  swap(a.processes, b.processes);
  swap(a.__isset, b.__isset);
}

ExperimentModel::ExperimentModel(const ExperimentModel& other39) {
  experimentId = other39.experimentId;
  projectId = other39.projectId;
  gatewayId = other39.gatewayId;
  experimentType = other39.experimentType;
  userName = other39.userName;
  experimentName = other39.experimentName;
  creationTime = other39.creationTime;
  description = other39.description;
  executionId = other39.executionId;
  gatewayExecutionId = other39.gatewayExecutionId;
  gatewayInstanceId = other39.gatewayInstanceId;
  enableEmailNotification = other39.enableEmailNotification;
  emailAddresses = other39.emailAddresses;
  userConfigurationData = other39.userConfigurationData;
  experimentInputs = other39.experimentInputs;
  experimentOutputs = other39.experimentOutputs;
  experimentStatus = other39.experimentStatus;
  errors = other39.errors;
  processes = other39.processes;
  __isset = other39.__isset;
}
ExperimentModel& ExperimentModel::operator=(const ExperimentModel& other40) {
  experimentId = other40.experimentId;
  projectId = other40.projectId;
  gatewayId = other40.gatewayId;
  experimentType = other40.experimentType;
  userName = other40.userName;
  experimentName = other40.experimentName;
  creationTime = other40.creationTime;
  description = other40.description;
  executionId = other40.executionId;
  gatewayExecutionId = other40.gatewayExecutionId;
  gatewayInstanceId = other40.gatewayInstanceId;
  enableEmailNotification = other40.enableEmailNotification;
  emailAddresses = other40.emailAddresses;
  userConfigurationData = other40.userConfigurationData;
  experimentInputs = other40.experimentInputs;
  experimentOutputs = other40.experimentOutputs;
  experimentStatus = other40.experimentStatus;
  errors = other40.errors;
  processes = other40.processes;
  __isset = other40.__isset;
  return *this;
}
void ExperimentModel::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ExperimentModel(";
  out << "experimentId=" << to_string(experimentId);
  out << ", " << "projectId=" << to_string(projectId);
  out << ", " << "gatewayId=" << to_string(gatewayId);
  out << ", " << "experimentType=" << to_string(experimentType);
  out << ", " << "userName=" << to_string(userName);
  out << ", " << "experimentName=" << to_string(experimentName);
  out << ", " << "creationTime="; (__isset.creationTime ? (out << to_string(creationTime)) : (out << "<null>"));
  out << ", " << "description="; (__isset.description ? (out << to_string(description)) : (out << "<null>"));
  out << ", " << "executionId="; (__isset.executionId ? (out << to_string(executionId)) : (out << "<null>"));
  out << ", " << "gatewayExecutionId="; (__isset.gatewayExecutionId ? (out << to_string(gatewayExecutionId)) : (out << "<null>"));
  out << ", " << "gatewayInstanceId="; (__isset.gatewayInstanceId ? (out << to_string(gatewayInstanceId)) : (out << "<null>"));
  out << ", " << "enableEmailNotification="; (__isset.enableEmailNotification ? (out << to_string(enableEmailNotification)) : (out << "<null>"));
  out << ", " << "emailAddresses="; (__isset.emailAddresses ? (out << to_string(emailAddresses)) : (out << "<null>"));
  out << ", " << "userConfigurationData="; (__isset.userConfigurationData ? (out << to_string(userConfigurationData)) : (out << "<null>"));
  out << ", " << "experimentInputs="; (__isset.experimentInputs ? (out << to_string(experimentInputs)) : (out << "<null>"));
  out << ", " << "experimentOutputs="; (__isset.experimentOutputs ? (out << to_string(experimentOutputs)) : (out << "<null>"));
  out << ", " << "experimentStatus="; (__isset.experimentStatus ? (out << to_string(experimentStatus)) : (out << "<null>"));
  out << ", " << "errors="; (__isset.errors ? (out << to_string(errors)) : (out << "<null>"));
  out << ", " << "processes="; (__isset.processes ? (out << to_string(processes)) : (out << "<null>"));
  out << ")";
}


ExperimentSummaryModel::~ExperimentSummaryModel() throw() {
}


void ExperimentSummaryModel::__set_experimentId(const std::string& val) {
  this->experimentId = val;
}

void ExperimentSummaryModel::__set_projectId(const std::string& val) {
  this->projectId = val;
}

void ExperimentSummaryModel::__set_gatewayId(const std::string& val) {
  this->gatewayId = val;
}

void ExperimentSummaryModel::__set_creationTime(const int64_t val) {
  this->creationTime = val;
__isset.creationTime = true;
}

void ExperimentSummaryModel::__set_userName(const std::string& val) {
  this->userName = val;
}

void ExperimentSummaryModel::__set_name(const std::string& val) {
  this->name = val;
}

void ExperimentSummaryModel::__set_description(const std::string& val) {
  this->description = val;
__isset.description = true;
}

void ExperimentSummaryModel::__set_executionId(const std::string& val) {
  this->executionId = val;
__isset.executionId = true;
}

void ExperimentSummaryModel::__set_resourceHostId(const std::string& val) {
  this->resourceHostId = val;
__isset.resourceHostId = true;
}

void ExperimentSummaryModel::__set_experimentStatus(const std::string& val) {
  this->experimentStatus = val;
__isset.experimentStatus = true;
}

void ExperimentSummaryModel::__set_statusUpdateTime(const int64_t val) {
  this->statusUpdateTime = val;
__isset.statusUpdateTime = true;
}

uint32_t ExperimentSummaryModel::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_experimentId = false;
  bool isset_projectId = false;
  bool isset_gatewayId = false;
  bool isset_userName = false;
  bool isset_name = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentId);
          isset_experimentId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->projectId);
          isset_projectId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayId);
          isset_gatewayId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->creationTime);
          this->__isset.creationTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->userName);
          isset_userName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->name);
          isset_name = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->description);
          this->__isset.description = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->executionId);
          this->__isset.executionId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->resourceHostId);
          this->__isset.resourceHostId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentStatus);
          this->__isset.experimentStatus = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 12:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->statusUpdateTime);
          this->__isset.statusUpdateTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_experimentId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_projectId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gatewayId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_userName)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_name)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ExperimentSummaryModel::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ExperimentSummaryModel");

  xfer += oprot->writeFieldBegin("experimentId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->experimentId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("projectId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->projectId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gatewayId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->gatewayId);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.creationTime) {
    xfer += oprot->writeFieldBegin("creationTime", ::apache::thrift::protocol::T_I64, 4);
    xfer += oprot->writeI64(this->creationTime);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldBegin("userName", ::apache::thrift::protocol::T_STRING, 5);
  xfer += oprot->writeString(this->userName);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("name", ::apache::thrift::protocol::T_STRING, 6);
  xfer += oprot->writeString(this->name);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.description) {
    xfer += oprot->writeFieldBegin("description", ::apache::thrift::protocol::T_STRING, 7);
    xfer += oprot->writeString(this->description);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.executionId) {
    xfer += oprot->writeFieldBegin("executionId", ::apache::thrift::protocol::T_STRING, 8);
    xfer += oprot->writeString(this->executionId);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.resourceHostId) {
    xfer += oprot->writeFieldBegin("resourceHostId", ::apache::thrift::protocol::T_STRING, 9);
    xfer += oprot->writeString(this->resourceHostId);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.experimentStatus) {
    xfer += oprot->writeFieldBegin("experimentStatus", ::apache::thrift::protocol::T_STRING, 10);
    xfer += oprot->writeString(this->experimentStatus);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.statusUpdateTime) {
    xfer += oprot->writeFieldBegin("statusUpdateTime", ::apache::thrift::protocol::T_I64, 12);
    xfer += oprot->writeI64(this->statusUpdateTime);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ExperimentSummaryModel &a, ExperimentSummaryModel &b) {
  using ::std::swap;
  swap(a.experimentId, b.experimentId);
  swap(a.projectId, b.projectId);
  swap(a.gatewayId, b.gatewayId);
  swap(a.creationTime, b.creationTime);
  swap(a.userName, b.userName);
  swap(a.name, b.name);
  swap(a.description, b.description);
  swap(a.executionId, b.executionId);
  swap(a.resourceHostId, b.resourceHostId);
  swap(a.experimentStatus, b.experimentStatus);
  swap(a.statusUpdateTime, b.statusUpdateTime);
  swap(a.__isset, b.__isset);
}

ExperimentSummaryModel::ExperimentSummaryModel(const ExperimentSummaryModel& other41) {
  experimentId = other41.experimentId;
  projectId = other41.projectId;
  gatewayId = other41.gatewayId;
  creationTime = other41.creationTime;
  userName = other41.userName;
  name = other41.name;
  description = other41.description;
  executionId = other41.executionId;
  resourceHostId = other41.resourceHostId;
  experimentStatus = other41.experimentStatus;
  statusUpdateTime = other41.statusUpdateTime;
  __isset = other41.__isset;
}
ExperimentSummaryModel& ExperimentSummaryModel::operator=(const ExperimentSummaryModel& other42) {
  experimentId = other42.experimentId;
  projectId = other42.projectId;
  gatewayId = other42.gatewayId;
  creationTime = other42.creationTime;
  userName = other42.userName;
  name = other42.name;
  description = other42.description;
  executionId = other42.executionId;
  resourceHostId = other42.resourceHostId;
  experimentStatus = other42.experimentStatus;
  statusUpdateTime = other42.statusUpdateTime;
  __isset = other42.__isset;
  return *this;
}
void ExperimentSummaryModel::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ExperimentSummaryModel(";
  out << "experimentId=" << to_string(experimentId);
  out << ", " << "projectId=" << to_string(projectId);
  out << ", " << "gatewayId=" << to_string(gatewayId);
  out << ", " << "creationTime="; (__isset.creationTime ? (out << to_string(creationTime)) : (out << "<null>"));
  out << ", " << "userName=" << to_string(userName);
  out << ", " << "name=" << to_string(name);
  out << ", " << "description="; (__isset.description ? (out << to_string(description)) : (out << "<null>"));
  out << ", " << "executionId="; (__isset.executionId ? (out << to_string(executionId)) : (out << "<null>"));
  out << ", " << "resourceHostId="; (__isset.resourceHostId ? (out << to_string(resourceHostId)) : (out << "<null>"));
  out << ", " << "experimentStatus="; (__isset.experimentStatus ? (out << to_string(experimentStatus)) : (out << "<null>"));
  out << ", " << "statusUpdateTime="; (__isset.statusUpdateTime ? (out << to_string(statusUpdateTime)) : (out << "<null>"));
  out << ")";
}


ExperimentStatistics::~ExperimentStatistics() throw() {
}


void ExperimentStatistics::__set_allExperimentCount(const int32_t val) {
  this->allExperimentCount = val;
}

void ExperimentStatistics::__set_completedExperimentCount(const int32_t val) {
  this->completedExperimentCount = val;
}

void ExperimentStatistics::__set_cancelledExperimentCount(const int32_t val) {
  this->cancelledExperimentCount = val;
__isset.cancelledExperimentCount = true;
}

void ExperimentStatistics::__set_failedExperimentCount(const int32_t val) {
  this->failedExperimentCount = val;
}

void ExperimentStatistics::__set_createdExperimentCount(const int32_t val) {
  this->createdExperimentCount = val;
}

void ExperimentStatistics::__set_runningExperimentCount(const int32_t val) {
  this->runningExperimentCount = val;
}

void ExperimentStatistics::__set_allExperiments(const std::vector<ExperimentSummaryModel> & val) {
  this->allExperiments = val;
}

void ExperimentStatistics::__set_completedExperiments(const std::vector<ExperimentSummaryModel> & val) {
  this->completedExperiments = val;
__isset.completedExperiments = true;
}

void ExperimentStatistics::__set_failedExperiments(const std::vector<ExperimentSummaryModel> & val) {
  this->failedExperiments = val;
__isset.failedExperiments = true;
}

void ExperimentStatistics::__set_cancelledExperiments(const std::vector<ExperimentSummaryModel> & val) {
  this->cancelledExperiments = val;
__isset.cancelledExperiments = true;
}

void ExperimentStatistics::__set_createdExperiments(const std::vector<ExperimentSummaryModel> & val) {
  this->createdExperiments = val;
__isset.createdExperiments = true;
}

void ExperimentStatistics::__set_runningExperiments(const std::vector<ExperimentSummaryModel> & val) {
  this->runningExperiments = val;
__isset.runningExperiments = true;
}

uint32_t ExperimentStatistics::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_allExperimentCount = false;
  bool isset_completedExperimentCount = false;
  bool isset_failedExperimentCount = false;
  bool isset_createdExperimentCount = false;
  bool isset_runningExperimentCount = false;
  bool isset_allExperiments = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->allExperimentCount);
          isset_allExperimentCount = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->completedExperimentCount);
          isset_completedExperimentCount = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->cancelledExperimentCount);
          this->__isset.cancelledExperimentCount = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->failedExperimentCount);
          isset_failedExperimentCount = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->createdExperimentCount);
          isset_createdExperimentCount = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->runningExperimentCount);
          isset_runningExperimentCount = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->allExperiments.clear();
            uint32_t _size43;
            ::apache::thrift::protocol::TType _etype46;
            xfer += iprot->readListBegin(_etype46, _size43);
            this->allExperiments.resize(_size43);
            uint32_t _i47;
            for (_i47 = 0; _i47 < _size43; ++_i47)
            {
              xfer += this->allExperiments[_i47].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          isset_allExperiments = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->completedExperiments.clear();
            uint32_t _size48;
            ::apache::thrift::protocol::TType _etype51;
            xfer += iprot->readListBegin(_etype51, _size48);
            this->completedExperiments.resize(_size48);
            uint32_t _i52;
            for (_i52 = 0; _i52 < _size48; ++_i52)
            {
              xfer += this->completedExperiments[_i52].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.completedExperiments = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->failedExperiments.clear();
            uint32_t _size53;
            ::apache::thrift::protocol::TType _etype56;
            xfer += iprot->readListBegin(_etype56, _size53);
            this->failedExperiments.resize(_size53);
            uint32_t _i57;
            for (_i57 = 0; _i57 < _size53; ++_i57)
            {
              xfer += this->failedExperiments[_i57].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.failedExperiments = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->cancelledExperiments.clear();
            uint32_t _size58;
            ::apache::thrift::protocol::TType _etype61;
            xfer += iprot->readListBegin(_etype61, _size58);
            this->cancelledExperiments.resize(_size58);
            uint32_t _i62;
            for (_i62 = 0; _i62 < _size58; ++_i62)
            {
              xfer += this->cancelledExperiments[_i62].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.cancelledExperiments = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 11:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->createdExperiments.clear();
            uint32_t _size63;
            ::apache::thrift::protocol::TType _etype66;
            xfer += iprot->readListBegin(_etype66, _size63);
            this->createdExperiments.resize(_size63);
            uint32_t _i67;
            for (_i67 = 0; _i67 < _size63; ++_i67)
            {
              xfer += this->createdExperiments[_i67].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.createdExperiments = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 12:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->runningExperiments.clear();
            uint32_t _size68;
            ::apache::thrift::protocol::TType _etype71;
            xfer += iprot->readListBegin(_etype71, _size68);
            this->runningExperiments.resize(_size68);
            uint32_t _i72;
            for (_i72 = 0; _i72 < _size68; ++_i72)
            {
              xfer += this->runningExperiments[_i72].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.runningExperiments = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_allExperimentCount)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_completedExperimentCount)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_failedExperimentCount)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_createdExperimentCount)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_runningExperimentCount)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_allExperiments)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ExperimentStatistics::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ExperimentStatistics");

  xfer += oprot->writeFieldBegin("allExperimentCount", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32(this->allExperimentCount);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("completedExperimentCount", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32(this->completedExperimentCount);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.cancelledExperimentCount) {
    xfer += oprot->writeFieldBegin("cancelledExperimentCount", ::apache::thrift::protocol::T_I32, 3);
    xfer += oprot->writeI32(this->cancelledExperimentCount);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldBegin("failedExperimentCount", ::apache::thrift::protocol::T_I32, 4);
  xfer += oprot->writeI32(this->failedExperimentCount);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("createdExperimentCount", ::apache::thrift::protocol::T_I32, 5);
  xfer += oprot->writeI32(this->createdExperimentCount);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("runningExperimentCount", ::apache::thrift::protocol::T_I32, 6);
  xfer += oprot->writeI32(this->runningExperimentCount);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("allExperiments", ::apache::thrift::protocol::T_LIST, 7);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->allExperiments.size()));
    std::vector<ExperimentSummaryModel> ::const_iterator _iter73;
    for (_iter73 = this->allExperiments.begin(); _iter73 != this->allExperiments.end(); ++_iter73)
    {
      xfer += (*_iter73).write(oprot);
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  if (this->__isset.completedExperiments) {
    xfer += oprot->writeFieldBegin("completedExperiments", ::apache::thrift::protocol::T_LIST, 8);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->completedExperiments.size()));
      std::vector<ExperimentSummaryModel> ::const_iterator _iter74;
      for (_iter74 = this->completedExperiments.begin(); _iter74 != this->completedExperiments.end(); ++_iter74)
      {
        xfer += (*_iter74).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.failedExperiments) {
    xfer += oprot->writeFieldBegin("failedExperiments", ::apache::thrift::protocol::T_LIST, 9);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->failedExperiments.size()));
      std::vector<ExperimentSummaryModel> ::const_iterator _iter75;
      for (_iter75 = this->failedExperiments.begin(); _iter75 != this->failedExperiments.end(); ++_iter75)
      {
        xfer += (*_iter75).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.cancelledExperiments) {
    xfer += oprot->writeFieldBegin("cancelledExperiments", ::apache::thrift::protocol::T_LIST, 10);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->cancelledExperiments.size()));
      std::vector<ExperimentSummaryModel> ::const_iterator _iter76;
      for (_iter76 = this->cancelledExperiments.begin(); _iter76 != this->cancelledExperiments.end(); ++_iter76)
      {
        xfer += (*_iter76).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.createdExperiments) {
    xfer += oprot->writeFieldBegin("createdExperiments", ::apache::thrift::protocol::T_LIST, 11);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->createdExperiments.size()));
      std::vector<ExperimentSummaryModel> ::const_iterator _iter77;
      for (_iter77 = this->createdExperiments.begin(); _iter77 != this->createdExperiments.end(); ++_iter77)
      {
        xfer += (*_iter77).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.runningExperiments) {
    xfer += oprot->writeFieldBegin("runningExperiments", ::apache::thrift::protocol::T_LIST, 12);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->runningExperiments.size()));
      std::vector<ExperimentSummaryModel> ::const_iterator _iter78;
      for (_iter78 = this->runningExperiments.begin(); _iter78 != this->runningExperiments.end(); ++_iter78)
      {
        xfer += (*_iter78).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ExperimentStatistics &a, ExperimentStatistics &b) {
  using ::std::swap;
  swap(a.allExperimentCount, b.allExperimentCount);
  swap(a.completedExperimentCount, b.completedExperimentCount);
  swap(a.cancelledExperimentCount, b.cancelledExperimentCount);
  swap(a.failedExperimentCount, b.failedExperimentCount);
  swap(a.createdExperimentCount, b.createdExperimentCount);
  swap(a.runningExperimentCount, b.runningExperimentCount);
  swap(a.allExperiments, b.allExperiments);
  swap(a.completedExperiments, b.completedExperiments);
  swap(a.failedExperiments, b.failedExperiments);
  swap(a.cancelledExperiments, b.cancelledExperiments);
  swap(a.createdExperiments, b.createdExperiments);
  swap(a.runningExperiments, b.runningExperiments);
  swap(a.__isset, b.__isset);
}

ExperimentStatistics::ExperimentStatistics(const ExperimentStatistics& other79) {
  allExperimentCount = other79.allExperimentCount;
  completedExperimentCount = other79.completedExperimentCount;
  cancelledExperimentCount = other79.cancelledExperimentCount;
  failedExperimentCount = other79.failedExperimentCount;
  createdExperimentCount = other79.createdExperimentCount;
  runningExperimentCount = other79.runningExperimentCount;
  allExperiments = other79.allExperiments;
  completedExperiments = other79.completedExperiments;
  failedExperiments = other79.failedExperiments;
  cancelledExperiments = other79.cancelledExperiments;
  createdExperiments = other79.createdExperiments;
  runningExperiments = other79.runningExperiments;
  __isset = other79.__isset;
}
ExperimentStatistics& ExperimentStatistics::operator=(const ExperimentStatistics& other80) {
  allExperimentCount = other80.allExperimentCount;
  completedExperimentCount = other80.completedExperimentCount;
  cancelledExperimentCount = other80.cancelledExperimentCount;
  failedExperimentCount = other80.failedExperimentCount;
  createdExperimentCount = other80.createdExperimentCount;
  runningExperimentCount = other80.runningExperimentCount;
  allExperiments = other80.allExperiments;
  completedExperiments = other80.completedExperiments;
  failedExperiments = other80.failedExperiments;
  cancelledExperiments = other80.cancelledExperiments;
  createdExperiments = other80.createdExperiments;
  runningExperiments = other80.runningExperiments;
  __isset = other80.__isset;
  return *this;
}
void ExperimentStatistics::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ExperimentStatistics(";
  out << "allExperimentCount=" << to_string(allExperimentCount);
  out << ", " << "completedExperimentCount=" << to_string(completedExperimentCount);
  out << ", " << "cancelledExperimentCount="; (__isset.cancelledExperimentCount ? (out << to_string(cancelledExperimentCount)) : (out << "<null>"));
  out << ", " << "failedExperimentCount=" << to_string(failedExperimentCount);
  out << ", " << "createdExperimentCount=" << to_string(createdExperimentCount);
  out << ", " << "runningExperimentCount=" << to_string(runningExperimentCount);
  out << ", " << "allExperiments=" << to_string(allExperiments);
  out << ", " << "completedExperiments="; (__isset.completedExperiments ? (out << to_string(completedExperiments)) : (out << "<null>"));
  out << ", " << "failedExperiments="; (__isset.failedExperiments ? (out << to_string(failedExperiments)) : (out << "<null>"));
  out << ", " << "cancelledExperiments="; (__isset.cancelledExperiments ? (out << to_string(cancelledExperiments)) : (out << "<null>"));
  out << ", " << "createdExperiments="; (__isset.createdExperiments ? (out << to_string(createdExperiments)) : (out << "<null>"));
  out << ", " << "runningExperiments="; (__isset.runningExperiments ? (out << to_string(runningExperiments)) : (out << "<null>"));
  out << ")";
}

}}}} // namespace
