/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#include "task_model_types.h"

#include <algorithm>
#include <ostream>

#include <thrift/TToString.h>

namespace apache { namespace airavata { namespace model { namespace task {

int _kTaskTypesValues[] = {
  TaskTypes::ENV_SETUP,
  TaskTypes::DATA_STAGING,
  TaskTypes::JOB_SUBMISSION,
  TaskTypes::ENV_CLEANUP,
  TaskTypes::MONITORING,
  TaskTypes::OUTPUT_FETCHING
};
const char* _kTaskTypesNames[] = {
  "ENV_SETUP",
  "DATA_STAGING",
  "JOB_SUBMISSION",
  "ENV_CLEANUP",
  "MONITORING",
  "OUTPUT_FETCHING"
};
const std::map<int, const char*> _TaskTypes_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(6, _kTaskTypesValues, _kTaskTypesNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kDataStageTypeValues[] = {
  DataStageType::INPUT,
  DataStageType::OUPUT,
  DataStageType::ARCHIVE_OUTPUT
};
const char* _kDataStageTypeNames[] = {
  "INPUT",
  "OUPUT",
  "ARCHIVE_OUTPUT"
};
const std::map<int, const char*> _DataStageType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(3, _kDataStageTypeValues, _kDataStageTypeNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));


TaskModel::~TaskModel() throw() {
}


void TaskModel::__set_taskId(const std::string& val) {
  this->taskId = val;
}

void TaskModel::__set_taskType(const TaskTypes::type val) {
  this->taskType = val;
}

void TaskModel::__set_parentProcessId(const std::string& val) {
  this->parentProcessId = val;
}

void TaskModel::__set_creationTime(const int64_t val) {
  this->creationTime = val;
}

void TaskModel::__set_lastUpdateTime(const int64_t val) {
  this->lastUpdateTime = val;
}

void TaskModel::__set_taskStatuses(const std::vector< ::apache::airavata::model::status::TaskStatus> & val) {
  this->taskStatuses = val;
}

void TaskModel::__set_taskDetail(const std::string& val) {
  this->taskDetail = val;
__isset.taskDetail = true;
}

void TaskModel::__set_subTaskModel(const std::string& val) {
  this->subTaskModel = val;
__isset.subTaskModel = true;
}

void TaskModel::__set_taskErrors(const std::vector< ::apache::airavata::model::commons::ErrorModel> & val) {
  this->taskErrors = val;
__isset.taskErrors = true;
}

void TaskModel::__set_jobs(const std::vector< ::apache::airavata::model::job::JobModel> & val) {
  this->jobs = val;
__isset.jobs = true;
}

uint32_t TaskModel::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_taskId = false;
  bool isset_taskType = false;
  bool isset_parentProcessId = false;
  bool isset_creationTime = false;
  bool isset_lastUpdateTime = false;
  bool isset_taskStatuses = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->taskId);
          isset_taskId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast0;
          xfer += iprot->readI32(ecast0);
          this->taskType = (TaskTypes::type)ecast0;
          isset_taskType = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->parentProcessId);
          isset_parentProcessId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->creationTime);
          isset_creationTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->lastUpdateTime);
          isset_lastUpdateTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->taskStatuses.clear();
            uint32_t _size1;
            ::apache::thrift::protocol::TType _etype4;
            xfer += iprot->readListBegin(_etype4, _size1);
            this->taskStatuses.resize(_size1);
            uint32_t _i5;
            for (_i5 = 0; _i5 < _size1; ++_i5)
            {
              xfer += this->taskStatuses[_i5].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          isset_taskStatuses = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->taskDetail);
          this->__isset.taskDetail = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readBinary(this->subTaskModel);
          this->__isset.subTaskModel = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->taskErrors.clear();
            uint32_t _size6;
            ::apache::thrift::protocol::TType _etype9;
            xfer += iprot->readListBegin(_etype9, _size6);
            this->taskErrors.resize(_size6);
            uint32_t _i10;
            for (_i10 = 0; _i10 < _size6; ++_i10)
            {
              xfer += this->taskErrors[_i10].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.taskErrors = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->jobs.clear();
            uint32_t _size11;
            ::apache::thrift::protocol::TType _etype14;
            xfer += iprot->readListBegin(_etype14, _size11);
            this->jobs.resize(_size11);
            uint32_t _i15;
            for (_i15 = 0; _i15 < _size11; ++_i15)
            {
              xfer += this->jobs[_i15].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.jobs = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_taskId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_taskType)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_parentProcessId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_creationTime)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_lastUpdateTime)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_taskStatuses)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t TaskModel::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("TaskModel");

  xfer += oprot->writeFieldBegin("taskId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->taskId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("taskType", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->taskType);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("parentProcessId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->parentProcessId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("creationTime", ::apache::thrift::protocol::T_I64, 4);
  xfer += oprot->writeI64(this->creationTime);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("lastUpdateTime", ::apache::thrift::protocol::T_I64, 5);
  xfer += oprot->writeI64(this->lastUpdateTime);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("taskStatuses", ::apache::thrift::protocol::T_LIST, 6);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->taskStatuses.size()));
    std::vector< ::apache::airavata::model::status::TaskStatus> ::const_iterator _iter16;
    for (_iter16 = this->taskStatuses.begin(); _iter16 != this->taskStatuses.end(); ++_iter16)
    {
      xfer += (*_iter16).write(oprot);
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  if (this->__isset.taskDetail) {
    xfer += oprot->writeFieldBegin("taskDetail", ::apache::thrift::protocol::T_STRING, 7);
    xfer += oprot->writeString(this->taskDetail);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.subTaskModel) {
    xfer += oprot->writeFieldBegin("subTaskModel", ::apache::thrift::protocol::T_STRING, 8);
    xfer += oprot->writeBinary(this->subTaskModel);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.taskErrors) {
    xfer += oprot->writeFieldBegin("taskErrors", ::apache::thrift::protocol::T_LIST, 9);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->taskErrors.size()));
      std::vector< ::apache::airavata::model::commons::ErrorModel> ::const_iterator _iter17;
      for (_iter17 = this->taskErrors.begin(); _iter17 != this->taskErrors.end(); ++_iter17)
      {
        xfer += (*_iter17).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.jobs) {
    xfer += oprot->writeFieldBegin("jobs", ::apache::thrift::protocol::T_LIST, 10);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->jobs.size()));
      std::vector< ::apache::airavata::model::job::JobModel> ::const_iterator _iter18;
      for (_iter18 = this->jobs.begin(); _iter18 != this->jobs.end(); ++_iter18)
      {
        xfer += (*_iter18).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TaskModel &a, TaskModel &b) {
  using ::std::swap;
  swap(a.taskId, b.taskId);
  swap(a.taskType, b.taskType);
  swap(a.parentProcessId, b.parentProcessId);
  swap(a.creationTime, b.creationTime);
  swap(a.lastUpdateTime, b.lastUpdateTime);
  swap(a.taskStatuses, b.taskStatuses);
  swap(a.taskDetail, b.taskDetail);
  swap(a.subTaskModel, b.subTaskModel);
  swap(a.taskErrors, b.taskErrors);
  swap(a.jobs, b.jobs);
  swap(a.__isset, b.__isset);
}

TaskModel::TaskModel(const TaskModel& other19) {
  taskId = other19.taskId;
  taskType = other19.taskType;
  parentProcessId = other19.parentProcessId;
  creationTime = other19.creationTime;
  lastUpdateTime = other19.lastUpdateTime;
  taskStatuses = other19.taskStatuses;
  taskDetail = other19.taskDetail;
  subTaskModel = other19.subTaskModel;
  taskErrors = other19.taskErrors;
  jobs = other19.jobs;
  __isset = other19.__isset;
}
TaskModel& TaskModel::operator=(const TaskModel& other20) {
  taskId = other20.taskId;
  taskType = other20.taskType;
  parentProcessId = other20.parentProcessId;
  creationTime = other20.creationTime;
  lastUpdateTime = other20.lastUpdateTime;
  taskStatuses = other20.taskStatuses;
  taskDetail = other20.taskDetail;
  subTaskModel = other20.subTaskModel;
  taskErrors = other20.taskErrors;
  jobs = other20.jobs;
  __isset = other20.__isset;
  return *this;
}
void TaskModel::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "TaskModel(";
  out << "taskId=" << to_string(taskId);
  out << ", " << "taskType=" << to_string(taskType);
  out << ", " << "parentProcessId=" << to_string(parentProcessId);
  out << ", " << "creationTime=" << to_string(creationTime);
  out << ", " << "lastUpdateTime=" << to_string(lastUpdateTime);
  out << ", " << "taskStatuses=" << to_string(taskStatuses);
  out << ", " << "taskDetail="; (__isset.taskDetail ? (out << to_string(taskDetail)) : (out << "<null>"));
  out << ", " << "subTaskModel="; (__isset.subTaskModel ? (out << to_string(subTaskModel)) : (out << "<null>"));
  out << ", " << "taskErrors="; (__isset.taskErrors ? (out << to_string(taskErrors)) : (out << "<null>"));
  out << ", " << "jobs="; (__isset.jobs ? (out << to_string(jobs)) : (out << "<null>"));
  out << ")";
}


DataStagingTaskModel::~DataStagingTaskModel() throw() {
}


void DataStagingTaskModel::__set_source(const std::string& val) {
  this->source = val;
}

void DataStagingTaskModel::__set_destination(const std::string& val) {
  this->destination = val;
}

void DataStagingTaskModel::__set_type(const DataStageType::type val) {
  this->type = val;
}

void DataStagingTaskModel::__set_transferStartTime(const int64_t val) {
  this->transferStartTime = val;
__isset.transferStartTime = true;
}

void DataStagingTaskModel::__set_transferEndTime(const int64_t val) {
  this->transferEndTime = val;
__isset.transferEndTime = true;
}

void DataStagingTaskModel::__set_transferRate(const std::string& val) {
  this->transferRate = val;
__isset.transferRate = true;
}

void DataStagingTaskModel::__set_processInput(const  ::apache::airavata::model::application::io::InputDataObjectType& val) {
  this->processInput = val;
__isset.processInput = true;
}

void DataStagingTaskModel::__set_processOutput(const  ::apache::airavata::model::application::io::OutputDataObjectType& val) {
  this->processOutput = val;
__isset.processOutput = true;
}

uint32_t DataStagingTaskModel::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_source = false;
  bool isset_destination = false;
  bool isset_type = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->source);
          isset_source = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->destination);
          isset_destination = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast21;
          xfer += iprot->readI32(ecast21);
          this->type = (DataStageType::type)ecast21;
          isset_type = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->transferStartTime);
          this->__isset.transferStartTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->transferEndTime);
          this->__isset.transferEndTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->transferRate);
          this->__isset.transferRate = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->processInput.read(iprot);
          this->__isset.processInput = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->processOutput.read(iprot);
          this->__isset.processOutput = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_source)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_destination)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_type)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t DataStagingTaskModel::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("DataStagingTaskModel");

  xfer += oprot->writeFieldBegin("source", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->source);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("destination", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->destination);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("type", ::apache::thrift::protocol::T_I32, 3);
  xfer += oprot->writeI32((int32_t)this->type);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.transferStartTime) {
    xfer += oprot->writeFieldBegin("transferStartTime", ::apache::thrift::protocol::T_I64, 4);
    xfer += oprot->writeI64(this->transferStartTime);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.transferEndTime) {
    xfer += oprot->writeFieldBegin("transferEndTime", ::apache::thrift::protocol::T_I64, 5);
    xfer += oprot->writeI64(this->transferEndTime);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.transferRate) {
    xfer += oprot->writeFieldBegin("transferRate", ::apache::thrift::protocol::T_STRING, 6);
    xfer += oprot->writeString(this->transferRate);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.processInput) {
    xfer += oprot->writeFieldBegin("processInput", ::apache::thrift::protocol::T_STRUCT, 7);
    xfer += this->processInput.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.processOutput) {
    xfer += oprot->writeFieldBegin("processOutput", ::apache::thrift::protocol::T_STRUCT, 8);
    xfer += this->processOutput.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(DataStagingTaskModel &a, DataStagingTaskModel &b) {
  using ::std::swap;
  swap(a.source, b.source);
  swap(a.destination, b.destination);
  swap(a.type, b.type);
  swap(a.transferStartTime, b.transferStartTime);
  swap(a.transferEndTime, b.transferEndTime);
  swap(a.transferRate, b.transferRate);
  swap(a.processInput, b.processInput);
  swap(a.processOutput, b.processOutput);
  swap(a.__isset, b.__isset);
}

DataStagingTaskModel::DataStagingTaskModel(const DataStagingTaskModel& other22) {
  source = other22.source;
  destination = other22.destination;
  type = other22.type;
  transferStartTime = other22.transferStartTime;
  transferEndTime = other22.transferEndTime;
  transferRate = other22.transferRate;
  processInput = other22.processInput;
  processOutput = other22.processOutput;
  __isset = other22.__isset;
}
DataStagingTaskModel& DataStagingTaskModel::operator=(const DataStagingTaskModel& other23) {
  source = other23.source;
  destination = other23.destination;
  type = other23.type;
  transferStartTime = other23.transferStartTime;
  transferEndTime = other23.transferEndTime;
  transferRate = other23.transferRate;
  processInput = other23.processInput;
  processOutput = other23.processOutput;
  __isset = other23.__isset;
  return *this;
}
void DataStagingTaskModel::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "DataStagingTaskModel(";
  out << "source=" << to_string(source);
  out << ", " << "destination=" << to_string(destination);
  out << ", " << "type=" << to_string(type);
  out << ", " << "transferStartTime="; (__isset.transferStartTime ? (out << to_string(transferStartTime)) : (out << "<null>"));
  out << ", " << "transferEndTime="; (__isset.transferEndTime ? (out << to_string(transferEndTime)) : (out << "<null>"));
  out << ", " << "transferRate="; (__isset.transferRate ? (out << to_string(transferRate)) : (out << "<null>"));
  out << ", " << "processInput="; (__isset.processInput ? (out << to_string(processInput)) : (out << "<null>"));
  out << ", " << "processOutput="; (__isset.processOutput ? (out << to_string(processOutput)) : (out << "<null>"));
  out << ")";
}


EnvironmentSetupTaskModel::~EnvironmentSetupTaskModel() throw() {
}


void EnvironmentSetupTaskModel::__set_location(const std::string& val) {
  this->location = val;
}

void EnvironmentSetupTaskModel::__set_protocol(const  ::apache::airavata::model::data::movement::SecurityProtocol::type val) {
  this->protocol = val;
}

uint32_t EnvironmentSetupTaskModel::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_location = false;
  bool isset_protocol = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->location);
          isset_location = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast24;
          xfer += iprot->readI32(ecast24);
          this->protocol = ( ::apache::airavata::model::data::movement::SecurityProtocol::type)ecast24;
          isset_protocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_location)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_protocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t EnvironmentSetupTaskModel::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("EnvironmentSetupTaskModel");

  xfer += oprot->writeFieldBegin("location", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->location);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("protocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->protocol);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(EnvironmentSetupTaskModel &a, EnvironmentSetupTaskModel &b) {
  using ::std::swap;
  swap(a.location, b.location);
  swap(a.protocol, b.protocol);
}

EnvironmentSetupTaskModel::EnvironmentSetupTaskModel(const EnvironmentSetupTaskModel& other25) {
  location = other25.location;
  protocol = other25.protocol;
}
EnvironmentSetupTaskModel& EnvironmentSetupTaskModel::operator=(const EnvironmentSetupTaskModel& other26) {
  location = other26.location;
  protocol = other26.protocol;
  return *this;
}
void EnvironmentSetupTaskModel::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "EnvironmentSetupTaskModel(";
  out << "location=" << to_string(location);
  out << ", " << "protocol=" << to_string(protocol);
  out << ")";
}


JobSubmissionTaskModel::~JobSubmissionTaskModel() throw() {
}


void JobSubmissionTaskModel::__set_jobSubmissionProtocol(const  ::apache::airavata::model::appcatalog::computeresource::JobSubmissionProtocol::type val) {
  this->jobSubmissionProtocol = val;
}

void JobSubmissionTaskModel::__set_monitorMode(const  ::apache::airavata::model::appcatalog::computeresource::MonitorMode::type val) {
  this->monitorMode = val;
}

void JobSubmissionTaskModel::__set_wallTime(const int32_t val) {
  this->wallTime = val;
__isset.wallTime = true;
}

uint32_t JobSubmissionTaskModel::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_jobSubmissionProtocol = false;
  bool isset_monitorMode = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast27;
          xfer += iprot->readI32(ecast27);
          this->jobSubmissionProtocol = ( ::apache::airavata::model::appcatalog::computeresource::JobSubmissionProtocol::type)ecast27;
          isset_jobSubmissionProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast28;
          xfer += iprot->readI32(ecast28);
          this->monitorMode = ( ::apache::airavata::model::appcatalog::computeresource::MonitorMode::type)ecast28;
          isset_monitorMode = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->wallTime);
          this->__isset.wallTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_jobSubmissionProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_monitorMode)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t JobSubmissionTaskModel::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("JobSubmissionTaskModel");

  xfer += oprot->writeFieldBegin("jobSubmissionProtocol", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->jobSubmissionProtocol);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("monitorMode", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->monitorMode);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.wallTime) {
    xfer += oprot->writeFieldBegin("wallTime", ::apache::thrift::protocol::T_I32, 3);
    xfer += oprot->writeI32(this->wallTime);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(JobSubmissionTaskModel &a, JobSubmissionTaskModel &b) {
  using ::std::swap;
  swap(a.jobSubmissionProtocol, b.jobSubmissionProtocol);
  swap(a.monitorMode, b.monitorMode);
  swap(a.wallTime, b.wallTime);
  swap(a.__isset, b.__isset);
}

JobSubmissionTaskModel::JobSubmissionTaskModel(const JobSubmissionTaskModel& other29) {
  jobSubmissionProtocol = other29.jobSubmissionProtocol;
  monitorMode = other29.monitorMode;
  wallTime = other29.wallTime;
  __isset = other29.__isset;
}
JobSubmissionTaskModel& JobSubmissionTaskModel::operator=(const JobSubmissionTaskModel& other30) {
  jobSubmissionProtocol = other30.jobSubmissionProtocol;
  monitorMode = other30.monitorMode;
  wallTime = other30.wallTime;
  __isset = other30.__isset;
  return *this;
}
void JobSubmissionTaskModel::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "JobSubmissionTaskModel(";
  out << "jobSubmissionProtocol=" << to_string(jobSubmissionProtocol);
  out << ", " << "monitorMode=" << to_string(monitorMode);
  out << ", " << "wallTime="; (__isset.wallTime ? (out << to_string(wallTime)) : (out << "<null>"));
  out << ")";
}


MonitorTaskModel::~MonitorTaskModel() throw() {
}


void MonitorTaskModel::__set_monitorMode(const  ::apache::airavata::model::appcatalog::computeresource::MonitorMode::type val) {
  this->monitorMode = val;
}

uint32_t MonitorTaskModel::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_monitorMode = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast31;
          xfer += iprot->readI32(ecast31);
          this->monitorMode = ( ::apache::airavata::model::appcatalog::computeresource::MonitorMode::type)ecast31;
          isset_monitorMode = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_monitorMode)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t MonitorTaskModel::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("MonitorTaskModel");

  xfer += oprot->writeFieldBegin("monitorMode", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->monitorMode);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(MonitorTaskModel &a, MonitorTaskModel &b) {
  using ::std::swap;
  swap(a.monitorMode, b.monitorMode);
}

MonitorTaskModel::MonitorTaskModel(const MonitorTaskModel& other32) {
  monitorMode = other32.monitorMode;
}
MonitorTaskModel& MonitorTaskModel::operator=(const MonitorTaskModel& other33) {
  monitorMode = other33.monitorMode;
  return *this;
}
void MonitorTaskModel::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "MonitorTaskModel(";
  out << "monitorMode=" << to_string(monitorMode);
  out << ")";
}

}}}} // namespace
