/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xcollator;

import com.ibm.xtq.xml.xcollator.CollatorDeclaration;
import com.ibm.xtq.xml.xcollator.CollatorDeclarationImpl;
import com.ibm.xtq.xml.xcollator.CollatorImplBase;
import com.ibm.xtq.xml.xcollator.ICUCollator;
import com.ibm.xtq.xml.xcollator.JavaCollator;
import com.ibm.xtq.xml.xcollator.LocaleUtility;
import com.ibm.xtq.xml.xcollator.ObjectFactory;
import com.ibm.xtq.xml.xcollator.ParamCaseOrder;
import com.ibm.xtq.xml.xcollator.ParamDecomposition;
import com.ibm.xtq.xml.xcollator.ParamStrength;
import com.ibm.xtq.xml.xcollator.UnicodeCodepointCollator;
import com.ibm.xtq.xml.xcollator.XCollator;
import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.Stack;

public final class CollatorFactory {
    static final String STRENGTH_PRIMARY = "primary";
    static final String STRENGTH_SECONDARY = "secondary";
    static final String STRENGTH_TERTIARY = "tertiary";
    static final String STRENGTH_QUATERNARY = "quaternary";
    static final String STRENGTH_IDENTICAL = "identical";
    static final String DECOMP_NO = "no";
    static final String DECOMP_CANONICAL = "canonical";
    static final String DECOMP_FULL = "full";
    static final String CASEORDER_UNKNOWN = "unknown";
    static final String CASEORDER_NO = "no";
    static final String CASEORDER_UPPER_FIRST = "upper-first";
    static final String CASEORDER_LOWER_FIRST = "lower-first";
    static final String CASEORDER_MIXED = "mixed";
    private static final String ICU_CLASS = "com.ibm.icu.text.RuleBasedColator";
    public static final String CODE_POINT_NAME = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    static final String INVALID_URI_PREFIX = "@";
    public static final String SYSTEM_DEFAULT_NAME = "@/SystemDefault";
    private static final String[] PREDEFINED_URIS = new String[]{"http://www.w3.org/2005/xpath-functions/collation/codepoint", "@/SystemDefault"};
    private static final UnicodeCodepointCollator CODE_POINT_COLLATOR;
    private static final CollatorDeclarationImpl CODE_POINT_DECLARATION;
    private static final XCollator SYSTEM_DEFAULT_COLLATOR;
    private static final CollatorDeclarationImpl SYSTEM_DEFAULT_DECLARATION;
    private static final boolean ICU_ON_CLASSPATH;

    public static final boolean isPredefinedURI(String string) {
        if (PREDEFINED_URIS == null) {
            return false;
        }
        int n = PREDEFINED_URIS.length;
        for (int i = 0; i < n; ++i) {
            if (!PREDEFINED_URIS[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static final XCollator createCollatorFromDeclaration(CollatorDeclaration collatorDeclaration) {
        XCollator xCollator = null;
        CollatorDeclarationImpl collatorDeclarationImpl = collatorDeclaration instanceof CollatorDeclarationImpl ? (CollatorDeclarationImpl)collatorDeclaration : (collatorDeclaration == null ? new CollatorDeclarationImpl(collatorDeclaration.getName(), collatorDeclaration.getLanguage(), collatorDeclaration.getDecomposition(), collatorDeclaration.getStrength(), collatorDeclaration.getRules(), collatorDeclaration.getCaseOrder(), collatorDeclaration.getImpl()) : SYSTEM_DEFAULT_DECLARATION);
        String string = collatorDeclaration.getImpl();
        try {
            if (string == null || "".equals(string)) {
                xCollator = CollatorFactory.createSystemXCollator(collatorDeclarationImpl);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (xCollator == null && string != null) {
            Class clazz = null;
            try {
                clazz = ObjectFactory.findProviderClass(string, ObjectFactory.findClassLoader(), true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz != null) {
                if (collatorDeclaration != null) {
                    Constructor constructor;
                    if (collatorDeclaration == collatorDeclarationImpl) {
                        try {
                            constructor = clazz.getConstructor(CollatorDeclarationImpl.class);
                            xCollator = (XCollator)constructor.newInstance(collatorDeclarationImpl);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (xCollator == null) {
                        try {
                            constructor = clazz.getConstructor(CollatorDeclaration.class);
                            xCollator = (XCollator)constructor.newInstance(collatorDeclaration);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (xCollator == null) {
                    try {
                        xCollator = (XCollator)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (xCollator == null) {
            xCollator = new JavaCollator(collatorDeclarationImpl);
        }
        return xCollator;
    }

    private static final XCollator getUnicodeCodePointCollator() {
        return CODE_POINT_COLLATOR;
    }

    public static final XCollator getPredefinedCollator(String string) {
        if (string.equals(CODE_POINT_NAME)) {
            return CODE_POINT_COLLATOR;
        }
        if (string.equals(SYSTEM_DEFAULT_NAME)) {
            return SYSTEM_DEFAULT_COLLATOR;
        }
        return null;
    }

    private final XCollator getCollatorFromLanguage(String string, String string2, Stack stack) {
        String string3 = "@lang=" + string + ";";
        if (string2 != null) {
            string3 = string3 + "?case-order=" + string2 + ";";
        }
        ParamCaseOrder paramCaseOrder = ParamCaseOrder.getCaseOrder(string2);
        String string4 = "";
        CollatorDeclarationImpl collatorDeclarationImpl = (CollatorDeclarationImpl)CollatorFactory.getCollatorDeclaration(string3, string, null, null, null, paramCaseOrder.getValue(), string4);
        XCollator xCollator = CollatorFactory.createCollatorFromDeclaration(collatorDeclarationImpl);
        return xCollator;
    }

    private static final XCollator createSystemXCollator(CollatorDeclarationImpl collatorDeclarationImpl) {
        CollatorImplBase collatorImplBase = ICU_ON_CLASSPATH ? new ICUCollator(collatorDeclarationImpl) : new JavaCollator(collatorDeclarationImpl);
        return collatorImplBase;
    }

    public static boolean isNameValid(String string) {
        return string.length() != 0 && !CollatorFactory.isPredefinedURI(string);
    }

    private static boolean isLanguageValid(String string) {
        return LocaleUtility.isIETFLangValid(string);
    }

    public static boolean isCaseOrderValid(String string) {
        boolean bl = ParamCaseOrder.isValid(string);
        return bl;
    }

    public static boolean isDecompositionValid(String string) {
        boolean bl = ParamDecomposition.isValid(string);
        return bl;
    }

    public static boolean isStrengthValid(String string) {
        boolean bl = ParamStrength.isValid(string);
        return bl;
    }

    public static final CollatorDeclaration getCollatorDeclaration(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        CollatorDeclarationImpl collatorDeclarationImpl = new CollatorDeclarationImpl(string, string2, string3, string4, string5, string6, string7);
        return collatorDeclarationImpl;
    }

    public static String getLangSupported(String string) {
        Locale locale = ICU_ON_CLASSPATH ? ICUCollator.getLocaleSupported(string) : JavaCollator.getLocaleSupported(string);
        String string2 = locale.toString();
        String[] stringArray = LocaleUtility.splitLangName(string2, '_');
        String string3 = "";
        String string4 = stringArray[0];
        if (string4.length() > 0) {
            string3 = string3 + string4;
            String string5 = stringArray[1];
            if (string5.length() > 0) {
                string3 = string3 + "-" + string5;
                String string6 = stringArray[2];
                if (string6.length() > 0) {
                    string3 = string3 + "_" + string6;
                }
            }
        }
        return string3;
    }

    public static final int compareLangCountryVariant(String string, String string2) {
        return LocaleUtility.compareLangCountryVariant(string, string2);
    }

    static {
        boolean bl = false;
        try {
            Class.forName(ICU_CLASS);
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ICU_ON_CLASSPATH = bl;
        CODE_POINT_DECLARATION = (CollatorDeclarationImpl)CollatorFactory.getCollatorDeclaration(CODE_POINT_NAME, null, null, null, null, null, "java.lang.String");
        CODE_POINT_COLLATOR = UnicodeCodepointCollator.getInstance();
        String string = ICU_ON_CLASSPATH ? "com.ibm.xtq.collator.impl.ICUCollator" : JavaCollator.class.getName();
        SYSTEM_DEFAULT_DECLARATION = (CollatorDeclarationImpl)CollatorFactory.getCollatorDeclaration(SYSTEM_DEFAULT_NAME, null, null, null, null, ParamCaseOrder.UPPER_FIRST.getValue(), string);
        SYSTEM_DEFAULT_COLLATOR = ICU_ON_CLASSPATH ? new ICUCollator(SYSTEM_DEFAULT_DECLARATION) : new JavaCollator(SYSTEM_DEFAULT_DECLARATION);
    }
}

