/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.NavigationUtilities;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.IStream;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.JavaObjectType;
import java.util.LinkedList;

public class CharStreamToJavaStringInstruction
extends UnaryPrimopInstruction {
    public CharStreamToJavaStringInstruction(Instruction instruction) {
        super(instruction);
        this.setCachedType(JavaObjectType.s_javaStringType);
    }

    public CharStreamToJavaStringInstruction() {
    }

    public static Instruction literal(String string) {
        return new CharStreamToJavaStringInstruction(StreamInstruction.charStreamLiteral(string));
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return JavaObjectType.s_javaStringType;
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        return CharStreamToJavaStringInstruction.generateJavaString(dataFlowCodeGenerationHelper, codeGenerationTracker, this.m_operand, string);
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        CharStreamToJavaStringInstruction.generateJavaString(bCELCodeGenerationHelper, codeGenerationTracker, this.m_operand, instructionListBuilder);
    }

    public static String generateJavaString(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, Instruction instruction, String string) {
        BindingEnvironment bindingEnvironment = codeGenerationTracker.m_bindingEnvironment;
        if (instruction.isStatic(bindingEnvironment)) {
            Object object;
            Instruction instruction2 = NavigationUtilities.resolveReducedIdentifier(instruction, bindingEnvironment);
            if (instruction2 instanceof StreamInstruction && ((StreamInstruction)(object = (StreamInstruction)instruction2)).isStoredAsString()) {
                String string2 = dataFlowCodeGenerationHelper.generateConstant(JavaObjectType.s_javaStringType.getImplementationName(dataFlowCodeGenerationHelper), "\"" + ((StreamInstruction)object).generateEscapedStringValue() + '\"');
                dataFlowCodeGenerationHelper.append("// static string for " + string2 + " = \"" + ((StreamInstruction)object).generateEscapedStringValue() + "\"\n");
                return string2;
            }
            object = codeGenerationTracker.generateConventionally(instruction, dataFlowCodeGenerationHelper);
            return dataFlowCodeGenerationHelper.generateConstant(JavaObjectType.s_javaStringType.getImplementationName(dataFlowCodeGenerationHelper), "new String(" + (String)object + ")");
        }
        String string3 = codeGenerationTracker.generateConventionally(instruction, dataFlowCodeGenerationHelper);
        String string4 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        dataFlowCodeGenerationHelper.appendAssignment(string4, JavaObjectType.s_javaStringType, "new String(" + string3 + ")", codeGenerationTracker);
        return string4;
    }

    public static void generateJavaString(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, Instruction instruction, InstructionListBuilder instructionListBuilder) {
        BindingEnvironment bindingEnvironment = codeGenerationTracker.m_bindingEnvironment;
        if (instruction.isStatic(bindingEnvironment)) {
            Object object;
            Instruction instruction2 = NavigationUtilities.resolveReducedIdentifier(instruction, bindingEnvironment);
            if (instruction2 instanceof StreamInstruction && ((StreamInstruction)(object = (StreamInstruction)instruction2)).isStoredAsString()) {
                instructionListBuilder.appendConstant(((StreamInstruction)object).getStringContent());
                return;
            }
            object = bCELCodeGenerationHelper.startConstantGeneration();
            ((InstructionListBuilder)object).appendNew("java.lang.String");
            ((InstructionListBuilder)object).appendDUP();
            codeGenerationTracker.generateConventionally(instruction, bCELCodeGenerationHelper, null, (InstructionListBuilder)object);
            ((InstructionListBuilder)object).appendInvokeConstructor("java.lang.String", CharType.s_charType.getStreamType());
            bCELCodeGenerationHelper.finishConstantGeneration(null, BasicType.STRING, (InstructionListBuilder)object);
            return;
        }
        instructionListBuilder.appendNew("java.lang.String");
        instructionListBuilder.appendDUP();
        codeGenerationTracker.generateConventionally(instruction, bCELCodeGenerationHelper, null, instructionListBuilder);
        instructionListBuilder.appendInvokeConstructor("java.lang.String", CharType.s_charType.getStreamType());
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new CharStreamToJavaStringInstruction(this.m_operand.cloneWithoutTypeInformation());
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        typeEnvironment.unify(this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList), CharType.s_charType.getStreamType(), this);
        return JavaObjectType.s_javaStringType;
    }

    @Override
    public String innerToString() {
        return "char-stream-to-java-string";
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        IStream iStream;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        if ((iStream = (IStream)this.m_operand.evaluate(environment, function, iDebuggerInterceptor, false)) == null) {
            throw new RuntimeException();
        }
        String string = ((Object)iStream).toString();
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, string);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction) {
        return new CharStreamToJavaStringInstruction(instruction);
    }

    @Override
    public boolean isStatic(BindingEnvironment bindingEnvironment) {
        return this.getOperand().isStatic(bindingEnvironment);
    }
}

