/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.codegen;

import com.ibm.xylem.codegen.CodeGeneration;
import com.ibm.xylem.codegen.CodeGenerationSettings;
import com.ibm.xylem.codegen.FunctionGenerationStyle;
import com.ibm.xylem.types.LambdaType;
import com.ibm.xylem.types.LazyStreamType;
import com.ibm.xylem.types.PromiseType;
import com.ibm.xylem.types.SlotType;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class CodeGenerationHelper
implements CodeGeneration {
    private static final char ESCAPE_DELIM_CHAR = '$';
    private String m_className;
    private CodeGenerationSettings m_settings;
    private HashMap m_obfuscatedFunctionNames = new HashMap();
    private HashMap m_generationMemos = new HashMap();
    private HashMap m_lambdaTypeGenerationRequests = new HashMap();
    private HashMap m_slotTypeGenerationRequests = new HashMap();
    private HashMap m_lazyStreamTypeGenerationRequests = new HashMap();
    private HashMap m_promiseTypeGenerationRequests = new HashMap();
    private TreeSet m_functionGenerationRequests = new TreeSet(new Comparator(){

        public int compare(Object object, Object object2) {
            return ((FunctionGenerationStyle)object).getSignature().compareTo(((FunctionGenerationStyle)object2).getSignature());
        }
    });
    HashMap safeNamesMap = new HashMap();

    @Override
    public final String getClassName() {
        return this.m_className;
    }

    @Override
    public final void setClassName(String string) {
        this.m_className = string;
    }

    @Override
    public void requestFunctionGeneration(FunctionGenerationStyle functionGenerationStyle) {
        this.m_functionGenerationRequests.add(functionGenerationStyle);
    }

    @Override
    public Iterator functionGenerationRequestsIterator() {
        return this.m_functionGenerationRequests.iterator();
    }

    @Override
    public boolean functionGenerationRequestsIsEmpty() {
        return this.m_functionGenerationRequests.isEmpty();
    }

    @Override
    public void requestLambdaTypeGeneration(String string, LambdaType lambdaType) {
        this.m_lambdaTypeGenerationRequests.put(string, lambdaType);
    }

    @Override
    public void requestPromiseTypeGeneration(String string, PromiseType promiseType) {
        this.m_promiseTypeGenerationRequests.put(string, promiseType);
    }

    @Override
    public final Iterator promiseTypeGenerationRequestsIterator() {
        return this.m_promiseTypeGenerationRequests.keySet().iterator();
    }

    @Override
    public final PromiseType promiseTypeGenerationRequestsGet(String string) {
        return (PromiseType)this.m_promiseTypeGenerationRequests.get(string);
    }

    @Override
    public void requestSlotTypeGeneration(String string, SlotType slotType) {
        this.m_slotTypeGenerationRequests.put(string, slotType);
    }

    @Override
    public final Iterator slotTypeGenerationRequestsIterator() {
        return this.m_slotTypeGenerationRequests.keySet().iterator();
    }

    @Override
    public final SlotType slotTypeGenerationRequestsGet(String string) {
        return (SlotType)this.m_slotTypeGenerationRequests.get(string);
    }

    public void requestLazyStreamTypeGeneration(String string, LazyStreamType lazyStreamType) {
        this.m_lazyStreamTypeGenerationRequests.put(string, lazyStreamType);
    }

    public final Iterator lazyStreamTypeGenerationRequestsIterator() {
        return this.m_lazyStreamTypeGenerationRequests.keySet().iterator();
    }

    public final LazyStreamType lazyStreamTypeGenerationRequestsGet(String string) {
        return (LazyStreamType)this.m_lazyStreamTypeGenerationRequests.get(string);
    }

    @Override
    public String getSafeName(String string) {
        if (this.m_settings.isObfuscateFunctionNames()) {
            return this.getObfuscatedFunctionName(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        char c = string.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            stringBuffer.append('_');
        }
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 != '$' && (Character.isJavaIdentifierStart(c2) || Character.isJavaIdentifierPart(c2))) {
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append('$').append("0x").append(Integer.toHexString(c2)).append('$');
        }
        String string2 = stringBuffer.toString().length() > 80 ? (stringBuffer.toString().substring(0, 80) + stringBuffer.toString().hashCode()).replace('-', '_') : stringBuffer.toString();
        String string3 = (String)this.safeNamesMap.get(string.toLowerCase());
        if (null == string3) {
            this.safeNamesMap.put(string.toLowerCase(), string);
            return string2;
        }
        if (string3.equals(string)) {
            return string2;
        }
        return (string2 + string2.hashCode()).replace('-', '_');
    }

    @Override
    public final CodeGenerationSettings getSettings() {
        return this.m_settings;
    }

    @Override
    public final void setSettings(CodeGenerationSettings codeGenerationSettings) {
        this.m_settings = codeGenerationSettings;
    }

    @Override
    public final String getObfuscatedFunctionName(String string) {
        String string2 = (String)this.m_obfuscatedFunctionNames.get(string);
        if (string2 == null) {
            string2 = "f" + this.m_obfuscatedFunctionNames.size();
            this.m_obfuscatedFunctionNames.put(string, string2);
        }
        return string2;
    }

    @Override
    public final void generationMemosPut(Object object, Object object2) {
        this.m_generationMemos.put(object, object2);
    }

    @Override
    public final Object generationMemosGet(Object object) {
        return this.m_generationMemos.get(object);
    }

    @Override
    public final int generationMemosSize() {
        return this.m_generationMemos.size();
    }

    @Override
    public final boolean generationMemosContainsKey(Object object) {
        return this.m_generationMemos.containsKey(object);
    }

    @Override
    public final LambdaType lambdaTypeGenerationRequestsGet(String string) {
        return (LambdaType)this.m_lambdaTypeGenerationRequests.get(string);
    }

    @Override
    public final Iterator lambdaTypeGenerationRequestsIterator() {
        return this.m_lambdaTypeGenerationRequests.keySet().iterator();
    }
}

