/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.util.StringUtils;

public class FileOutputCommitter
extends OutputCommitter {
    public static final Log LOG = LogFactory.getLog("org.apache.hadoop.mapred.FileOutputCommitter");
    public static final String TEMP_DIR_NAME = "_temporary";
    public static final String SUCCEEDED_FILE_NAME = "_SUCCESS";
    static final String SUCCESSFUL_JOB_OUTPUT_DIR_MARKER = "mapreduce.fileoutputcommitter.marksuccessfuljobs";

    @Override
    public void setupJob(JobContext context) throws IOException {
        Path tmpDir;
        FileSystem fileSys;
        JobConf conf = context.getJobConf();
        Path outputPath = FileOutputFormat.getOutputPath(conf);
        if (outputPath != null && !(fileSys = (tmpDir = new Path(outputPath, TEMP_DIR_NAME)).getFileSystem(conf)).mkdirs(tmpDir)) {
            LOG.error("Mkdirs failed to create " + tmpDir.toString());
        }
    }

    private static boolean getOutputDirMarking(JobConf conf) {
        return conf.getBoolean(SUCCESSFUL_JOB_OUTPUT_DIR_MARKER, true);
    }

    private void markSuccessfulOutputDir(JobContext context) throws IOException {
        FileSystem fileSys;
        JobConf conf = context.getJobConf();
        Path outputPath = FileOutputFormat.getOutputPath(conf);
        if (outputPath != null && (fileSys = outputPath.getFileSystem(conf)).exists(outputPath)) {
            Path filePath = new Path(outputPath, SUCCEEDED_FILE_NAME);
            fileSys.create(filePath).close();
        }
    }

    @Override
    public void commitJob(JobContext context) throws IOException {
        this.cleanupJob(context);
        if (FileOutputCommitter.getOutputDirMarking(context.getJobConf())) {
            this.markSuccessfulOutputDir(context);
        }
    }

    @Override
    @Deprecated
    public void cleanupJob(JobContext context) throws IOException {
        JobConf conf = context.getJobConf();
        Path outputPath = FileOutputFormat.getOutputPath(conf);
        if (outputPath != null) {
            Path tmpDir = new Path(outputPath, TEMP_DIR_NAME);
            FileSystem fileSys = tmpDir.getFileSystem(conf);
            context.getProgressible().progress();
            if (fileSys.exists(tmpDir)) {
                fileSys.delete(tmpDir, true);
            }
        } else {
            LOG.warn("Output path is null in cleanup");
        }
    }

    @Override
    public void abortJob(JobContext context, int runState) throws IOException {
        this.cleanupJob(context);
    }

    @Override
    public void setupTask(TaskAttemptContext context) throws IOException {
    }

    @Override
    public void commitTask(TaskAttemptContext context) throws IOException {
        Path taskOutputPath = this.getTempTaskOutputPath(context);
        TaskAttemptID attemptId = context.getTaskAttemptID();
        JobConf job = context.getJobConf();
        if (taskOutputPath != null) {
            FileSystem fs = taskOutputPath.getFileSystem(job);
            context.getProgressible().progress();
            if (fs.exists(taskOutputPath)) {
                Path jobOutputPath = taskOutputPath.getParent().getParent();
                this.moveTaskOutputs(context, fs, jobOutputPath, taskOutputPath);
                if (!fs.delete(taskOutputPath, true)) {
                    LOG.info("Failed to delete the temporary output directory of task: " + attemptId + " - " + taskOutputPath);
                }
                LOG.info("Saved output of task '" + attemptId + "' to " + jobOutputPath);
            }
        }
    }

    private void moveTaskOutputs(TaskAttemptContext context, FileSystem fs, Path jobOutputDir, Path taskOutput) throws IOException {
        TaskAttemptID attemptId = context.getTaskAttemptID();
        context.getProgressible().progress();
        if (fs.isFile(taskOutput)) {
            Path finalOutputPath = this.getFinalPath(jobOutputDir, taskOutput, this.getTempTaskOutputPath(context));
            if (!fs.rename(taskOutput, finalOutputPath)) {
                if (!fs.delete(finalOutputPath, true)) {
                    throw new IOException("Failed to delete earlier output of task: " + attemptId);
                }
                if (!fs.rename(taskOutput, finalOutputPath)) {
                    throw new IOException("Failed to save output of task: " + attemptId);
                }
            }
            LOG.debug("Moved " + taskOutput + " to " + finalOutputPath);
        } else if (fs.getFileStatus(taskOutput).isDir()) {
            FileStatus[] paths = fs.listStatus(taskOutput);
            Path finalOutputPath = this.getFinalPath(jobOutputDir, taskOutput, this.getTempTaskOutputPath(context));
            fs.mkdirs(finalOutputPath);
            if (paths != null) {
                for (FileStatus path : paths) {
                    this.moveTaskOutputs(context, fs, jobOutputDir, path.getPath());
                }
            }
        }
    }

    @Override
    public void abortTask(TaskAttemptContext context) throws IOException {
        Path taskOutputPath = this.getTempTaskOutputPath(context);
        try {
            if (taskOutputPath != null) {
                FileSystem fs = taskOutputPath.getFileSystem(context.getJobConf());
                context.getProgressible().progress();
                fs.delete(taskOutputPath, true);
            }
        }
        catch (IOException ie) {
            LOG.warn("Error discarding output" + StringUtils.stringifyException(ie));
        }
    }

    private Path getFinalPath(Path jobOutputDir, Path taskOutput, Path taskOutputPath) throws IOException {
        URI relativePath;
        URI taskOutputUri = taskOutput.toUri();
        if (taskOutputUri == (relativePath = taskOutputPath.toUri().relativize(taskOutputUri))) {
            throw new IOException("Can not get the relative path: base = " + taskOutputPath + " child = " + taskOutput);
        }
        if (relativePath.getPath().length() > 0) {
            return new Path(jobOutputDir, relativePath.getPath());
        }
        return jobOutputDir;
    }

    @Override
    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        Path taskOutputPath = this.getTempTaskOutputPath(context);
        if (taskOutputPath != null) {
            context.getProgressible().progress();
            FileSystem fs = taskOutputPath.getFileSystem(context.getJobConf());
            if (fs.exists(taskOutputPath)) {
                return true;
            }
        }
        return false;
    }

    Path getTempTaskOutputPath(TaskAttemptContext taskContext) {
        JobConf conf = taskContext.getJobConf();
        Path outputPath = FileOutputFormat.getOutputPath(conf);
        if (outputPath != null) {
            Path p = new Path(outputPath, "_temporary/_" + taskContext.getTaskAttemptID().toString());
            try {
                FileSystem fs = p.getFileSystem(conf);
                return p.makeQualified(fs);
            }
            catch (IOException ie) {
                LOG.warn(StringUtils.stringifyException(ie));
                return p;
            }
        }
        return null;
    }

    Path getWorkPath(TaskAttemptContext taskContext, Path basePath) throws IOException {
        Path jobTmpDir = new Path(basePath, TEMP_DIR_NAME);
        FileSystem fs = jobTmpDir.getFileSystem(taskContext.getJobConf());
        if (!fs.exists(jobTmpDir)) {
            throw new IOException("The temporary job-output directory " + jobTmpDir.toString() + " doesn't exist!");
        }
        String taskid = taskContext.getTaskAttemptID().toString();
        Path taskTmpDir = new Path(jobTmpDir, "_" + taskid);
        if (!fs.mkdirs(taskTmpDir)) {
            throw new IOException("Mkdirs failed to create " + taskTmpDir.toString());
        }
        return taskTmpDir;
    }
}

