/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distribut
 * ed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ambari.server.topology;

import org.apache.ambari.server.security.encryption.CredentialStoreType;

/**
 * Holds credential info submitted in a cluster create template.
 */
public class Credential {

  /**
   * Credential alias like kdc.admin.credential.
   */
  private String alias;

  /**
   * Name of a principal.
   */
  private String principal;

  /**
   * Key of credential.
   */
  private String key;

  /**
   * Type of credential store.
   */
  private CredentialStoreType type;

  public Credential(String alias, String principal, String key, CredentialStoreType type) {
    this.alias = alias;
    this.principal = principal;
    this.key = key;
    this.type = type;
  }

  public String getAlias() {
    return alias;
  }

  public String getPrincipal() {
    return principal;
  }

  public String getKey() {
    return key;
  }

  public CredentialStoreType getType() {
    return type;
  }
}
