/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.dataflow;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexInsertUpdateDeleteOperatorNodePushable;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFrameWriter;

public class LSMIndexInsertUpdateDeleteOperatorNodePushable
extends IndexInsertUpdateDeleteOperatorNodePushable
implements ILSMIndexFrameWriter {
    protected FrameTupleAppender appender;

    public void open() throws HyracksDataException {
        super.open();
        this.appender = new FrameTupleAppender(this.writeBuffer);
    }

    public LSMIndexInsertUpdateDeleteOperatorNodePushable(IHyracksTaskContext ctx, int partition, IIndexDataflowHelperFactory indexHelperFactory, int[] fieldPermutation, RecordDescriptor inputRecDesc, IndexOperation op, IModificationOperationCallbackFactory modCallbackFactory, ITupleFilterFactory tupleFilterFactory) throws HyracksDataException {
        super(ctx, partition, indexHelperFactory, fieldPermutation, inputRecDesc, op, modCallbackFactory, tupleFilterFactory);
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        ILSMIndexAccessor lsmAccessor = (ILSMIndexAccessor)this.indexAccessor;
        int nextFlushTupleIndex = 0;
        int tupleCount = this.accessor.getTupleCount();
        block9: for (int i = 0; i < tupleCount; ++i) {
            try {
                if (this.tupleFilter != null) {
                    this.frameTuple.reset((IFrameTupleAccessor)this.accessor, i);
                    if (!this.tupleFilter.accept((IFrameTupleReference)this.frameTuple)) continue;
                }
                this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
                switch (this.op) {
                    case INSERT: {
                        if (lsmAccessor.tryInsert((ITupleReference)this.tuple)) continue block9;
                        this.flushPartialFrame(nextFlushTupleIndex, i);
                        nextFlushTupleIndex = i;
                        lsmAccessor.insert((ITupleReference)this.tuple);
                        break;
                    }
                    case DELETE: {
                        if (lsmAccessor.tryDelete((ITupleReference)this.tuple)) continue block9;
                        this.flushPartialFrame(nextFlushTupleIndex, i);
                        nextFlushTupleIndex = i;
                        lsmAccessor.delete((ITupleReference)this.tuple);
                        break;
                    }
                    case UPSERT: {
                        if (lsmAccessor.tryUpsert((ITupleReference)this.tuple)) continue block9;
                        this.flushPartialFrame(nextFlushTupleIndex, i);
                        nextFlushTupleIndex = i;
                        lsmAccessor.upsert((ITupleReference)this.tuple);
                        break;
                    }
                    case UPDATE: {
                        if (lsmAccessor.tryUpdate((ITupleReference)this.tuple)) continue block9;
                        this.flushPartialFrame(nextFlushTupleIndex, i);
                        nextFlushTupleIndex = i;
                        lsmAccessor.update((ITupleReference)this.tuple);
                        break;
                    }
                    default: {
                        throw new HyracksDataException("Unsupported operation " + this.op + " in tree index InsertUpdateDelete operator");
                    }
                }
                continue;
            }
            catch (HyracksDataException e) {
                throw e;
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        if (nextFlushTupleIndex == 0) {
            this.writeBuffer.ensureFrameSize(buffer.capacity());
            FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)this.writeBuffer.getBuffer());
            FrameUtils.flushFrame((ByteBuffer)this.writeBuffer.getBuffer(), (IFrameWriter)this.writer);
        } else {
            this.flushPartialFrame(nextFlushTupleIndex, tupleCount);
        }
    }

    @Override
    public void flushPartialFrame(int startTupleIndex, int endTupleIndex) throws HyracksDataException {
        for (int i = startTupleIndex; i < endTupleIndex; ++i) {
            FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (IFrameTupleAccessor)this.accessor, (int)i);
        }
        this.appender.write(this.writer, true);
    }
}

