/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalGroupingProperty;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;
import org.apache.hyracks.util.LogRedactionUtil;

public class FDsAndEquivClassesVisitor
implements ILogicalOperatorVisitor<Void, IOptimizationContext> {
    @Override
    public Void visitAggregateOperator(AggregateOperator op, IOptimizationContext ctx) throws AlgebricksException {
        ctx.putEquivalenceClassMap(op, new HashMap<LogicalVariable, EquivalenceClass>());
        ctx.putFDList(op, new ArrayList<FunctionalDependency>());
        return null;
    }

    @Override
    public Void visitAssignOperator(AssignOperator op, IOptimizationContext ctx) throws AlgebricksException {
        ILogicalOperator inp1 = (ILogicalOperator)op.getInputs().get(0).getValue();
        Map<LogicalVariable, EquivalenceClass> eqClasses = this.getOrComputeEqClasses(inp1, ctx);
        ctx.putEquivalenceClassMap(op, eqClasses);
        this.propagateEquivalenceFromExpressionsToVariables(eqClasses, op.getExpressions(), op.getVariables());
        ArrayList<LogicalVariable> used = new ArrayList<LogicalVariable>();
        VariableUtilities.getUsedVariables(op, used);
        List<FunctionalDependency> fds1 = this.getOrComputeFDs(inp1, ctx);
        ArrayList<FunctionalDependency> eFds = new ArrayList<FunctionalDependency>(fds1.size());
        for (FunctionalDependency fd : fds1) {
            if (fd.getTail().containsAll(used)) {
                ArrayList<LogicalVariable> hd = new ArrayList<LogicalVariable>(fd.getHead());
                ArrayList<LogicalVariable> tl = new ArrayList<LogicalVariable>(fd.getTail());
                tl.addAll(op.getVariables());
                FunctionalDependency fd2 = new FunctionalDependency(hd, tl);
                eFds.add(fd2);
                continue;
            }
            eFds.add(fd);
        }
        ctx.putFDList(op, eFds);
        return null;
    }

    @Override
    public Void visitDataScanOperator(DataSourceScanOperator op, IOptimizationContext ctx) throws AlgebricksException {
        ILogicalOperator inp1 = (ILogicalOperator)op.getInputs().get(0).getValue();
        Map<LogicalVariable, EquivalenceClass> eqClasses = this.getOrCreateEqClasses(op, ctx);
        Map<LogicalVariable, EquivalenceClass> propagatedEqClasses = this.getOrComputeEqClasses(inp1, ctx);
        eqClasses.putAll(propagatedEqClasses);
        ctx.putEquivalenceClassMap(op, eqClasses);
        ArrayList<FunctionalDependency> fds = new ArrayList<FunctionalDependency>(this.getOrComputeFDs(inp1, ctx));
        ctx.putFDList(op, fds);
        op.getDataSource().computeFDs(op.getVariables(), fds);
        return null;
    }

    @Override
    public Void visitDistinctOperator(DistinctOperator op, IOptimizationContext ctx) throws AlgebricksException {
        ILogicalOperator op0 = (ILogicalOperator)op.getInputs().get(0).getValue();
        ArrayList<FunctionalDependency> functionalDependencies = new ArrayList<FunctionalDependency>();
        ctx.putFDList(op, functionalDependencies);
        for (FunctionalDependency inherited : this.getOrComputeFDs(op0, ctx)) {
            boolean isCoveredByDistinctByVars = true;
            for (LogicalVariable logicalVariable : inherited.getHead()) {
                if (op.isDistinctByVar(logicalVariable)) continue;
                isCoveredByDistinctByVars = false;
            }
            if (!isCoveredByDistinctByVars) continue;
            ArrayList<LogicalVariable> newTail = new ArrayList<LogicalVariable>();
            for (LogicalVariable v2 : inherited.getTail()) {
                if (!op.isDistinctByVar(v2)) continue;
                newTail.add(v2);
            }
            if (newTail.isEmpty()) continue;
            ArrayList<LogicalVariable> arrayList = new ArrayList<LogicalVariable>(inherited.getHead());
            FunctionalDependency newFd = new FunctionalDependency(arrayList, newTail);
            functionalDependencies.add(newFd);
        }
        HashSet<LogicalVariable> gbySet = new HashSet<LogicalVariable>();
        List<Mutable<ILogicalExpression>> expressions = op.getExpressions();
        for (Mutable<ILogicalExpression> pRef : expressions) {
            ILogicalExpression iLogicalExpression = (ILogicalExpression)pRef.getValue();
            if (iLogicalExpression.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            VariableReferenceExpression v = (VariableReferenceExpression)iLogicalExpression;
            gbySet.add(v.getVariableReference());
        }
        LocalGroupingProperty lgp = new LocalGroupingProperty(gbySet);
        Map<LogicalVariable, EquivalenceClass> equivalenceClasses = this.getOrComputeEqClasses(op0, ctx);
        ctx.putEquivalenceClassMap(op, equivalenceClasses);
        ILocalStructuralProperty iLocalStructuralProperty = lgp.normalize(equivalenceClasses, functionalDependencies);
        ListSet normSet = new ListSet();
        iLocalStructuralProperty.getColumns((Collection<LogicalVariable>)normSet);
        ArrayList<Mutable<ILogicalExpression>> newDistinctByList = new ArrayList<Mutable<ILogicalExpression>>();
        for (Mutable<ILogicalExpression> p2Ref : expressions) {
            ILogicalExpression p2 = (ILogicalExpression)p2Ref.getValue();
            if (p2.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
                VariableReferenceExpression var2 = (VariableReferenceExpression)p2;
                LogicalVariable v2 = var2.getVariableReference();
                EquivalenceClass v2EquivalenceClass = equivalenceClasses.get(v2);
                if ((v2EquivalenceClass == null || !normSet.contains(v2EquivalenceClass.getVariableRepresentative())) && (v2EquivalenceClass != null || !normSet.contains(v2))) continue;
                newDistinctByList.add(p2Ref);
                continue;
            }
            newDistinctByList.add(p2Ref);
        }
        expressions.clear();
        expressions.addAll(newDistinctByList);
        return null;
    }

    @Override
    public Void visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, IOptimizationContext ctx) throws AlgebricksException {
        ctx.putEquivalenceClassMap(op, new HashMap<LogicalVariable, EquivalenceClass>());
        ctx.putFDList(op, new ArrayList<FunctionalDependency>());
        return null;
    }

    @Override
    public Void visitExchangeOperator(ExchangeOperator op, IOptimizationContext ctx) throws AlgebricksException {
        this.propagateFDsAndEquivClasses(op, ctx);
        return null;
    }

    @Override
    public Void visitGroupByOperator(GroupByOperator op, IOptimizationContext ctx) throws AlgebricksException {
        HashMap<LogicalVariable, EquivalenceClass> equivalenceClasses = new HashMap<LogicalVariable, EquivalenceClass>();
        ArrayList<FunctionalDependency> functionalDependencies = new ArrayList<FunctionalDependency>();
        ctx.putEquivalenceClassMap(op, equivalenceClasses);
        ctx.putFDList(op, functionalDependencies);
        ArrayList<FunctionalDependency> inheritedFDs = new ArrayList<FunctionalDependency>();
        for (ILogicalPlan p : op.getNestedPlans()) {
            for (Mutable<ILogicalOperator> r : p.getRoots()) {
                ILogicalOperator op2 = (ILogicalOperator)r.getValue();
                equivalenceClasses.putAll(this.getOrComputeEqClasses(op2, ctx));
                inheritedFDs.addAll(this.getOrComputeFDs(op2, ctx));
            }
        }
        ILogicalOperator op0 = (ILogicalOperator)op.getInputs().get(0).getValue();
        inheritedFDs.addAll(this.getOrComputeFDs(op0, ctx));
        Map<LogicalVariable, EquivalenceClass> inheritedEcs = this.getOrComputeEqClasses(op0, ctx);
        for (FunctionalDependency inherited : inheritedFDs) {
            boolean isCoveredByGbyOrDecorVars = true;
            ArrayList<LogicalVariable> newHead = new ArrayList<LogicalVariable>(inherited.getHead().size());
            for (LogicalVariable logicalVariable : inherited.getHead()) {
                LogicalVariable logicalVariable2 = this.getNewGbyVar(op, logicalVariable);
                if (logicalVariable2 == null) {
                    LogicalVariable logicalVariable3 = this.getNewDecorVar(op, logicalVariable);
                    if (logicalVariable3 != null) break;
                    isCoveredByGbyOrDecorVars = false;
                    break;
                }
                newHead.add(logicalVariable2);
            }
            if (!isCoveredByGbyOrDecorVars) continue;
            ArrayList newTail = new ArrayList();
            for (LogicalVariable logicalVariable : inherited.getTail()) {
                LogicalVariable v3 = this.getNewGbyVar(op, logicalVariable);
                if (v3 == null) continue;
                newTail.add(v3);
            }
            if (newTail.isEmpty()) continue;
            FunctionalDependency functionalDependency = new FunctionalDependency(newHead, newTail);
            functionalDependencies.add(functionalDependency);
        }
        LinkedList<LogicalVariable> premiseGby = new LinkedList<LogicalVariable>();
        List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> gByList = op.getGroupByList();
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : gByList) {
            premiseGby.add((LogicalVariable)p.first);
        }
        List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> decorList = op.getDecorList();
        LinkedList<LogicalVariable> conclDecor = new LinkedList<LogicalVariable>();
        for (Pair pair : decorList) {
            conclDecor.add(GroupByOperator.getDecorVariable((Pair<LogicalVariable, Mutable<ILogicalExpression>>)pair));
        }
        if (!conclDecor.isEmpty()) {
            functionalDependencies.add(new FunctionalDependency(premiseGby, conclDecor));
        }
        HashSet<LogicalVariable> gbySet = new HashSet<LogicalVariable>();
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> pair : gByList) {
            ILogicalExpression expr = (ILogicalExpression)((Mutable)pair.second).getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            VariableReferenceExpression v = (VariableReferenceExpression)expr;
            gbySet.add(v.getVariableReference());
        }
        LocalGroupingProperty localGroupingProperty = new LocalGroupingProperty(gbySet);
        ILocalStructuralProperty iLocalStructuralProperty = localGroupingProperty.normalize(inheritedEcs, inheritedFDs);
        ListSet normSet = new ListSet();
        iLocalStructuralProperty.getColumns((Collection<LogicalVariable>)normSet);
        ArrayList<Pair<LogicalVariable, Mutable<ILogicalExpression>>> newGbyList = new ArrayList<Pair<LogicalVariable, Mutable<ILogicalExpression>>>();
        boolean changed = false;
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : gByList) {
            ILogicalExpression expr = (ILogicalExpression)((Mutable)p.second).getValue();
            if (expr.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
                VariableReferenceExpression varRef = (VariableReferenceExpression)expr;
                LogicalVariable v2 = varRef.getVariableReference();
                EquivalenceClass ec2 = inheritedEcs.get(v2);
                LogicalVariable v3 = ec2 != null && !ec2.representativeIsConst() ? ec2.getVariableRepresentative() : v2;
                if (normSet.contains(v3)) {
                    newGbyList.add(p);
                    continue;
                }
                changed = true;
                decorList.add(p);
                continue;
            }
            newGbyList.add(p);
        }
        if (changed && AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled()) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">>>> Group-by list changed from {} to {}.\n", (Object)LogRedactionUtil.userData((String)GroupByOperator.veListToString(gByList)), (Object)LogRedactionUtil.userData((String)GroupByOperator.veListToString(newGbyList)));
        }
        gByList.clear();
        gByList.addAll(newGbyList);
        return null;
    }

    @Override
    public Void visitInnerJoinOperator(InnerJoinOperator op, IOptimizationContext ctx) throws AlgebricksException {
        HashMap<LogicalVariable, EquivalenceClass> equivalenceClasses = new HashMap<LogicalVariable, EquivalenceClass>();
        ArrayList<FunctionalDependency> functionalDependencies = new ArrayList<FunctionalDependency>();
        ctx.putEquivalenceClassMap(op, equivalenceClasses);
        ctx.putFDList(op, functionalDependencies);
        ILogicalOperator op0 = (ILogicalOperator)op.getInputs().get(0).getValue();
        ILogicalOperator op1 = (ILogicalOperator)op.getInputs().get(1).getValue();
        functionalDependencies.addAll(this.getOrComputeFDs(op0, ctx));
        functionalDependencies.addAll(this.getOrComputeFDs(op1, ctx));
        equivalenceClasses.putAll(this.getOrComputeEqClasses(op0, ctx));
        equivalenceClasses.putAll(this.getOrComputeEqClasses(op1, ctx));
        ILogicalExpression expr = (ILogicalExpression)op.getCondition().getValue();
        expr.getConstraintsAndEquivClasses(functionalDependencies, equivalenceClasses);
        return null;
    }

    @Override
    public Void visitLeftOuterJoinOperator(LeftOuterJoinOperator op, IOptimizationContext ctx) throws AlgebricksException {
        List<LogicalVariable> leftSideVars;
        HashMap<LogicalVariable, EquivalenceClass> equivalenceClasses = new HashMap<LogicalVariable, EquivalenceClass>();
        ArrayList<FunctionalDependency> functionalDependencies = new ArrayList<FunctionalDependency>();
        ctx.putEquivalenceClassMap(op, equivalenceClasses);
        ctx.putFDList(op, functionalDependencies);
        ILogicalOperator opLeft = (ILogicalOperator)op.getInputs().get(0).getValue();
        ILogicalOperator opRight = (ILogicalOperator)op.getInputs().get(1).getValue();
        functionalDependencies.addAll(this.getOrComputeFDs(opLeft, ctx));
        functionalDependencies.addAll(this.getOrComputeFDs(opRight, ctx));
        equivalenceClasses.putAll(this.getOrComputeEqClasses(opLeft, ctx));
        equivalenceClasses.putAll(this.getOrComputeEqClasses(opRight, ctx));
        if (opLeft.getSchema() == null) {
            leftSideVars = new LinkedList<LogicalVariable>();
            VariableUtilities.getLiveVariables(opLeft, leftSideVars);
        } else {
            leftSideVars = opLeft.getSchema();
        }
        ILogicalExpression expr = (ILogicalExpression)op.getCondition().getValue();
        expr.getConstraintsForOuterJoin(functionalDependencies, leftSideVars);
        return null;
    }

    @Override
    public Void visitLimitOperator(LimitOperator op, IOptimizationContext ctx) throws AlgebricksException {
        this.propagateFDsAndEquivClasses(op, ctx);
        return null;
    }

    @Override
    public Void visitNestedTupleSourceOperator(NestedTupleSourceOperator op, IOptimizationContext ctx) throws AlgebricksException {
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)op.getDataSourceReference().getValue();
        ILogicalOperator inp1 = (ILogicalOperator)op1.getInputs().get(0).getValue();
        Map<LogicalVariable, EquivalenceClass> eqClasses = this.getOrComputeEqClasses(inp1, ctx);
        ctx.putEquivalenceClassMap(op, eqClasses);
        ArrayList<FunctionalDependency> fds = new ArrayList<FunctionalDependency>(this.getOrComputeFDs(inp1, ctx));
        if (op1.getOperatorTag() == LogicalOperatorTag.GROUP) {
            GroupByOperator gby = (GroupByOperator)op1;
            LinkedList<LogicalVariable> tail = new LinkedList<LogicalVariable>();
            for (LogicalVariable v : gby.getGroupByVarList()) {
                tail.add(v);
            }
            FunctionalDependency gbyfd = new FunctionalDependency(new LinkedList<LogicalVariable>(), tail);
            fds.add(gbyfd);
        }
        ctx.putFDList(op, fds);
        return null;
    }

    @Override
    public Void visitOrderOperator(OrderOperator op, IOptimizationContext ctx) throws AlgebricksException {
        this.propagateFDsAndEquivClasses(op, ctx);
        return null;
    }

    @Override
    public Void visitProjectOperator(ProjectOperator op, IOptimizationContext ctx) throws AlgebricksException {
        this.propagateFDsAndEquivClassesForUsedVars(op, ctx, op.getVariables());
        return null;
    }

    @Override
    public Void visitReplicateOperator(ReplicateOperator op, IOptimizationContext ctx) throws AlgebricksException {
        this.propagateFDsAndEquivClasses(op, ctx);
        return null;
    }

    @Override
    public Void visitSplitOperator(SplitOperator op, IOptimizationContext ctx) throws AlgebricksException {
        this.propagateFDsAndEquivClasses(op, ctx);
        return null;
    }

    @Override
    public Void visitMaterializeOperator(MaterializeOperator op, IOptimizationContext ctx) throws AlgebricksException {
        this.propagateFDsAndEquivClasses(op, ctx);
        return null;
    }

    @Override
    public Void visitRunningAggregateOperator(RunningAggregateOperator op, IOptimizationContext ctx) throws AlgebricksException {
        ctx.putEquivalenceClassMap(op, new HashMap<LogicalVariable, EquivalenceClass>());
        ctx.putFDList(op, new ArrayList<FunctionalDependency>());
        return null;
    }

    @Override
    public Void visitScriptOperator(ScriptOperator op, IOptimizationContext ctx) throws AlgebricksException {
        this.propagateFDsAndEquivClassesForUsedVars(op, ctx, op.getInputVariables());
        return null;
    }

    @Override
    public Void visitSelectOperator(SelectOperator op, IOptimizationContext ctx) throws AlgebricksException {
        ILogicalOperator childOp = (ILogicalOperator)op.getInputs().get(0).getValue();
        Map<LogicalVariable, EquivalenceClass> equivalenceClasses = this.getOrComputeEqClasses(childOp, ctx);
        ctx.putEquivalenceClassMap(op, equivalenceClasses);
        ArrayList<FunctionalDependency> functionalDependencies = new ArrayList<FunctionalDependency>();
        ctx.putFDList(op, functionalDependencies);
        functionalDependencies.addAll(this.getOrComputeFDs(childOp, ctx));
        equivalenceClasses.putAll(this.getOrComputeEqClasses(childOp, ctx));
        ILogicalExpression expr = (ILogicalExpression)op.getCondition().getValue();
        expr.getConstraintsAndEquivClasses(functionalDependencies, equivalenceClasses);
        return null;
    }

    @Override
    public Void visitSubplanOperator(SubplanOperator op, IOptimizationContext ctx) throws AlgebricksException {
        HashMap<LogicalVariable, EquivalenceClass> equivalenceClasses = new HashMap<LogicalVariable, EquivalenceClass>();
        ArrayList<FunctionalDependency> functionalDependencies = new ArrayList<FunctionalDependency>();
        ctx.putEquivalenceClassMap(op, equivalenceClasses);
        ctx.putFDList(op, functionalDependencies);
        for (ILogicalPlan p : op.getNestedPlans()) {
            for (Mutable<ILogicalOperator> r : p.getRoots()) {
                ILogicalOperator op2 = (ILogicalOperator)r.getValue();
                equivalenceClasses.putAll(this.getOrComputeEqClasses(op2, ctx));
                functionalDependencies.addAll(this.getOrComputeFDs(op2, ctx));
            }
        }
        return null;
    }

    @Override
    public Void visitUnionOperator(UnionAllOperator op, IOptimizationContext ctx) throws AlgebricksException {
        FDsAndEquivClassesVisitor.setEmptyFDsEqClasses(op, ctx);
        return null;
    }

    @Override
    public Void visitIntersectOperator(IntersectOperator op, IOptimizationContext ctx) throws AlgebricksException {
        FDsAndEquivClassesVisitor.setEmptyFDsEqClasses(op, ctx);
        return null;
    }

    @Override
    public Void visitUnnestMapOperator(UnnestMapOperator op, IOptimizationContext ctx) throws AlgebricksException {
        this.fdsEqClassesForAbstractUnnestOperator(op, ctx);
        return null;
    }

    @Override
    public Void visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, IOptimizationContext ctx) throws AlgebricksException {
        HashMap<LogicalVariable, EquivalenceClass> equivalenceClasses = new HashMap<LogicalVariable, EquivalenceClass>();
        ArrayList<FunctionalDependency> functionalDependencies = new ArrayList<FunctionalDependency>();
        ctx.putEquivalenceClassMap(op, equivalenceClasses);
        ctx.putFDList(op, functionalDependencies);
        ILogicalOperator childOp = (ILogicalOperator)op.getInputs().get(0).getValue();
        functionalDependencies.addAll(this.getOrComputeFDs(childOp, ctx));
        equivalenceClasses.putAll(this.getOrComputeEqClasses(childOp, ctx));
        ArrayList<LogicalVariable> leftSideVars = new ArrayList<LogicalVariable>();
        ArrayList<LogicalVariable> producedVars = new ArrayList<LogicalVariable>();
        VariableUtilities.getUsedVariables(op, leftSideVars);
        VariableUtilities.getProducedVariables(op, leftSideVars);
        functionalDependencies.add(new FunctionalDependency(leftSideVars, producedVars));
        return null;
    }

    @Override
    public Void visitUnnestOperator(UnnestOperator op, IOptimizationContext ctx) throws AlgebricksException {
        this.fdsEqClassesForAbstractUnnestOperator(op, ctx);
        return null;
    }

    @Override
    public Void visitWriteOperator(WriteOperator op, IOptimizationContext ctx) throws AlgebricksException {
        FDsAndEquivClassesVisitor.setEmptyFDsEqClasses(op, ctx);
        return null;
    }

    @Override
    public Void visitDistributeResultOperator(DistributeResultOperator op, IOptimizationContext ctx) throws AlgebricksException {
        FDsAndEquivClassesVisitor.setEmptyFDsEqClasses(op, ctx);
        return null;
    }

    @Override
    public Void visitWriteResultOperator(WriteResultOperator op, IOptimizationContext ctx) throws AlgebricksException {
        FDsAndEquivClassesVisitor.setEmptyFDsEqClasses(op, ctx);
        return null;
    }

    @Override
    public Void visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, IOptimizationContext ctx) throws AlgebricksException {
        this.propagateFDsAndEquivClasses(op, ctx);
        return null;
    }

    @Override
    public Void visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, IOptimizationContext ctx) throws AlgebricksException {
        this.propagateFDsAndEquivClasses(op, ctx);
        return null;
    }

    @Override
    public Void visitTokenizeOperator(TokenizeOperator op, IOptimizationContext ctx) throws AlgebricksException {
        FDsAndEquivClassesVisitor.setEmptyFDsEqClasses(op, ctx);
        return null;
    }

    @Override
    public Void visitForwardOperator(ForwardOperator op, IOptimizationContext ctx) throws AlgebricksException {
        this.propagateFDsAndEquivClasses(op, ctx);
        return null;
    }

    @Override
    public Void visitSinkOperator(SinkOperator op, IOptimizationContext ctx) throws AlgebricksException {
        FDsAndEquivClassesVisitor.setEmptyFDsEqClasses(op, ctx);
        return null;
    }

    private void propagateFDsAndEquivClasses(ILogicalOperator op, IOptimizationContext ctx) throws AlgebricksException {
        ILogicalOperator inp1 = (ILogicalOperator)op.getInputs().get(0).getValue();
        Map<LogicalVariable, EquivalenceClass> eqClasses = this.getOrComputeEqClasses(inp1, ctx);
        ctx.putEquivalenceClassMap(op, eqClasses);
        List<FunctionalDependency> fds = this.getOrComputeFDs(inp1, ctx);
        ctx.putFDList(op, fds);
    }

    private Map<LogicalVariable, EquivalenceClass> getOrComputeEqClasses(ILogicalOperator op, IOptimizationContext ctx) throws AlgebricksException {
        Map<LogicalVariable, EquivalenceClass> eqClasses = ctx.getEquivalenceClassMap(op);
        if (eqClasses == null) {
            op.accept(this, ctx);
            eqClasses = ctx.getEquivalenceClassMap(op);
        }
        return eqClasses;
    }

    private Map<LogicalVariable, EquivalenceClass> getOrCreateEqClasses(ILogicalOperator op, IOptimizationContext ctx) throws AlgebricksException {
        Map<LogicalVariable, EquivalenceClass> eqClasses = ctx.getEquivalenceClassMap(op);
        if (eqClasses == null) {
            eqClasses = new HashMap<LogicalVariable, EquivalenceClass>();
            ctx.putEquivalenceClassMap(op, eqClasses);
        }
        return eqClasses;
    }

    private List<FunctionalDependency> getOrComputeFDs(ILogicalOperator op, IOptimizationContext ctx) throws AlgebricksException {
        List<FunctionalDependency> fds = ctx.getFDList(op);
        if (fds == null) {
            op.accept(this, ctx);
            fds = ctx.getFDList(op);
        }
        return fds;
    }

    private void propagateFDsAndEquivClassesForUsedVars(ILogicalOperator op, IOptimizationContext ctx, List<LogicalVariable> usedVariables) throws AlgebricksException {
        ILogicalOperator op2 = (ILogicalOperator)op.getInputs().get(0).getValue();
        Map<LogicalVariable, EquivalenceClass> eqClasses = this.getOrCreateEqClasses(op, ctx);
        ArrayList<FunctionalDependency> fds = new ArrayList<FunctionalDependency>();
        ctx.putFDList(op, fds);
        Map<LogicalVariable, EquivalenceClass> chldClasses = this.getOrComputeEqClasses(op2, ctx);
        for (LogicalVariable v : usedVariables) {
            EquivalenceClass oc;
            EquivalenceClass ec2 = eqClasses.get(v);
            if (ec2 != null || (oc = chldClasses.get(v)) == null) continue;
            LinkedList<LogicalVariable> m = new LinkedList<LogicalVariable>();
            for (LogicalVariable logicalVariable : oc.getMembers()) {
                if (!usedVariables.contains(logicalVariable)) continue;
                m.add(logicalVariable);
            }
            EquivalenceClass nc = oc.representativeIsConst() ? new EquivalenceClass(m, oc.getConstRepresentative()) : (m.contains(oc.getVariableRepresentative()) ? new EquivalenceClass(m, oc.getVariableRepresentative()) : new EquivalenceClass(m, v));
            for (LogicalVariable v3 : m) {
                eqClasses.put(v3, nc);
            }
        }
        HashSet<LogicalVariable> usedVarSet = new HashSet<LogicalVariable>(usedVariables);
        chldClasses.forEach((key, ec) -> {
            for (ILogicalExpression expr : ec.getExpressionMembers()) {
                HashSet<LogicalVariable> exprUsedVars = new HashSet<LogicalVariable>();
                expr.getUsedVariables(exprUsedVars);
                exprUsedVars.retainAll(usedVarSet);
                if (exprUsedVars.isEmpty()) continue;
                ec.getMembers().forEach(v -> {
                    eqClasses.put((LogicalVariable)v, (EquivalenceClass)ec);
                    if (usedVarSet.contains(v)) {
                        ec.setVariableRepresentative((LogicalVariable)v);
                    }
                });
            }
        });
        List<FunctionalDependency> chldFds = this.getOrComputeFDs(op2, ctx);
        for (FunctionalDependency fd : chldFds) {
            if (!usedVariables.containsAll(fd.getHead())) continue;
            LinkedList<LogicalVariable> tl = new LinkedList<LogicalVariable>();
            for (LogicalVariable logicalVariable : fd.getTail()) {
                if (!usedVariables.contains(logicalVariable)) continue;
                tl.add(logicalVariable);
            }
            if (tl.isEmpty()) continue;
            FunctionalDependency newFd = new FunctionalDependency(fd.getHead(), tl);
            fds.add(newFd);
        }
    }

    private void fdsEqClassesForAbstractUnnestOperator(AbstractUnnestOperator op, IOptimizationContext ctx) throws AlgebricksException {
        AbstractFunctionCallExpression afe;
        ILogicalOperator inp1 = (ILogicalOperator)op.getInputs().get(0).getValue();
        Map<LogicalVariable, EquivalenceClass> eqClasses = this.getOrCreateEqClasses(op, ctx);
        Map<LogicalVariable, EquivalenceClass> propagatedEqClasses = this.getOrComputeEqClasses(inp1, ctx);
        eqClasses.putAll(propagatedEqClasses);
        ctx.putEquivalenceClassMap(op, eqClasses);
        List<FunctionalDependency> fds = this.getOrComputeFDs(inp1, ctx);
        ctx.putFDList(op, fds);
        ILogicalExpression expr = (ILogicalExpression)op.getExpressionRef().getValue();
        if (expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && (afe = (AbstractFunctionCallExpression)expr).getKind() == AbstractFunctionCallExpression.FunctionKind.UNNEST && ((UnnestingFunctionCallExpression)afe).returnsUniqueValues()) {
            ArrayList<LogicalVariable> vars = new ArrayList<LogicalVariable>();
            VariableUtilities.getLiveVariables(op, vars);
            ArrayList<LogicalVariable> h = new ArrayList<LogicalVariable>();
            h.addAll(op.getVariables());
            FunctionalDependency fd = new FunctionalDependency(h, vars);
            fds.add(fd);
        }
    }

    public static void setEmptyFDsEqClasses(ILogicalOperator op, IOptimizationContext ctx) {
        HashMap<LogicalVariable, EquivalenceClass> eqClasses = new HashMap<LogicalVariable, EquivalenceClass>();
        ctx.putEquivalenceClassMap(op, eqClasses);
        ArrayList<FunctionalDependency> fds = new ArrayList<FunctionalDependency>();
        ctx.putFDList(op, fds);
    }

    private LogicalVariable getNewGbyVar(GroupByOperator g, LogicalVariable v) {
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : g.getGroupByList()) {
            LogicalVariable v2;
            ILogicalExpression e = (ILogicalExpression)((Mutable)p.second).getValue();
            if (e.getExpressionTag() != LogicalExpressionTag.VARIABLE || (v2 = ((VariableReferenceExpression)e).getVariableReference()) != v) continue;
            return (LogicalVariable)p.first;
        }
        return null;
    }

    private LogicalVariable getNewDecorVar(GroupByOperator g, LogicalVariable v) {
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : g.getDecorList()) {
            LogicalVariable v2;
            ILogicalExpression e = (ILogicalExpression)((Mutable)p.second).getValue();
            if (e.getExpressionTag() != LogicalExpressionTag.VARIABLE || (v2 = ((VariableReferenceExpression)e).getVariableReference()) != v) continue;
            return p.first != null ? (LogicalVariable)p.first : v2;
        }
        return null;
    }

    @Override
    public Void visitDelegateOperator(DelegateOperator op, IOptimizationContext ctx) throws AlgebricksException {
        this.propagateFDsAndEquivClasses(op, ctx);
        return null;
    }

    private void propagateEquivalenceFromExpressionsToVariables(Map<LogicalVariable, EquivalenceClass> eqClasses, List<Mutable<ILogicalExpression>> assignExprs, List<LogicalVariable> assignVars) {
        for (int assignVarIndex = 0; assignVarIndex < assignVars.size(); ++assignVarIndex) {
            LogicalVariable var = assignVars.get(assignVarIndex);
            ILogicalExpression expr = (ILogicalExpression)assignExprs.get(assignVarIndex).getValue();
            HashMap newVarEqcMap = new HashMap();
            eqClasses.forEach((key, eqc) -> {
                if (eqc.contains(expr)) {
                    eqc.addMember(var);
                    newVarEqcMap.put(var, eqc);
                }
            });
            eqClasses.putAll(newVarEqcMap);
        }
    }

    @Override
    public Void visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, IOptimizationContext ctx) throws AlgebricksException {
        this.propagateFDsAndEquivClasses(op, ctx);
        return null;
    }

    @Override
    public Void visitWindowOperator(WindowOperator op, IOptimizationContext ctx) throws AlgebricksException {
        this.propagateFDsAndEquivClasses(op, ctx);
        return null;
    }
}

