/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.api.http.server.AbstractQueryApiServlet;
import org.apache.asterix.app.result.ExecutionError;
import org.apache.asterix.app.result.ResponsePrinter;
import org.apache.asterix.app.result.ResultHandle;
import org.apache.asterix.app.result.ResultReader;
import org.apache.asterix.app.result.fields.ErrorsPrinter;
import org.apache.asterix.app.result.fields.ResultHandlePrinter;
import org.apache.asterix.app.result.fields.StatusPrinter;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.translator.SessionOutput;
import org.apache.hyracks.api.result.ResultJobRecord;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryStatusApiServlet
extends AbstractQueryApiServlet {
    private static final Logger LOGGER = LogManager.getLogger();

    public QueryStatusApiServlet(ConcurrentMap<String, Object> ctx, IApplicationContext appCtx, String ... paths) {
        super(appCtx, ctx, paths);
    }

    protected void get(IServletRequest request, IServletResponse response) throws Exception {
        String strHandle = this.localPath(request);
        ResultHandle handle = ResultHandle.parse(strHandle);
        if (handle == null) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return;
        }
        ResultReader resultReader = new ResultReader(this.getResultSet(), handle.getJobId(), handle.getResultSetId());
        ResultJobRecord.Status resultReaderStatus = resultReader.getStatus();
        if (resultReaderStatus == null) {
            LOGGER.log(Level.INFO, "No results for: \"" + strHandle + "\"");
            response.setStatus(HttpResponseStatus.NOT_FOUND);
            return;
        }
        AbstractQueryApiServlet.ResultStatus resultStatus = this.resultStatus(resultReaderStatus);
        Exception ex = this.extractException(resultReaderStatus);
        HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (IServletRequest)request);
        PrintWriter resultWriter = response.writer();
        response.setStatus(HttpResponseStatus.OK);
        SessionOutput sessionOutput = new SessionOutput(resultWriter);
        ResponsePrinter printer = new ResponsePrinter(sessionOutput);
        printer.begin();
        printer.addHeaderPrinter(new StatusPrinter(resultStatus));
        printer.printHeaders();
        if (AbstractQueryApiServlet.ResultStatus.SUCCESS == resultStatus) {
            String servletPath = this.servletPath(request).replace("status", "result");
            String resHandle = "http://" + this.host(request) + servletPath + strHandle;
            printer.addResultPrinter(new ResultHandlePrinter(resHandle));
        } else if (ex != null) {
            printer.addResultPrinter(new ErrorsPrinter(Collections.singletonList(ExecutionError.of(ex))));
        }
        printer.printResults();
        printer.end();
        if (response.writer().checkError()) {
            LOGGER.warn("Error flushing output writer");
        }
    }

    AbstractQueryApiServlet.ResultStatus resultStatus(ResultJobRecord.Status status) {
        switch (status.getState()) {
            case IDLE: 
            case RUNNING: {
                return AbstractQueryApiServlet.ResultStatus.RUNNING;
            }
            case SUCCESS: {
                return AbstractQueryApiServlet.ResultStatus.SUCCESS;
            }
            case FAILED: {
                return AbstractQueryApiServlet.ResultStatus.FAILED;
            }
        }
        return AbstractQueryApiServlet.ResultStatus.FATAL;
    }

    Exception extractException(ResultJobRecord.Status status) {
        switch (status.getState()) {
            case FAILED: {
                List exceptions = status.getExceptions();
                if (exceptions != null && !exceptions.isEmpty()) {
                    return (Exception)exceptions.get(0);
                }
                return null;
            }
        }
        return null;
    }
}

