/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.result;

import org.apache.asterix.common.config.CompilerProperties;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.result.IResultMetadata;
import org.apache.hyracks.api.result.IResultSet;
import org.apache.hyracks.api.result.IResultSetReader;
import org.apache.hyracks.api.result.ResultJobRecord;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.api.service.IControllerService;
import org.apache.hyracks.client.result.ResultSet;
import org.apache.hyracks.dataflow.common.comm.io.ResultFrameTupleAccessor;

public class ResultReader {
    private final IResultSetReader reader;
    private final IFrameTupleAccessor frameTupleAccessor;
    public static final int NUM_READERS = 1;

    public ResultReader(IResultSet resultSet, JobId jobId, ResultSetId resultSetId) throws HyracksDataException {
        this.reader = resultSet.createReader(jobId, resultSetId);
        this.frameTupleAccessor = new ResultFrameTupleAccessor();
    }

    public ResultJobRecord.Status getStatus() {
        return this.reader.getResultStatus();
    }

    public int read(IFrame frame) throws HyracksDataException {
        return this.reader.read(frame);
    }

    public IFrameTupleAccessor getFrameTupleAccessor() {
        return this.frameTupleAccessor;
    }

    public IResultMetadata getMetadata() {
        return this.reader.getResultMetadata();
    }

    public static ResultSet createResultSet(IHyracksClientConnection hcc, IControllerService srv, CompilerProperties compilerProperties) throws Exception {
        return new ResultSet(hcc, srv.getNetworkSecurityManager().getSocketChannelFactory(), compilerProperties.getFrameSize(), 1);
    }
}

