/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.build;

import java.io.IOException;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.storage.am.common.api.IIndexBuilder;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.ILocalResourceRepository;
import org.apache.hyracks.storage.common.IResource;
import org.apache.hyracks.storage.common.IResourceFactory;
import org.apache.hyracks.storage.common.IResourceLifecycleManager;
import org.apache.hyracks.storage.common.IStorageManager;
import org.apache.hyracks.storage.common.LocalResource;
import org.apache.hyracks.storage.common.file.IResourceIdFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexBuilder
implements IIndexBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final INCServiceContext ctx;
    protected final IStorageManager storageManager;
    protected final FileReference resourceRef;
    protected final IResourceFactory localResourceFactory;
    protected final boolean durable;
    private final IResourceIdFactory resourceIdFactory;
    private final String resourceRelPath;

    public IndexBuilder(INCServiceContext ctx, IStorageManager storageManager, IResourceIdFactory resourceIdFactory, FileReference resourceRef, IResourceFactory localResourceFactory, boolean durable) throws HyracksDataException {
        this.ctx = ctx;
        this.storageManager = storageManager;
        this.resourceIdFactory = resourceIdFactory;
        this.localResourceFactory = localResourceFactory;
        this.durable = durable;
        this.resourceRef = resourceRef;
        this.resourceRelPath = resourceRef.getRelativePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build() throws HyracksDataException {
        IResourceLifecycleManager lcManager;
        IResourceLifecycleManager iResourceLifecycleManager = lcManager = this.storageManager.getLifecycleManager(this.ctx);
        synchronized (iResourceLifecycleManager) {
            long resourceId;
            ILocalResourceRepository localResourceRepository = this.storageManager.getLocalResourceRepository(this.ctx);
            LocalResource lr = localResourceRepository.get(this.resourceRelPath);
            long l = resourceId = lr == null ? -1L : lr.getId();
            if (resourceId != -1L) {
                localResourceRepository.delete(this.resourceRelPath);
            }
            resourceId = this.resourceIdFactory.createId();
            IResource resource = this.localResourceFactory.createResource(this.resourceRef);
            lr = new LocalResource(resourceId, 7, this.durable, resource);
            IIndex index = (IIndex)lcManager.get(this.resourceRelPath);
            if (index != null) {
                LOGGER.log(Level.WARN, "Removing existing index on index create for the index: " + this.resourceRelPath);
                lcManager.unregister(this.resourceRelPath);
                index.destroy();
            } else {
                FileReference resolvedResourceRef = this.ctx.getIoManager().resolve(this.resourceRelPath);
                if (resolvedResourceRef.getFile().exists()) {
                    LOGGER.warn("Deleting {} on index create. The index is not registered but the file exists in the filesystem", (Object)resolvedResourceRef);
                    IoUtil.delete((FileReference)resolvedResourceRef);
                }
                index = resource.createInstance(this.ctx);
            }
            index.create();
            try {
                localResourceRepository.insert(lr);
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            lcManager.register(this.resourceRelPath, (Object)index);
        }
    }
}

