/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.runtime;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.PointableBinaryHashFunctionFactory;
import org.apache.hyracks.data.std.accessors.UTF8StringBinaryComparatorFactory;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.hyracks.util.string.UTF8StringUtil;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class RuntimeRecordTypeInfo {
    private final IBinaryHashFunction fieldNameHashFunction;
    private final IBinaryComparator fieldNameComparator;
    private final UTF8StringWriter writer;
    private final ByteArrayAccessibleOutputStream baaos = new ByteArrayAccessibleOutputStream();
    private final DataOutputStream dos = new DataOutputStream((OutputStream)this.baaos);
    private int[] serializedFieldNameOffsets;
    private long[] hashCodeIndexPairs;
    private ARecordType cachedRecType = null;

    public RuntimeRecordTypeInfo() {
        this.fieldNameComparator = UTF8StringBinaryComparatorFactory.INSTANCE.createBinaryComparator();
        this.fieldNameHashFunction = new PointableBinaryHashFunctionFactory((IPointableFactory)UTF8StringPointable.FACTORY).createBinaryHashFunction();
        this.writer = new UTF8StringWriter();
    }

    public void reset(ARecordType recType) {
        if (this.cachedRecType == recType) {
            return;
        }
        this.cachedRecType = recType;
        this.baaos.reset();
        if (recType != null) {
            String[] fieldNames = recType.getFieldNames();
            if (this.serializedFieldNameOffsets == null || this.serializedFieldNameOffsets.length != fieldNames.length) {
                this.serializedFieldNameOffsets = new int[fieldNames.length];
                this.hashCodeIndexPairs = new long[fieldNames.length];
            }
            int length = 0;
            try {
                int i;
                for (i = 0; i < fieldNames.length; ++i) {
                    this.serializedFieldNameOffsets[i] = this.baaos.size();
                    this.writer.writeUTF8((CharSequence)fieldNames[i], (DataOutput)this.dos);
                    length = this.baaos.size() - this.serializedFieldNameOffsets[i];
                    this.hashCodeIndexPairs[i] = this.fieldNameHashFunction.hash(this.baaos.getByteArray(), this.serializedFieldNameOffsets[i], length);
                    this.hashCodeIndexPairs[i] = this.hashCodeIndexPairs[i] << 32;
                    this.hashCodeIndexPairs[i] = this.hashCodeIndexPairs[i] | (long)i;
                }
                this.dos.flush();
                Arrays.sort(this.hashCodeIndexPairs);
                for (i = 0; i < fieldNames.length; ++i) {
                    int j = this.getFieldIndex(this.baaos.getByteArray(), this.serializedFieldNameOffsets[i], UTF8StringUtil.getStringLength((byte[])this.baaos.getByteArray(), (int)this.serializedFieldNameOffsets[i]));
                    if (j == i) continue;
                    throw new RuntimeDataException(ErrorCode.DUPLICATE_FIELD_NAME, new Serializable[]{LogRedactionUtil.userData((String)fieldNames[i])});
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.serializedFieldNameOffsets = new int[0];
            this.hashCodeIndexPairs = new long[0];
        }
    }

    public int getFieldIndex(byte[] bytes, int start, int length) throws HyracksDataException {
        if (this.hashCodeIndexPairs.length == 0) {
            return -1;
        }
        int probeFieldHash = this.fieldNameHashFunction.hash(bytes, start, length);
        int i = Arrays.binarySearch(this.hashCodeIndexPairs, (long)probeFieldHash << 32);
        int n = i = i < 0 ? -1 * (i + 1) : i;
        while (i < this.hashCodeIndexPairs.length && (int)(this.hashCodeIndexPairs[i] >>> 32) == probeFieldHash) {
            int fIndex = (int)this.hashCodeIndexPairs[i];
            int cFieldLength = UTF8StringUtil.getStringLength((byte[])this.baaos.getByteArray(), (int)this.serializedFieldNameOffsets[fIndex]);
            if (this.fieldNameComparator.compare(this.baaos.getByteArray(), this.serializedFieldNameOffsets[fIndex], cFieldLength, bytes, start, length) == 0) {
                return fIndex;
            }
            ++i;
        }
        return -1;
    }
}

