/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.httpjson.OperationSnapshotFactory;
import com.google.api.gax.httpjson.PollingRequestFactory;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.rpc.LongRunningClient;
import com.google.api.gax.rpc.TranslatingUnaryCallable;
import com.google.api.gax.rpc.UnaryCallable;

@BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
@InternalApi
public class HttpJsonLongRunningClient<RequestT, OperationT>
implements LongRunningClient {
    private final UnaryCallable<RequestT, OperationT> operationCallable;
    private final OperationSnapshotFactory<RequestT, OperationT> operationSnapshotFactory;
    private final PollingRequestFactory<RequestT> pollingRequestFactory;

    public HttpJsonLongRunningClient(UnaryCallable<RequestT, OperationT> operationCallable, OperationSnapshotFactory<RequestT, OperationT> operationSnapshotFactory, PollingRequestFactory<RequestT> pollingRequestFactory) {
        this.operationCallable = operationCallable;
        this.operationSnapshotFactory = operationSnapshotFactory;
        this.pollingRequestFactory = pollingRequestFactory;
    }

    public UnaryCallable<String, OperationSnapshot> getOperationCallable() {
        return TranslatingUnaryCallable.create(this.operationCallable, (ApiFunction)new ApiFunction<String, RequestT>(){

            public RequestT apply(String id) {
                return HttpJsonLongRunningClient.this.pollingRequestFactory.create(id);
            }
        }, (ApiFunction)new ApiFunction<OperationT, OperationSnapshot>(){

            public OperationSnapshot apply(OperationT operation) {
                return HttpJsonLongRunningClient.this.operationSnapshotFactory.create(null, operation);
            }
        });
    }

    public UnaryCallable<String, Void> cancelOperationCallable() {
        return null;
    }

    public UnaryCallable<String, Void> deleteOperationCallable() {
        return null;
    }
}

