/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.common.heartbeat.HeartbeatData;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public abstract class AbstractHeartbeatWork
extends SynchronizableWork {
    protected final ClusterControllerService ccs;
    protected final String nodeId;
    protected final HeartbeatData hbData;

    public AbstractHeartbeatWork(ClusterControllerService ccs, String nodeId, HeartbeatData hbData) {
        this.ccs = ccs;
        this.nodeId = nodeId;
        this.hbData = hbData;
    }

    public void doRun() throws Exception {
        INodeManager nodeManager = this.ccs.getNodeManager();
        NodeControllerState state = nodeManager.getNodeControllerState(this.nodeId);
        if (state != null) {
            if (this.hbData != null) {
                state.notifyHeartbeat(this.hbData);
            } else {
                state.touchHeartbeat();
            }
        }
        this.runWork();
    }

    public abstract void runWork() throws Exception;
}

