/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.stats;

import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.annotations.StatsDoc;

@StatsDoc(name="bookie", category="server", help="EntryMemTable related stats")
public class EntryMemTableStats {
    @StatsDoc(name="SKIP_LIST_SNAPSHOT", help="operation stats of taking memtable snapshots")
    private final OpStatsLogger snapshotStats;
    @StatsDoc(name="SKIP_LIST_PUT_ENTRY", help="operation stats of putting entries to memtable", parent="BOOKIE_ADD_ENTRY")
    private final OpStatsLogger putEntryStats;
    @StatsDoc(name="SKIP_LIST_GET_ENTRY", help="operation stats of getting entries from memtable", parent="BOOKIE_ADD_ENTRY")
    private final OpStatsLogger getEntryStats;
    @StatsDoc(name="SKIP_LIST_FLUSH_BYTES", help="The number of bytes flushed from memtable to entry log files")
    private final Counter flushBytesCounter;
    @StatsDoc(name="SKIP_LIST_THROTTLING", help="The number of requests throttled due to memtables are full")
    private final Counter throttlingCounter;
    @StatsDoc(name="SKIP_LIST_THROTTLING_LATENCY", help="The distribution of request throttled duration")
    private final OpStatsLogger throttlingStats;

    public EntryMemTableStats(StatsLogger statsLogger) {
        this.snapshotStats = statsLogger.getOpStatsLogger("SKIP_LIST_SNAPSHOT");
        this.putEntryStats = statsLogger.getOpStatsLogger("SKIP_LIST_PUT_ENTRY");
        this.getEntryStats = statsLogger.getOpStatsLogger("SKIP_LIST_GET_ENTRY");
        this.flushBytesCounter = statsLogger.getCounter("SKIP_LIST_FLUSH_BYTES");
        this.throttlingCounter = statsLogger.getCounter("SKIP_LIST_THROTTLING");
        this.throttlingStats = statsLogger.getOpStatsLogger("SKIP_LIST_THROTTLING_LATENCY");
    }

    public OpStatsLogger getSnapshotStats() {
        return this.snapshotStats;
    }

    public OpStatsLogger getPutEntryStats() {
        return this.putEntryStats;
    }

    public OpStatsLogger getGetEntryStats() {
        return this.getEntryStats;
    }

    public Counter getFlushBytesCounter() {
        return this.flushBytesCounter;
    }

    public Counter getThrottlingCounter() {
        return this.throttlingCounter;
    }

    public OpStatsLogger getThrottlingStats() {
        return this.throttlingStats;
    }
}

