/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import org.apache.bookkeeper.zookeeper.RetryPolicy;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DistributedLogConstants;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClientUtils;
import org.apache.distributedlog.ZooKeeperClusterTestCase;
import org.apache.distributedlog.zk.ZKTransaction;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestZooKeeperClient
extends ZooKeeperClusterTestCase {
    static final Logger LOG = LoggerFactory.getLogger(TestZooKeeperClient.class);
    private static final int sessionTimeoutMs = 2000;
    private ZooKeeperClient zkc;

    @Before
    public void setup() throws Exception {
        this.zkc = this.buildClient();
    }

    @After
    public void teardown() throws Exception {
        this.zkc.close();
    }

    private ZooKeeperClientBuilder clientBuilder() throws Exception {
        return this.clientBuilder(2000);
    }

    private ZooKeeperClientBuilder clientBuilder(int sessionTimeoutMs) throws Exception {
        return ZooKeeperClientBuilder.newBuilder().name("zkc").uri(DLMTestUtil.createDLMURI(zkPort, "/")).sessionTimeoutMs(sessionTimeoutMs).zkServers(zkServers).retryPolicy((RetryPolicy)new BoundExponentialBackoffRetryPolicy(100L, 200L, 2));
    }

    private ZooKeeperClient buildClient() throws Exception {
        return this.clientBuilder().zkAclId(null).build();
    }

    private ZooKeeperClient buildAuthdClient(String id) throws Exception {
        return this.clientBuilder().zkAclId(id).build();
    }

    private void rmAll(ZooKeeperClient client, String path) throws Exception {
        List nodes = client.get().getChildren(path, false);
        for (String node : nodes) {
            String childPath = path + "/" + node;
            this.rmAll(client, childPath);
        }
        client.get().delete(path, 0);
    }

    @Test(timeout=60000L)
    public void testAclCreatePerms() throws Exception {
        ZooKeeperClient zkcAuth = this.buildAuthdClient("test");
        zkcAuth.get().create("/test", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zkcAuth.get().create("/test/key1", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zkcAuth.get().create("/test/key2", new byte[0], DistributedLogConstants.EVERYONE_READ_CREATOR_ALL, CreateMode.PERSISTENT);
        ZooKeeperClient zkcNoAuth = this.buildClient();
        zkcNoAuth.get().create("/test/key1/key1", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            zkcNoAuth.get().create("/test/key2/key1", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assert.fail((String)"create should fail on acl protected key");
        }
        catch (KeeperException.NoAuthException ex) {
            LOG.info("caught exception writing to protected key", (Throwable)ex);
        }
        this.rmAll(zkcAuth, "/test");
    }

    @Test(timeout=60000L)
    public void testAclNullIdDisablesAuth() throws Exception {
        ZooKeeperClient zkcAuth = this.buildAuthdClient(null);
        zkcAuth.get().create("/test", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zkcAuth.get().create("/test/key1", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            zkcAuth.get().create("/test/key2", new byte[0], DistributedLogConstants.EVERYONE_READ_CREATOR_ALL, CreateMode.PERSISTENT);
            Assert.fail((String)"create should fail because we're not authenticated");
        }
        catch (KeeperException.InvalidACLException ex) {
            LOG.info("caught exception writing to protected key", (Throwable)ex);
        }
        this.rmAll(zkcAuth, "/test");
    }

    @Test(timeout=60000L)
    public void testAclAllowsReadsForNoAuth() throws Exception {
        ZooKeeperClient zkcAuth = this.buildAuthdClient("test");
        zkcAuth.get().create("/test", new byte[0], DistributedLogConstants.EVERYONE_READ_CREATOR_ALL, CreateMode.PERSISTENT);
        zkcAuth.get().create("/test/key1", new byte[0], DistributedLogConstants.EVERYONE_READ_CREATOR_ALL, CreateMode.PERSISTENT);
        zkcAuth.get().create("/test/key1/key2", new byte[0], DistributedLogConstants.EVERYONE_READ_CREATOR_ALL, CreateMode.PERSISTENT);
        ZooKeeperClient zkcNoAuth = this.buildClient();
        List nodes = null;
        String path = "/test";
        nodes = zkcNoAuth.get().getChildren(path, false);
        path = path + "/" + (String)nodes.get(0);
        nodes = zkcNoAuth.get().getChildren(path, false);
        Assert.assertEquals((Object)"key2", nodes.get(0));
        ZooKeeperClient zkcAuth2 = this.buildAuthdClient("test2");
        path = "/test";
        nodes = zkcNoAuth.get().getChildren(path, false);
        path = path + "/" + (String)nodes.get(0);
        nodes = zkcNoAuth.get().getChildren(path, false);
        Assert.assertEquals((Object)"key2", nodes.get(0));
        this.rmAll(zkcAuth, "/test");
    }

    @Test(timeout=60000L)
    public void testAclDigestCredentialsBasics() throws Exception {
        ZooKeeperClient zkcAuth = this.buildClient();
        zkcAuth.get().create("/test", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            zkcAuth.get().create("/test/key1", new byte[0], DistributedLogConstants.EVERYONE_READ_CREATOR_ALL, CreateMode.PERSISTENT);
            Assert.fail((String)"should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ZooKeeperClient.DigestCredentials credentials = new ZooKeeperClient.DigestCredentials("test", "test");
        credentials.authenticate(zkcAuth.get());
        zkcAuth.get().create("/test/key1", new byte[0], DistributedLogConstants.EVERYONE_READ_CREATOR_ALL, CreateMode.PERSISTENT);
        this.rmAll(zkcAuth, "/test");
    }

    @Test(timeout=60000L)
    public void testAclNoopCredentialsDoesNothing() throws Exception {
        ZooKeeperClient.Credentials.NONE.authenticate(null);
    }

    @Test(timeout=60000L)
    public void testAclFailedAuthenticationCanBeRecovered() throws Exception {
        FailingCredentials credentials = new FailingCredentials();
        ZooKeeperClient zkc = new ZooKeeperClient("test", 2000, 2000, zkServers, null, (StatsLogger)NullStatsLogger.INSTANCE, 1, 10000.0, (ZooKeeperClient.Credentials)credentials);
        try {
            zkc.get();
            Assert.fail((String)"should have failed on auth");
        }
        catch (Exception ex) {
            Assert.assertEquals((Object)"authfailed", (Object)ex.getMessage());
        }
        credentials.setShouldFail(false);
        zkc.get().create("/test", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.rmAll(zkc, "/test");
    }

    private void expireZooKeeperSession(ZooKeeper zk, int timeout) throws IOException, InterruptedException, KeeperException {
        final CountDownLatch latch = new CountDownLatch(1);
        ZooKeeper newZk = new ZooKeeper(zkServers, timeout, new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getType() == Watcher.Event.EventType.None && event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    latch.countDown();
                }
            }
        }, zk.getSessionId(), zk.getSessionPasswd());
        if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.CONNECTIONLOSS);
        }
        newZk.close();
    }

    private CountDownLatch awaitConnectionEvent(final Watcher.Event.KeeperState state, ZooKeeperClient zkc) {
        final CountDownLatch connected = new CountDownLatch(1);
        Watcher watcher = new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getType() == Watcher.Event.EventType.None && event.getState() == state) {
                    connected.countDown();
                }
            }
        };
        zkc.register(watcher);
        return connected;
    }

    @Ignore
    @Test(timeout=60000L)
    public void testAclAuthSpansExpiration() throws Exception {
        ZooKeeperClient zkcAuth = this.buildAuthdClient("test");
        zkcAuth.get().create("/test", new byte[0], DistributedLogConstants.EVERYONE_READ_CREATOR_ALL, CreateMode.PERSISTENT);
        CountDownLatch expired = this.awaitConnectionEvent(Watcher.Event.KeeperState.Expired, zkcAuth);
        CountDownLatch connected = this.awaitConnectionEvent(Watcher.Event.KeeperState.SyncConnected, zkcAuth);
        this.expireZooKeeperSession(zkcAuth.get(), 2000);
        expired.await(2L, TimeUnit.SECONDS);
        connected.await(2L, TimeUnit.SECONDS);
        zkcAuth.get().create("/test/key1", new byte[0], DistributedLogConstants.EVERYONE_READ_CREATOR_ALL, CreateMode.PERSISTENT);
        this.rmAll(zkcAuth, "/test");
    }

    @Ignore
    @Test(timeout=60000L)
    public void testAclAuthSpansExpirationNonRetryableClient() throws Exception {
        ZooKeeperClient zkcAuth = this.clientBuilder().retryPolicy(null).zkAclId("test").build();
        zkcAuth.get().create("/test", new byte[0], DistributedLogConstants.EVERYONE_READ_CREATOR_ALL, CreateMode.PERSISTENT);
        CountDownLatch expired = this.awaitConnectionEvent(Watcher.Event.KeeperState.Expired, zkcAuth);
        CountDownLatch connected = this.awaitConnectionEvent(Watcher.Event.KeeperState.SyncConnected, zkcAuth);
        this.expireZooKeeperSession(zkcAuth.get(), 2000);
        expired.await(2L, TimeUnit.SECONDS);
        connected.await(2L, TimeUnit.SECONDS);
        zkcAuth.get().create("/test/key1", new byte[0], DistributedLogConstants.EVERYONE_READ_CREATOR_ALL, CreateMode.PERSISTENT);
        this.rmAll(zkcAuth, "/test");
    }

    @Test(timeout=60000L)
    public void testRegisterUnregisterWatchers() throws Exception {
        TestWatcher w1 = new TestWatcher();
        TestWatcher w2 = new TestWatcher();
        CountDownLatch latch = new CountDownLatch(2);
        w1.setLatch(latch);
        w2.setLatch(latch);
        this.zkc.register((Watcher)w1);
        this.zkc.register((Watcher)w2);
        Assert.assertEquals((long)2L, (long)this.zkc.watchers.size());
        String zkPath = "/test-register-unregister-watchers";
        this.zkc.get().create("/test-register-unregister-watchers", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zkc.get().getData("/test-register-unregister-watchers", true, new Stat());
        this.zkc.get().setData("/test-register-unregister-watchers", "first-set".getBytes(), -1);
        latch.await();
        Assert.assertEquals((long)1L, (long)w1.receivedEvents.size());
        Assert.assertEquals((Object)"/test-register-unregister-watchers", (Object)w1.receivedEvents.get(0).getPath());
        Assert.assertEquals((Object)Watcher.Event.EventType.NodeDataChanged, (Object)w1.receivedEvents.get(0).getType());
        Assert.assertEquals((long)1L, (long)w2.receivedEvents.size());
        Assert.assertEquals((Object)"/test-register-unregister-watchers", (Object)w2.receivedEvents.get(0).getPath());
        Assert.assertEquals((Object)Watcher.Event.EventType.NodeDataChanged, (Object)w2.receivedEvents.get(0).getType());
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        w1.setLatch(latch1);
        w2.setLatch(latch2);
        this.zkc.unregister((Watcher)w2);
        Assert.assertEquals((long)1L, (long)this.zkc.watchers.size());
        this.zkc.get().getData("/test-register-unregister-watchers", true, new Stat());
        this.zkc.get().setData("/test-register-unregister-watchers", "second-set".getBytes(), -1);
        latch1.await();
        Assert.assertEquals((long)2L, (long)w1.receivedEvents.size());
        Assert.assertEquals((Object)"/test-register-unregister-watchers", (Object)w1.receivedEvents.get(1).getPath());
        Assert.assertEquals((Object)Watcher.Event.EventType.NodeDataChanged, (Object)w1.receivedEvents.get(1).getType());
        Assert.assertFalse((boolean)latch2.await(2L, TimeUnit.SECONDS));
        Assert.assertEquals((long)1L, (long)w2.receivedEvents.size());
    }

    @Test(timeout=60000L)
    public void testExceptionOnWatchers() throws Exception {
        TestWatcher w1 = new TestWatcher();
        TestWatcher w2 = new TestWatcher();
        CountDownLatch latch = new CountDownLatch(2);
        w1.setLatch(latch);
        w2.setLatch(latch);
        this.zkc.register((Watcher)w1);
        this.zkc.register((Watcher)w2);
        this.zkc.register(new Watcher(){

            public void process(WatchedEvent event) {
                throw new NullPointerException("bad watcher returning null");
            }
        });
        Assert.assertEquals((long)3L, (long)this.zkc.watchers.size());
        String zkPath = "/test-exception-on-watchers";
        this.zkc.get().create("/test-exception-on-watchers", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zkc.get().getData("/test-exception-on-watchers", true, new Stat());
        this.zkc.get().setData("/test-exception-on-watchers", "first-set".getBytes(), -1);
        latch.await();
        Assert.assertEquals((long)1L, (long)w1.receivedEvents.size());
        Assert.assertEquals((Object)"/test-exception-on-watchers", (Object)w1.receivedEvents.get(0).getPath());
        Assert.assertEquals((Object)Watcher.Event.EventType.NodeDataChanged, (Object)w1.receivedEvents.get(0).getType());
        Assert.assertEquals((long)1L, (long)w2.receivedEvents.size());
        Assert.assertEquals((Object)"/test-exception-on-watchers", (Object)w2.receivedEvents.get(0).getPath());
        Assert.assertEquals((Object)Watcher.Event.EventType.NodeDataChanged, (Object)w2.receivedEvents.get(0).getType());
    }

    @Test(timeout=60000L)
    public void testZooKeeperReconnection() throws Exception {
        int sessionTimeoutMs = 100;
        ZooKeeperClient zkc = this.clientBuilder(sessionTimeoutMs).zkAclId(null).build();
        ZooKeeper zk = zkc.get();
        long sessionId = zk.getSessionId();
        ZooKeeperClientUtils.expireSession(zkc, zkServers, 2 * sessionTimeoutMs);
        ZooKeeper newZk = zkc.get();
        while (!ZooKeeper.States.CONNECTED.equals((Object)newZk.getState())) {
            TimeUnit.MILLISECONDS.sleep(sessionTimeoutMs / 2);
        }
        long newSessionId = newZk.getSessionId();
        Assert.assertTrue((newZk == zk ? 1 : 0) != 0);
        Assert.assertFalse((sessionId == newSessionId ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testZooKeeperReconnectionBlockingRetryThread() throws Exception {
        ZooKeeper newZk;
        int sessionTimeoutMs = 100;
        ZooKeeperClient zkc = this.clientBuilder(sessionTimeoutMs).zkAclId(null).build();
        ZooKeeper zk = zkc.get();
        Assert.assertTrue((boolean)(zk instanceof org.apache.bookkeeper.zookeeper.ZooKeeperClient));
        org.apache.bookkeeper.zookeeper.ZooKeeperClient bkZkc = (org.apache.bookkeeper.zookeeper.ZooKeeperClient)zk;
        Field connectExecutorField = bkZkc.getClass().getDeclaredField("connectExecutor");
        connectExecutorField.setAccessible(true);
        ExecutorService connectExecutor = (ExecutorService)connectExecutorField.get(bkZkc);
        final CountDownLatch latch = new CountDownLatch(1);
        connectExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        ZooKeeperClientUtils.expireSession(zkc, zkServers, 2 * sessionTimeoutMs);
        while ((newZk = zkc.get()) == zk) {
            TimeUnit.MILLISECONDS.sleep(sessionTimeoutMs / 2);
        }
        Assert.assertEquals((Object)ZooKeeper.States.CONNECTED, (Object)newZk.getState());
    }

    @Test(timeout=60000L)
    public void testZKTransactionEmptyOps() throws Exception {
        CompletableFuture future = new ZKTransaction(this.zkc).execute();
        Assert.assertTrue((boolean)future.isDone());
    }

    static class TestWatcher
    implements Watcher {
        final List<WatchedEvent> receivedEvents = new ArrayList<WatchedEvent>();
        CountDownLatch latch = new CountDownLatch(0);

        TestWatcher() {
        }

        public TestWatcher setLatch(CountDownLatch latch) {
            this.latch = latch;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                List<WatchedEvent> list = this.receivedEvents;
                synchronized (list) {
                    this.receivedEvents.add(event);
                }
                this.latch.countDown();
            }
        }
    }

    class FailingCredentials
    implements ZooKeeperClient.Credentials {
        boolean shouldFail = true;

        FailingCredentials() {
        }

        public void authenticate(ZooKeeper zooKeeper) {
            if (this.shouldFail) {
                throw new RuntimeException("authfailed");
            }
        }

        public void setShouldFail(boolean shouldFail) {
            this.shouldFail = shouldFail;
        }
    }
}

