/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.Fallbacks;
import org.jclouds.aws.ec2.domain.RouteTable;
import org.jclouds.aws.ec2.options.RouteOptions;
import org.jclouds.aws.ec2.options.RouteTableOptions;
import org.jclouds.aws.ec2.xml.AssociateRouteTableResponseHandler;
import org.jclouds.aws.ec2.xml.CreateRouteTableResponseHandler;
import org.jclouds.aws.ec2.xml.DescribeRouteTablesResponseHandler;
import org.jclouds.aws.ec2.xml.ReturnValueHandler;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={FormSigner.class})
@VirtualHost
@Path(value="/")
public interface RouteTableApi {
    @Named(value="CreateRouteTable")
    @POST
    @FormParams(keys={"Action"}, values={"CreateRouteTable"})
    @XMLResponseParser(value=CreateRouteTableResponseHandler.class)
    public RouteTable createRouteTable(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="VpcId") String var2);

    @Named(value="CreateRouteTable")
    @POST
    @FormParams(keys={"Action"}, values={"CreateRouteTable"})
    @XMLResponseParser(value=CreateRouteTableResponseHandler.class)
    public RouteTable createRouteTable(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="VpcId") String var2, RouteTableOptions var3);

    @Named(value="DeleteRouteTable")
    @POST
    @FormParams(keys={"Action"}, values={"DeleteRouteTable"})
    @XMLResponseParser(value=ReturnValueHandler.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteRouteTable(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="RouteTableId") String var2);

    @Named(value="DeleteRouteTable")
    @POST
    @FormParams(keys={"Action"}, values={"DeleteRouteTable"})
    @XMLResponseParser(value=ReturnValueHandler.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteRouteTable(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="RouteTableId") String var2, RouteTableOptions var3);

    @Named(value="AssociateRouteTable")
    @POST
    @FormParams(keys={"Action"}, values={"AssociateRouteTable"})
    @XMLResponseParser(value=AssociateRouteTableResponseHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public String associateRouteTable(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="RouteTableId") String var2, @FormParam(value="SubnetId") String var3);

    @Named(value="AssociateRouteTable")
    @POST
    @FormParams(keys={"Action"}, values={"AssociateRouteTable"})
    @XMLResponseParser(value=AssociateRouteTableResponseHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public String associateRouteTable(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="RouteTableId") String var2, @FormParam(value="SubnetId") String var3, RouteTableOptions var4);

    @Named(value="DisassociateRouteTable")
    @POST
    @FormParams(keys={"Action"}, values={"DisassociateRouteTable"})
    @XMLResponseParser(value=ReturnValueHandler.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean disassociateRouteTable(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="AssociationId") String var2);

    @Named(value="DisassociateRouteTable")
    @POST
    @FormParams(keys={"Action"}, values={"DisassociateRouteTable"})
    @XMLResponseParser(value=ReturnValueHandler.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean disassociateRouteTable(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="AssociationId") String var2, RouteTableOptions var3);

    @Named(value="CreateRoute")
    @POST
    @FormParams(keys={"Action"}, values={"CreateRoute"})
    @XMLResponseParser(value=ReturnValueHandler.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean createRoute(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="RouteTableId") String var2, RouteOptions var3);

    @Named(value="ReplaceRoute")
    @POST
    @FormParams(keys={"Action"}, values={"ReplaceRoute"})
    @XMLResponseParser(value=ReturnValueHandler.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean replaceRoute(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="RouteTableId") String var2, RouteOptions var3);

    @Named(value="DeleteRoute")
    @POST
    @FormParams(keys={"Action"}, values={"DeleteRoute"})
    @XMLResponseParser(value=ReturnValueHandler.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteRoute(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="RouteTableId") String var2, RouteOptions var3);

    @Named(value="DescribeRouteTables")
    @POST
    @FormParams(keys={"Action"}, values={"DescribeRouteTables"})
    @XMLResponseParser(value=DescribeRouteTablesResponseHandler.class)
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<RouteTable> describeRouteTables(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);
}

