/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import java.util.Map;
import org.jclouds.azurecompute.arm.domain.Plan;
import org.jclouds.azurecompute.arm.domain.VirtualMachine;
import org.jclouds.azurecompute.arm.domain.VirtualMachineProperties;
import org.jclouds.javax.annotation.Nullable;

final class AutoValue_VirtualMachine
extends VirtualMachine {
    private final String id;
    private final String name;
    private final String type;
    private final String location;
    private final Map<String, String> tags;
    private final VirtualMachineProperties properties;
    private final Plan plan;

    private AutoValue_VirtualMachine(String id, String name, String type, String location, @Nullable Map<String, String> tags, VirtualMachineProperties properties, @Nullable Plan plan) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.location = location;
        this.tags = tags;
        this.properties = properties;
        this.plan = plan;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    @Nullable
    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public VirtualMachineProperties properties() {
        return this.properties;
    }

    @Override
    @Nullable
    public Plan plan() {
        return this.plan;
    }

    public String toString() {
        return "VirtualMachine{id=" + this.id + ", " + "name=" + this.name + ", " + "type=" + this.type + ", " + "location=" + this.location + ", " + "tags=" + this.tags + ", " + "properties=" + this.properties + ", " + "plan=" + this.plan + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof VirtualMachine) {
            VirtualMachine that = (VirtualMachine)o;
            return this.id.equals(that.id()) && this.name.equals(that.name()) && this.type.equals(that.type()) && this.location.equals(that.location()) && (this.tags == null ? that.tags() == null : this.tags.equals(that.tags())) && this.properties.equals(that.properties()) && (this.plan == null ? that.plan() == null : this.plan.equals(that.plan()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.id.hashCode();
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h ^= this.type.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.tags == null ? 0 : this.tags.hashCode();
        h *= 1000003;
        h ^= this.properties.hashCode();
        h *= 1000003;
        return h ^= this.plan == null ? 0 : this.plan.hashCode();
    }

    @Override
    public VirtualMachine.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends VirtualMachine.Builder {
        private String id;
        private String name;
        private String type;
        private String location;
        private Map<String, String> tags;
        private VirtualMachineProperties properties;
        private Plan plan;

        Builder() {
        }

        private Builder(VirtualMachine source) {
            this.id = source.id();
            this.name = source.name();
            this.type = source.type();
            this.location = source.location();
            this.tags = source.tags();
            this.properties = source.properties();
            this.plan = source.plan();
        }

        @Override
        public VirtualMachine.Builder id(String id) {
            if (id == null) {
                throw new NullPointerException("Null id");
            }
            this.id = id;
            return this;
        }

        @Override
        public VirtualMachine.Builder name(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public VirtualMachine.Builder type(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public VirtualMachine.Builder location(String location) {
            if (location == null) {
                throw new NullPointerException("Null location");
            }
            this.location = location;
            return this;
        }

        @Override
        public VirtualMachine.Builder tags(@Nullable Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        @Override
        @Nullable
        Map<String, String> tags() {
            return this.tags;
        }

        @Override
        public VirtualMachine.Builder properties(VirtualMachineProperties properties) {
            if (properties == null) {
                throw new NullPointerException("Null properties");
            }
            this.properties = properties;
            return this;
        }

        @Override
        public VirtualMachine.Builder plan(@Nullable Plan plan) {
            this.plan = plan;
            return this;
        }

        @Override
        VirtualMachine autoBuild() {
            String missing = "";
            if (this.id == null) {
                missing = missing + " id";
            }
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.type == null) {
                missing = missing + " type";
            }
            if (this.location == null) {
                missing = missing + " location";
            }
            if (this.properties == null) {
                missing = missing + " properties";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_VirtualMachine(this.id, this.name, this.type, this.location, this.tags, this.properties, this.plan);
        }
    }
}

