/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.internal.EffectorUtils;
import org.apache.brooklyn.rest.api.EffectorApi;
import org.apache.brooklyn.rest.domain.EffectorSummary;
import org.apache.brooklyn.rest.domain.SummaryComparators;
import org.apache.brooklyn.rest.filter.HaHotStateRequired;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.transform.EffectorTransformer;
import org.apache.brooklyn.rest.transform.TaskTransformer;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class EffectorResource
extends AbstractBrooklynRestResource
implements EffectorApi {
    private static final Logger log = LoggerFactory.getLogger(EffectorResource.class);

    public List<EffectorSummary> list(String application, String entityToken) {
        final Entity entity = this.brooklyn().getEntity(application, entityToken);
        return FluentIterable.from((Iterable)entity.getEntityType().getEffectors()).filter(new Predicate<Effector<?>>(){

            public boolean apply(@Nullable Effector<?> input) {
                return Entitlements.isEntitled((EntitlementManager)EffectorResource.this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.INVOKE_EFFECTOR, (Object)Entitlements.EntityAndItem.of((Entity)entity, (Object)Entitlements.StringAndArgument.of((String)input.getName(), null)));
            }
        }).transform(new Function<Effector<?>, EffectorSummary>(){

            public EffectorSummary apply(Effector<?> effector) {
                return EffectorTransformer.effectorSummary(entity, effector, EffectorResource.this.ui.getBaseUriBuilder());
            }
        }).toSortedList(SummaryComparators.nameComparator());
    }

    public Response invoke(String application, String entityToken, String effectorName, String timeout, Map<String, Object> parameters) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        Maybe effector = EffectorUtils.findEffectorDeclared((Entity)entity, (String)effectorName);
        if (effector.isAbsentOrNull()) {
            throw WebResourceUtils.notFound("Entity '%s' has no effector with name '%s'", entityToken, effectorName);
        }
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.INVOKE_EFFECTOR, (Object)Entitlements.EntityAndItem.of((Entity)entity, (Object)Entitlements.StringAndArgument.of((String)((Effector)effector.get()).getName(), null)))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to invoke effector %s on entity %s", Entitlements.getEntitlementContext().user(), ((Effector)effector.get()).getName(), entity);
        }
        String userInfo = Entitlements.getEntitlementContext() != null ? "by user " + Entitlements.getEntitlementContext().user() : "(no user info available)";
        log.info("REST invocation of " + entity + "." + effector.get() + " " + Sanitizer.sanitize(parameters) + " " + userInfo);
        Task t = entity.invoke((Effector)effector.get(), parameters);
        try {
            Object result;
            if (timeout == null || timeout.isEmpty() || "never".equalsIgnoreCase(timeout)) {
                result = t.get();
            } else {
                long timeoutMillis = "always".equalsIgnoreCase(timeout) ? 0L : Time.parseElapsedTime((String)timeout);
                try {
                    if (timeoutMillis == 0L) {
                        throw new TimeoutException();
                    }
                    result = t.get(timeoutMillis, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    result = TaskTransformer.taskSummary(t, this.ui.getBaseUriBuilder());
                }
            }
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity(result).build();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

