/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.variables;

import java.util.List;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.steps.variables.WorkflowTransformWithContext;

public abstract class WorkflowTransformDefault
implements WorkflowTransformWithContext {
    protected WorkflowExecutionContext context;
    protected WorkflowStepInstanceExecutionContext stepContext;
    protected List<String> definition;
    protected String transformDef;

    @Override
    public void init(WorkflowExecutionContext context, WorkflowStepInstanceExecutionContext stepContext, List<String> definition, String transformDef) {
        this.context = context;
        this.stepContext = stepContext;
        this.definition = definition;
        this.transformDef = transformDef;
        this.initCheckingDefinition();
        this.initCheckingTransformPermitted();
    }

    protected void initCheckingTransformPermitted() {
        if (this.stepContext.next == "end") {
            throw new IllegalStateException("Cannot perform transform after 'return'");
        }
    }

    @Override
    public Boolean resolvedValueRequirement() {
        return true;
    }

    @Override
    public Boolean resolvedValueReturned() {
        return null;
    }

    protected void initCheckingDefinition() {
        if (this.definition != null && this.definition.size() > 1) {
            throw new IllegalArgumentException("Transform '" + this.definition.get(0) + "' does not accept args: " + this.definition.subList(1, this.definition.size()));
        }
    }
}

