/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock;

import com.google.common.base.Function;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.enricher.stock.AbstractTransformer;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="YAML Time-weighted Delta", description="Converts an absolute count sensor into a delta sensor")
public class YamlTimeWeightedDeltaEnricher<T extends Number>
extends AbstractTransformer<T, Double> {
    private static final Logger LOG = LoggerFactory.getLogger(YamlTimeWeightedDeltaEnricher.class);
    transient Object lock = new Object();
    Number lastValue;
    long lastTime = -1L;
    public static final ConfigKey<Duration> DELTA_PERIOD = ConfigKeys.newConfigKey(Duration.class, "enricher.delta.period", "Duration that this delta should compute for (default is one second)", Duration.ONE_SECOND);

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.getRequiredConfig(SOURCE_SENSOR);
    }

    @Override
    protected Function<SensorEvent<T>, Double> getTransformation() {
        return new Function<SensorEvent<T>, Double>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Double apply(SensorEvent<T> event) {
                Object object = YamlTimeWeightedDeltaEnricher.this.lock;
                synchronized (object) {
                    Double current = TypeCoercions.coerce(event.getValue(), Double.class);
                    if (current == null) {
                        return null;
                    }
                    long eventTime = event.getTimestamp();
                    long unitMillis = YamlTimeWeightedDeltaEnricher.this.getConfig(DELTA_PERIOD).toMilliseconds();
                    Double result = null;
                    if (eventTime > 0L && eventTime > YamlTimeWeightedDeltaEnricher.this.lastTime) {
                        if (YamlTimeWeightedDeltaEnricher.this.lastValue == null || YamlTimeWeightedDeltaEnricher.this.lastTime < 0L) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("{} received event but no last value so will not emit, null -> {} at {}", new Object[]{this, current, eventTime});
                            }
                        } else {
                            double duration = eventTime - YamlTimeWeightedDeltaEnricher.this.lastTime;
                            result = (current - YamlTimeWeightedDeltaEnricher.this.lastValue.doubleValue()) / (duration / (double)unitMillis);
                        }
                    }
                    YamlTimeWeightedDeltaEnricher.this.lastValue = current;
                    YamlTimeWeightedDeltaEnricher.this.lastTime = eventTime;
                    return result;
                }
            }
        };
    }
}

