/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.functions.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.features.TenantApi;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

@Singleton
@Beta
public class ParseTenants
extends ParseJson<Tenants> {
    @Inject
    public ParseTenants(Json json) {
        super(json, TypeLiteral.get(Tenants.class));
    }

    public static class ToPagedIterable
    extends Arg0ToPagedIterable.FromCaller<Tenant, ToPagedIterable> {
        private final KeystoneApi api;

        @Inject
        protected ToPagedIterable(KeystoneApi api) {
            this.api = (KeystoneApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        protected Function<Object, IterableWithMarker<Tenant>> markerToNextForArg0(Optional<Object> ignored) {
            final TenantApi tenantApi = (TenantApi)this.api.getTenantApi().get();
            return new Function<Object, IterableWithMarker<Tenant>>(){

                public IterableWithMarker<Tenant> apply(Object input) {
                    PaginationOptions paginationOptions = (PaginationOptions)((Object)PaginationOptions.class.cast(input));
                    return (IterableWithMarker)IterableWithMarker.class.cast(tenantApi.list(paginationOptions));
                }

                public String toString() {
                    return "listTenants()";
                }
            };
        }
    }

    static class Tenants
    extends PaginatedCollection<Tenant> {
        @ConstructorProperties(value={"tenants", "tenants_links"})
        protected Tenants(Iterable<Tenant> tenants, Iterable<Link> tenants_links) {
            super(tenants, tenants_links);
        }
    }
}

