/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.http.options.BaseHttpRequestOptions;
import org.jclouds.s3.domain.CannedAccessPolicy;

public class PutBucketOptions
extends BaseHttpRequestOptions {
    private CannedAccessPolicy acl = CannedAccessPolicy.PRIVATE;
    private String headerTag;

    @Inject
    public void setHeaderTag(@Named(value="jclouds.aws.header.tag") String headerTag) {
        this.headerTag = headerTag;
    }

    public Multimap<String, String> buildRequestHeaders() {
        Preconditions.checkState((this.headerTag != null ? 1 : 0) != 0, (Object)"headerTag should have been injected!");
        LinkedHashMultimap returnVal = LinkedHashMultimap.create();
        for (Map.Entry entry : this.headers.entries()) {
            returnVal.put((Object)((String)entry.getKey()).replace("aws", this.headerTag), (Object)((String)entry.getValue()));
        }
        return returnVal;
    }

    public PutBucketOptions withBucketAcl(CannedAccessPolicy acl) {
        this.acl = (CannedAccessPolicy)((Object)Preconditions.checkNotNull((Object)((Object)acl), (Object)"acl"));
        if (!acl.equals((Object)CannedAccessPolicy.PRIVATE)) {
            this.replaceHeader("x-amz-acl", acl.toString());
        }
        return this;
    }

    public CannedAccessPolicy getAcl() {
        return this.acl;
    }

    public static class Builder {
        public static PutBucketOptions withBucketAcl(CannedAccessPolicy acl) {
            PutBucketOptions options = new PutBucketOptions();
            return options.withBucketAcl(acl);
        }
    }
}

