/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.creation;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.brooklyn.api.location.LocationDefinition;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;

public class BrooklynYamlLocationResolver {
    protected final ManagementContext mgmt;

    public BrooklynYamlLocationResolver(ManagementContext bmc) {
        this.mgmt = bmc;
    }

    public List<LocationSpec<?>> resolveLocations(Map<? super String, ?> attrs, boolean removeUsedAttributes) {
        Object location = attrs.get("location");
        Object locations = attrs.get("locations");
        if (location == null && locations == null) {
            return null;
        }
        LocationSpec<?> locationFromString = null;
        List<LocationSpec<?>> locationsFromList = null;
        if (location != null) {
            if (location instanceof String) {
                locationFromString = this.resolveLocationFromString((String)location);
            } else if (location instanceof Map) {
                locationFromString = this.resolveLocationFromMap((Map)location);
            } else {
                throw new UserFacingException("Illegal parameter for 'location'; must be a string or map (but got " + location + ")");
            }
        }
        if (locations != null) {
            if (!(locations instanceof Iterable)) {
                throw new UserFacingException("Illegal parameter for 'locations'; must be an iterable (but got " + locations + ")");
            }
            locationsFromList = this.resolveLocations((Iterable)locations);
        }
        if (locationFromString != null && locationsFromList != null) {
            if (locationsFromList.size() != 1) {
                throw new UserFacingException("Conflicting 'location' and 'locations' (" + location + " and " + locations + "); if both are supplied the list must have exactly one element being the same");
            }
            if (!locationFromString.equals(Iterables.getOnlyElement(locationsFromList))) {
                throw new UserFacingException("Conflicting 'location' and 'locations' (" + location + " and " + locations + "); different location specified in each");
            }
        } else if (locationFromString != null) {
            locationsFromList = Arrays.asList(locationFromString);
        }
        return locationsFromList;
    }

    public List<LocationSpec<?>> resolveLocations(Iterable<Object> locations) {
        MutableList result = MutableList.of();
        for (Object l : locations) {
            LocationSpec<?> ll = this.resolveLocation(l);
            if (ll == null) continue;
            result.add(ll);
        }
        return result;
    }

    public LocationSpec<?> resolveLocation(Object location) {
        if (location instanceof String) {
            return this.resolveLocationFromString((String)location);
        }
        if (location instanceof Map) {
            return this.resolveLocationFromMap((Map)location);
        }
        throw new UserFacingException("Illegal parameter for 'location' (" + location + "); must be a string or map");
    }

    public LocationSpec<?> resolveLocationFromString(String location) {
        if (Strings.isBlank((CharSequence)location)) {
            return null;
        }
        return this.resolveLocation(location, (Map<?, ?>)MutableMap.of());
    }

    public LocationSpec<?> resolveLocationFromMap(Map<?, ?> location) {
        if (location.size() > 1) {
            throw new UserFacingException("Illegal parameter for 'location'; expected a single entry in map (" + location + ")");
        }
        Object key = Iterables.getOnlyElement(location.keySet());
        Object value = location.get(key);
        if (!(key instanceof String)) {
            throw new UserFacingException("Illegal parameter for 'location'; expected String key (" + location + ")");
        }
        if (!(value instanceof Map)) {
            throw new UserFacingException("Illegal parameter for 'location'; expected config map (" + location + ")");
        }
        return this.resolveLocation((String)key, (Map)value);
    }

    protected LocationSpec<?> resolveLocation(String spec, Map<?, ?> flags) {
        LocationDefinition ldef = this.mgmt.getLocationRegistry().getDefinedLocationByName(spec);
        if (ldef != null) {
            return (LocationSpec)this.mgmt.getLocationRegistry().getLocationSpec(ldef, flags).get();
        }
        Maybe l = this.mgmt.getLocationRegistry().getLocationSpec(spec, flags);
        if (l.isPresent()) {
            return (LocationSpec)l.get();
        }
        RuntimeException exception = Maybe.getException((Maybe)l);
        if (exception instanceof NoSuchElementException && exception.getMessage().contains("Unknown location")) {
            throw new UserFacingException(exception.getMessage(), exception.getCause());
        }
        throw new UserFacingException("Illegal parameter for 'location' (" + spec + "); not resolvable: " + Exceptions.collapseText((Throwable)exception), (Throwable)exception);
    }
}

