/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class MathAggregatorFunctions {
    private static final Logger LOG = LoggerFactory.getLogger(MathAggregatorFunctions.class);

    private MathAggregatorFunctions() {
    }

    @Beta
    public static <T extends Number> Function<Collection<? extends Number>, T> computingSum(Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, Class<T> type) {
        return MathAggregatorFunctions.computingSum(defaultValueForUnreportedSensors, valueToReportIfNoSensors, TypeToken.of(type));
    }

    @Beta
    public static <T extends Number> Function<Collection<? extends Number>, T> computingSum(Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, TypeToken<T> typeToken) {
        return new ComputingSum<T>(defaultValueForUnreportedSensors, valueToReportIfNoSensors, typeToken);
    }

    @Beta
    public static <T extends Number> Function<Collection<? extends Number>, T> computingAverage(Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, Class<T> type) {
        return MathAggregatorFunctions.computingAverage(defaultValueForUnreportedSensors, valueToReportIfNoSensors, TypeToken.of(type));
    }

    @Beta
    public static <T extends Number> Function<Collection<? extends Number>, T> computingAverage(Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, TypeToken<T> typeToken) {
        return new ComputingAverage<T>(defaultValueForUnreportedSensors, valueToReportIfNoSensors, typeToken);
    }

    @Beta
    public static <T extends Number> Function<Collection<? extends Number>, T> computingMin(Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, Class<T> type) {
        return MathAggregatorFunctions.computingMin(defaultValueForUnreportedSensors, valueToReportIfNoSensors, TypeToken.of(type));
    }

    @Beta
    public static <T extends Number> Function<Collection<? extends Number>, T> computingMin(Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, TypeToken<T> typeToken) {
        return new ComputingMin<T>(defaultValueForUnreportedSensors, valueToReportIfNoSensors, typeToken);
    }

    @Beta
    public static <T extends Number> Function<Collection<? extends Number>, T> computingMax(Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, Class<T> type) {
        return MathAggregatorFunctions.computingMax(defaultValueForUnreportedSensors, valueToReportIfNoSensors, TypeToken.of(type));
    }

    @Beta
    public static <T extends Number> Function<Collection<? extends Number>, T> computingMax(Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, TypeToken<T> typeToken) {
        return new ComputingMax<T>(defaultValueForUnreportedSensors, valueToReportIfNoSensors, typeToken);
    }

    protected static <N extends Number> N cast(Number n, TypeToken<? extends N> numberType) {
        return (N)((Number)TypeCoercions.coerce((Object)n, numberType));
    }

    @Beta
    protected static class ComputingMax<T extends Number>
    extends BasicComputingNumber<T> {
        public ComputingMax(Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, TypeToken<T> typeToken) {
            super(defaultValueForUnreportedSensors, valueToReportIfNoSensors, typeToken);
        }

        @Override
        public Number applyImpl(Collection<Number> vals) {
            Double result = null;
            for (Number val : vals) {
                result = result == null ? val.doubleValue() : Math.max(result, val.doubleValue());
            }
            return result;
        }
    }

    @Beta
    protected static class ComputingMin<T extends Number>
    extends BasicComputingNumber<T> {
        public ComputingMin(Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, TypeToken<T> typeToken) {
            super(defaultValueForUnreportedSensors, valueToReportIfNoSensors, typeToken);
        }

        @Override
        public Number applyImpl(Collection<Number> vals) {
            Double result = null;
            for (Number val : vals) {
                result = result == null ? val.doubleValue() : Math.min(result, val.doubleValue());
            }
            return result;
        }
    }

    @Beta
    protected static class ComputingAverage<T extends Number>
    extends BasicComputingNumber<T> {
        public ComputingAverage(Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, TypeToken<T> typeToken) {
            super(defaultValueForUnreportedSensors, valueToReportIfNoSensors, typeToken);
        }

        @Override
        public Number applyImpl(Collection<Number> vals) {
            double sum = 0.0;
            for (Number val : vals) {
                sum += val.doubleValue();
            }
            return sum / (double)vals.size();
        }
    }

    @Beta
    protected static class ComputingSum<T extends Number>
    extends BasicComputingNumber<T> {
        public ComputingSum(Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, TypeToken<T> typeToken) {
            super(defaultValueForUnreportedSensors, valueToReportIfNoSensors, typeToken);
        }

        @Override
        public Number applyImpl(Collection<Number> vals) {
            double result = 0.0;
            for (Number val : vals) {
                result += val.doubleValue();
            }
            return result;
        }
    }

    @Beta
    protected static abstract class BasicComputingNumber<T extends Number>
    extends AbstractComputingNumber<T> {
        private boolean loggedNonNumber;

        public BasicComputingNumber(Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, TypeToken<T> typeToken) {
            super(defaultValueForUnreportedSensors, valueToReportIfNoSensors, typeToken);
        }

        @Override
        public T apply(@Nullable Collection<? extends Number> vals) {
            ArrayList<Number> postProcessedVals = new ArrayList<Number>();
            int count = 0;
            boolean hasNonNumber = false;
            if (vals != null) {
                for (Number number : vals) {
                    Maybe<Number> coercedVal = TypeCoercions.tryCoerce((Object)number, Number.class);
                    if (coercedVal.isPresentAndNonNull()) {
                        postProcessedVals.add((Number)coercedVal.get());
                        ++count;
                        continue;
                    }
                    if (number != null) {
                        hasNonNumber = true;
                        if (this.loggedNonNumber) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Input to numeric aggregator is not a number (again): " + number + " (" + number.getClass() + ")");
                            }
                        } else {
                            this.loggedNonNumber = true;
                            LOG.warn("Input to numeric aggregator is not a number: " + number + " (" + number.getClass() + ")");
                        }
                    }
                    if (this.defaultValueForUnreportedSensors == null) continue;
                    postProcessedVals.add(this.defaultValueForUnreportedSensors);
                    ++count;
                }
            }
            if (!hasNonNumber) {
                this.loggedNonNumber = false;
            }
            if (count == 0) {
                return (T)MathAggregatorFunctions.cast(this.valueToReportIfNoSensors, this.typeToken);
            }
            Number result = this.applyImpl(postProcessedVals);
            return (T)MathAggregatorFunctions.cast(result, this.typeToken);
        }

        public abstract Number applyImpl(Collection<Number> var1);
    }

    @Beta
    protected static abstract class AbstractComputingNumber<T extends Number>
    implements Function<Collection<? extends Number>, T> {
        protected final Number defaultValueForUnreportedSensors;
        protected final Number valueToReportIfNoSensors;
        protected final TypeToken<T> typeToken;

        public AbstractComputingNumber(Number defaultValueForUnreportedSensors, Number valueToReportIfNoSensors, TypeToken<T> typeToken) {
            this.defaultValueForUnreportedSensors = defaultValueForUnreportedSensors;
            this.valueToReportIfNoSensors = valueToReportIfNoSensors;
            if (typeToken != null && TypeToken.of(Number.class).isSupertypeOf(typeToken.getType())) {
                this.typeToken = typeToken;
            } else if (typeToken == null || typeToken.isSupertypeOf(Number.class)) {
                this.typeToken = TypeToken.of(Double.class);
            } else {
                throw new IllegalArgumentException("Type " + typeToken + " is not valid for " + this);
            }
        }

        public abstract T apply(Collection<? extends Number> var1);
    }
}

