/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.UnknownHostException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.EndpointSnitchInfoMBean;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.utils.MBeanWrapper;

public class EndpointSnitchInfo
implements EndpointSnitchInfoMBean {
    public static void create() {
        MBeanWrapper.instance.registerMBean((Object)new EndpointSnitchInfo(), "org.apache.cassandra.db:type=EndpointSnitchInfo");
    }

    @Override
    public String getDatacenter(String host) throws UnknownHostException {
        return DatabaseDescriptor.getEndpointSnitch().getDatacenter(InetAddressAndPort.getByName(host));
    }

    @Override
    public String getRack(String host) throws UnknownHostException {
        return DatabaseDescriptor.getEndpointSnitch().getRack(InetAddressAndPort.getByName(host));
    }

    @Override
    public String getDatacenter() {
        return DatabaseDescriptor.getEndpointSnitch().getLocalDatacenter();
    }

    @Override
    public String getRack() {
        return DatabaseDescriptor.getEndpointSnitch().getLocalRack();
    }

    @Override
    public String getSnitchName() {
        return DatabaseDescriptor.getEndpointSnitch().getClass().getName();
    }
}

