/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.commitlog.PartitionUpdateWrapper;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.spark.utils.AsyncExecutor;
import org.apache.cassandra.utils.TokenUtils;
import org.jetbrains.annotations.Nullable;

public class FourZeroPartitionUpdateWrapper
extends PartitionUpdateWrapper {
    private final PartitionUpdate update;

    public FourZeroPartitionUpdateWrapper(PartitionUpdate update, long maxTimestampMicros, @Nullable AsyncExecutor executor) {
        super(update.metadata().keyspace, update.metadata().name, TokenUtils.tokenToBigInteger((Token)update.partitionKey().getToken()), update.dataSize(), () -> FourZeroPartitionUpdateWrapper.computeDigest(update), update.partitionKey().getKey(), maxTimestampMicros, executor);
        this.update = update;
    }

    public PartitionUpdate partitionUpdate() {
        return this.update;
    }

    public static byte[] computeDigest(PartitionUpdate update) {
        Digest digest = Digest.forReadResponse();
        UnfilteredRowIterators.digest((UnfilteredRowIterator)update.unfilteredIterator(), (Digest)digest, (int)12);
        return digest.digest();
    }
}

