/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.DataLayer;
import org.apache.cassandra.spark.sparksql.CellIterator;
import org.apache.cassandra.spark.sparksql.FullRowBuilder;
import org.apache.cassandra.spark.sparksql.PartialRowBuilder;
import org.apache.cassandra.spark.sparksql.RowBuilder;
import org.apache.cassandra.spark.sparksql.RowIterator;
import org.apache.cassandra.spark.sparksql.SparkCellIterator;
import org.apache.cassandra.spark.sparksql.filters.PartitionKeyFilter;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractSparkRowIterator<T>
extends RowIterator<T> {
    AbstractSparkRowIterator(int partitionId, @NotNull DataLayer dataLayer, @Nullable StructType requiredSchema, @NotNull List<PartitionKeyFilter> partitionKeyFilters, Function<RowBuilder<T>, RowBuilder<T>> decorator) {
        super(AbstractSparkRowIterator.buildCellIterator(partitionId, dataLayer.cqlTable(), requiredSchema, dataLayer, partitionKeyFilters), dataLayer.stats(), requiredSchema == null ? null : requiredSchema.fieldNames(), decorator);
    }

    protected static CellIterator buildCellIterator(int partitionId, CqlTable cqlTable, @Nullable StructType requiredSchema, @NotNull DataLayer dataLayer, @NotNull List<PartitionKeyFilter> partitionKeyFilters) {
        StructType columnFilter = AbstractSparkRowIterator.useColumnFilter(requiredSchema, cqlTable) ? requiredSchema : null;
        return new SparkCellIterator(partitionId, dataLayer, columnFilter, partitionKeyFilters);
    }

    private static boolean useColumnFilter(@Nullable StructType requiredSchema, CqlTable cqlTable) {
        if (requiredSchema == null) {
            return false;
        }
        Set requiredFields = Arrays.stream(requiredSchema.fields()).map(StructField::name).collect(Collectors.toSet());
        return cqlTable.fields().stream().map(CqlField::name).anyMatch(field -> !requiredFields.contains(field));
    }

    public abstract T rowBuilder(Object[] var1);

    public PartialRowBuilder<T> newPartialBuilder() {
        return new PartialRowBuilder(this.requiredColumns, this.it.cqlTable(), this.it.hasProjectedValueColumns(), this::rowBuilder);
    }

    public FullRowBuilder<T> newFullRowBuilder() {
        return new FullRowBuilder(this.it.cqlTable(), this.it.hasProjectedValueColumns(), this::rowBuilder);
    }
}

