/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.transports.storage;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Objects;
import org.apache.cassandra.spark.transports.storage.StorageCredentials;
import org.jetbrains.annotations.NotNull;

public class StorageAccessConfiguration {
    private final String region;
    private final String bucket;
    private final StorageCredentials storageCredentials;

    public StorageAccessConfiguration(@NotNull String region, @NotNull String bucket, @NotNull StorageCredentials storageCredentials) {
        this.region = region;
        this.bucket = bucket;
        this.storageCredentials = storageCredentials;
    }

    public StorageAccessConfiguration copyWithNewCredentials(@NotNull StorageCredentials newCredentials) {
        return new StorageAccessConfiguration(this.region, this.bucket, newCredentials);
    }

    public String region() {
        return this.region;
    }

    public String bucket() {
        return this.bucket;
    }

    public StorageCredentials storageCredentials() {
        return this.storageCredentials;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StorageAccessConfiguration)) {
            return false;
        }
        StorageAccessConfiguration that = (StorageAccessConfiguration)obj;
        return Objects.equals(this.region, that.region) && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.storageCredentials, that.storageCredentials);
    }

    public int hashCode() {
        return Objects.hash(this.region, this.bucket, this.storageCredentials);
    }

    public String toString() {
        return "StorageAccessConfiguration{region='" + this.region + "', bucket='" + this.bucket + "', credentials='" + String.valueOf(this.storageCredentials) + "'}";
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<StorageAccessConfiguration> {
        public void write(Kryo kryo, Output out, StorageAccessConfiguration object) {
            out.writeString(object.region);
            out.writeString(object.bucket);
            kryo.writeObject(out, (Object)object.storageCredentials);
        }

        public StorageAccessConfiguration read(Kryo kryo, Input in, Class<StorageAccessConfiguration> type) {
            return new StorageAccessConfiguration(in.readString(), in.readString(), (StorageCredentials)kryo.readObject(in, StorageCredentials.class));
        }
    }
}

