/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.channel;

import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.bytes.SyncMode;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.channel.PipeHandler;
import net.openhft.chronicle.queue.channel.impl.SubscribeQueueChannel;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.channel.AbstractHandler;
import net.openhft.chronicle.wire.channel.ChronicleChannel;
import net.openhft.chronicle.wire.channel.ChronicleChannelCfg;
import net.openhft.chronicle.wire.channel.ChronicleContext;
import net.openhft.chronicle.wire.channel.EventPoller;
import net.openhft.chronicle.wire.channel.InternalChronicleChannel;

public class SubscribeHandler
extends AbstractHandler<SubscribeHandler> {
    private String subscribe;
    private transient boolean closeWhenRunEnds = true;
    private SyncMode syncMode;

    static void queueTailer(Pauser pauser, ChronicleChannel channel, ChronicleQueue subscribeQueue) {
        try (ChronicleQueue subscribeQ = subscribeQueue;
             ExcerptTailer tailer = subscribeQ.createTailer();){
            while (!channel.isClosing()) {
                if (SubscribeHandler.copyOneMessage(channel, tailer)) {
                    pauser.reset();
                    continue;
                }
                pauser.pause();
            }
        }
        catch (Exception e) {
            Thread.yield();
            if (channel.isClosing()) {
                return;
            }
            throw e;
        }
    }

    static boolean copyOneMessage(ChronicleChannel channel, ExcerptTailer tailer) {
        try (DocumentContext dc = tailer.readingDocument();){
            long dataBuffered;
            if (!dc.isPresent()) {
                boolean bl = false;
                return bl;
            }
            if (dc.isMetaData()) {
                boolean bl = false;
                return bl;
            }
            try (DocumentContext dc2 = channel.writingDocument();){
                dc.wire().copyTo((WireOut)dc2.wire());
                dataBuffered = dc2.wire().bytes().writePosition();
            }
            boolean bl = dataBuffered < 32768L;
            return bl;
        }
    }

    public String subscribe() {
        return this.subscribe;
    }

    public SubscribeHandler subscribe(String subscribe) {
        this.subscribe = subscribe;
        return this;
    }

    public SyncMode syncMode() {
        return this.syncMode;
    }

    public SubscribeHandler syncMode(SyncMode syncMode) {
        this.syncMode = syncMode;
        return this;
    }

    public void run(ChronicleContext context, ChronicleChannel channel) {
        TimingPauser pauser = Pauser.balanced();
        ChronicleQueue subscribeQ = PipeHandler.newQueue(context, this.subscribe, this.syncMode);
        InternalChronicleChannel icc = (InternalChronicleChannel)channel;
        if (icc.supportsEventPoller()) {
            ExcerptTailer tailer = subscribeQ.createTailer();
            icc.eventPoller((EventPoller)new SHEventHandler(tailer));
            this.closeWhenRunEnds = false;
        } else {
            try (AffinityLock lock = context.affinityLock();){
                SubscribeHandler.queueTailer(pauser, channel, PipeHandler.newQueue(context, this.subscribe, this.syncMode));
            }
            this.closeWhenRunEnds = true;
        }
    }

    public boolean closeWhenRunEnds() {
        return this.closeWhenRunEnds;
    }

    public ChronicleChannel asInternalChannel(ChronicleContext context, ChronicleChannelCfg channelCfg) {
        return new SubscribeQueueChannel(channelCfg, this, PipeHandler.newQueue(context, this.subscribe, this.syncMode));
    }

    static class SHEventHandler
    extends SimpleCloseable
    implements EventPoller {
        private final ExcerptTailer tailer;

        SHEventHandler(ExcerptTailer tailer) {
            this.tailer = tailer;
        }

        public boolean onPoll(ChronicleChannel channel) {
            boolean wrote = false;
            while (SubscribeHandler.copyOneMessage(channel, this.tailer)) {
                wrote = true;
            }
            return wrote;
        }

        @Override
        protected void performClose() {
            super.performClose();
            Closeable.closeQuietly((Object)this.tailer);
        }
    }
}

