/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.io;

import java.io.IOException;
import java.util.zip.Checksum;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;

class BufferedChecksumIndexInput
extends ChecksumIndexInput {
    final IndexInput delegate;
    final Checksum digest;

    public BufferedChecksumIndexInput(IndexInput delegate, Checksum digest) {
        super("BufferedChecksumIndexInput(" + delegate + ")");
        this.delegate = delegate;
        this.digest = digest;
    }

    @Override
    public byte readByte() throws IOException {
        byte b = this.delegate.readByte();
        this.digest.update(b);
        return b;
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.delegate.readBytes(b, offset, len);
        this.digest.update(b, offset, len);
    }

    @Override
    public long getChecksum() {
        return this.digest.getValue();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public long getFilePointer() {
        return this.delegate.getFilePointer();
    }

    @Override
    public long length() {
        return this.delegate.length();
    }

    @Override
    public IndexInput clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        throw new UnsupportedOperationException();
    }
}

