/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.metrics;

import com.codahale.metrics.RatioGauge;
import org.apache.cassandra.index.sai.StorageAttachedIndexGroup;
import org.apache.cassandra.index.sai.metrics.AbstractMetrics;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.schema.TableMetadata;

public class TableStateMetrics
extends AbstractMetrics {
    public static final String TABLE_STATE_METRIC_TYPE = "TableStateMetrics";

    public TableStateMetrics(TableMetadata table, final StorageAttachedIndexGroup group) {
        super(table.keyspace, table.name, TABLE_STATE_METRIC_TYPE);
        CassandraMetricsRegistry.Metrics.register(this.createMetricName("DiskUsedBytes"), group::totalDiskUsage);
        CassandraMetricsRegistry.Metrics.register(this.createMetricName("DiskPercentageOfBaseTable"), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of(group.totalDiskUsage(), group.table().metric.liveDiskSpaceUsed.getCount());
            }
        });
        CassandraMetricsRegistry.Metrics.register(this.createMetricName("TotalIndexCount"), group::totalIndexCount);
        CassandraMetricsRegistry.Metrics.register(this.createMetricName("TotalQueryableIndexCount"), group::totalQueryableIndexCount);
        CassandraMetricsRegistry.Metrics.register(this.createMetricName("TotalIndexBuildsInProgress"), group::totalIndexBuildsInProgress);
    }
}

