/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.collect.ImmutableList;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.io.util.SequentialWriterOption;
import org.apache.cassandra.net.AsyncStreamingInputPlus;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableZeroCopyWriter
extends SSTable
implements SSTableMultiWriter {
    private static final Logger logger = LoggerFactory.getLogger(SSTableZeroCopyWriter.class);
    private volatile SSTableReader finalReader;
    private final Map<String, ZeroCopySequentialWriter> componentWriters;

    public SSTableZeroCopyWriter(SSTable.Builder<?, ?> builder, LifecycleNewTracker lifecycleNewTracker, SSTable.Owner owner) {
        super(builder, owner);
        lifecycleNewTracker.trackNew(this);
        this.componentWriters = new HashMap<String, ZeroCopySequentialWriter>();
        Set unsupported = this.components.stream().filter(c -> !c.type.streamable).collect(Collectors.toSet());
        if (!unsupported.isEmpty()) {
            throw new AssertionError((Object)String.format("Unsupported streaming components detected: %s", unsupported));
        }
        for (Component c2 : this.components) {
            this.componentWriters.put(c2.name, this.makeWriter(this.descriptor, c2));
        }
    }

    @Override
    public DecoratedKey getFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DecoratedKey getLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractBounds<Token> getBounds() {
        throw new UnsupportedOperationException();
    }

    private ZeroCopySequentialWriter makeWriter(Descriptor descriptor, Component component) {
        return new ZeroCopySequentialWriter(descriptor.fileFor(component), this.ioOptions.writerOptions, false);
    }

    private void write(DataInputPlus in, long size, ZeroCopySequentialWriter out) throws FSWriteError {
        int BUFFER_SIZE = 0x100000;
        byte[] buff = new byte[0x100000];
        try {
            int count;
            for (long bytesRead = 0L; bytesRead < size; bytesRead += (long)count) {
                int toRead = (int)Math.min(size - bytesRead, 0x100000L);
                in.readFully(buff, 0, toRead);
                count = Math.min(toRead, 0x100000);
                out.write(buff, 0, count);
            }
            out.sync();
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, out.getFile());
        }
    }

    @Override
    public void append(UnfilteredRowIterator partition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<SSTableReader> finish(boolean openResult) {
        this.setOpenResult(openResult);
        for (ZeroCopySequentialWriter writer : this.componentWriters.values()) {
            writer.finish();
        }
        return this.finished();
    }

    @Override
    public Collection<SSTableReader> finished() {
        if (this.finalReader == null) {
            this.finalReader = SSTableReader.open(this.owner().orElse(null), this.descriptor, this.components, this.metadata);
        }
        return ImmutableList.of(this.finalReader);
    }

    @Override
    public SSTableMultiWriter setOpenResult(boolean openResult) {
        return null;
    }

    @Override
    public long getBytesWritten() {
        return 0L;
    }

    @Override
    public long getOnDiskBytesWritten() {
        return 0L;
    }

    @Override
    public TableId getTableId() {
        return this.metadata.id;
    }

    @Override
    public Throwable commit(Throwable accumulate) {
        for (ZeroCopySequentialWriter writer : this.componentWriters.values()) {
            accumulate = writer.commit(accumulate);
        }
        return accumulate;
    }

    @Override
    public Throwable abort(Throwable accumulate) {
        for (ZeroCopySequentialWriter writer : this.componentWriters.values()) {
            accumulate = writer.abort(accumulate);
        }
        return accumulate;
    }

    @Override
    public void prepareToCommit() {
        for (ZeroCopySequentialWriter writer : this.componentWriters.values()) {
            writer.prepareToCommit();
        }
    }

    @Override
    public void close() {
        for (ZeroCopySequentialWriter writer : this.componentWriters.values()) {
            writer.close();
        }
    }

    public void writeComponent(Component component, DataInputPlus in, long size) throws ClosedChannelException {
        ZeroCopySequentialWriter writer = this.componentWriters.get(component.name);
        logger.info("Writing component {} to {} length {}", new Object[]{component, writer.getPath(), FBUtilities.prettyPrintMemory(size)});
        if (in instanceof AsyncStreamingInputPlus) {
            this.write((AsyncStreamingInputPlus)in, size, writer);
        } else {
            this.write(in, size, writer);
        }
    }

    private void write(AsyncStreamingInputPlus in, long size, ZeroCopySequentialWriter writer) throws ClosedChannelException {
        logger.info("Block Writing component to {} length {}", (Object)writer.getPath(), (Object)FBUtilities.prettyPrintMemory(size));
        try {
            in.consume(writer::writeDirectlyToChannel, size);
            writer.sync();
        }
        catch (EOFException e) {
            in.close();
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, writer.getPath());
        }
    }

    private static class ZeroCopySequentialWriter
    extends SequentialWriter {
        private ZeroCopySequentialWriter(File file, SequentialWriterOption option, boolean strictFlushing) {
            super(file, ByteBufferUtil.EMPTY_BYTE_BUFFER, option, strictFlushing);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.buffer == ByteBufferUtil.EMPTY_BYTE_BUFFER) {
                this.buffer = this.option.allocateBuffer();
            }
            super.write(b, off, len);
        }
    }
}

