/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.util.zip.CRC32;
import net.jpountz.xxhash.XXHashFactory;
import org.caffinitas.ohc.HashAlgorithm;
import org.caffinitas.ohc.linked.Uns;

abstract class Hasher {
    Hasher() {
    }

    static Hasher create(HashAlgorithm hashAlgorithm) {
        String cls = Hasher.forAlg(hashAlgorithm);
        try {
            return (Hasher)Class.forName(cls).newInstance();
        }
        catch (ClassNotFoundException e) {
            if (hashAlgorithm == HashAlgorithm.XX) {
                cls = Hasher.forAlg(HashAlgorithm.CRC32);
                try {
                    return (Hasher)Class.forName(cls).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e1) {
                    throw new RuntimeException(e1);
                }
            }
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private static String forAlg(HashAlgorithm hashAlgorithm) {
        return Hasher.class.getName() + '$' + hashAlgorithm.name().substring(0, 1) + hashAlgorithm.name().substring(1).toLowerCase() + "Hash";
    }

    abstract long hash(byte[] var1);

    abstract long hash(long var1, long var3, int var5);

    static final class XxHash
    extends Hasher {
        private static final XXHashFactory xx = XXHashFactory.fastestInstance();

        XxHash() {
        }

        @Override
        long hash(long address, long offset, int length) {
            return xx.hash64().hash(Uns.directBufferFor(address, offset, length, true), 0L);
        }

        @Override
        long hash(byte[] array) {
            return xx.hash64().hash(array, 0, array.length, 0L);
        }
    }

    static final class Murmur3Hash
    extends Hasher {
        static final long C1 = -8663945395140668459L;
        static final long C2 = 5545529020109919103L;

        Murmur3Hash() {
        }

        @Override
        long hash(byte[] array) {
            long k2;
            long k1;
            int r;
            int o = 0;
            long h1 = 0L;
            long h2 = 0L;
            for (r = array.length; r >= 16; r -= 16) {
                k1 = Murmur3Hash.getLong(array, o);
                k2 = Murmur3Hash.getLong(array, o += 8);
                o += 8;
                h1 ^= Murmur3Hash.mixK1(k1);
                h1 = Long.rotateLeft(h1, 27);
                h1 += h2;
                h1 = h1 * 5L + 1390208809L;
                h2 ^= Murmur3Hash.mixK2(k2);
                h2 = Long.rotateLeft(h2, 31);
                h2 += h1;
                h2 = h2 * 5L + 944331445L;
            }
            if (r > 0) {
                k1 = 0L;
                k2 = 0L;
                switch (r) {
                    case 15: {
                        k2 ^= Murmur3Hash.toLong(array[o + 14]) << 48;
                    }
                    case 14: {
                        k2 ^= Murmur3Hash.toLong(array[o + 13]) << 40;
                    }
                    case 13: {
                        k2 ^= Murmur3Hash.toLong(array[o + 12]) << 32;
                    }
                    case 12: {
                        k2 ^= Murmur3Hash.toLong(array[o + 11]) << 24;
                    }
                    case 11: {
                        k2 ^= Murmur3Hash.toLong(array[o + 10]) << 16;
                    }
                    case 10: {
                        k2 ^= Murmur3Hash.toLong(array[o + 9]) << 8;
                    }
                    case 9: {
                        k2 ^= Murmur3Hash.toLong(array[o + 8]);
                    }
                    case 8: {
                        k1 ^= Murmur3Hash.getLong(array, o);
                        break;
                    }
                    case 7: {
                        k1 ^= Murmur3Hash.toLong(array[o + 6]) << 48;
                    }
                    case 6: {
                        k1 ^= Murmur3Hash.toLong(array[o + 5]) << 40;
                    }
                    case 5: {
                        k1 ^= Murmur3Hash.toLong(array[o + 4]) << 32;
                    }
                    case 4: {
                        k1 ^= Murmur3Hash.toLong(array[o + 3]) << 24;
                    }
                    case 3: {
                        k1 ^= Murmur3Hash.toLong(array[o + 2]) << 16;
                    }
                    case 2: {
                        k1 ^= Murmur3Hash.toLong(array[o + 1]) << 8;
                    }
                    case 1: {
                        k1 ^= Murmur3Hash.toLong(array[o]);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Should never get here.");
                    }
                }
                h1 ^= Murmur3Hash.mixK1(k1);
                h2 ^= Murmur3Hash.mixK2(k2);
            }
            h1 ^= (long)array.length;
            h1 += (h2 ^= (long)array.length);
            h2 += h1;
            h1 = Murmur3Hash.fmix64(h1);
            h2 = Murmur3Hash.fmix64(h2);
            return h1 += h2;
        }

        private static long getLong(byte[] array, int o) {
            long l = Murmur3Hash.toLong(array[o + 7]) << 56;
            l |= Murmur3Hash.toLong(array[o + 6]) << 48;
            l |= Murmur3Hash.toLong(array[o + 5]) << 40;
            l |= Murmur3Hash.toLong(array[o + 4]) << 32;
            l |= Murmur3Hash.toLong(array[o + 3]) << 24;
            l |= Murmur3Hash.toLong(array[o + 2]) << 16;
            l |= Murmur3Hash.toLong(array[o + 1]) << 8;
            return l |= Murmur3Hash.toLong(array[o]);
        }

        @Override
        long hash(long adr, long offset, int length) {
            long k2;
            long k1;
            long r;
            long o = offset;
            long h1 = 0L;
            long h2 = 0L;
            for (r = (long)length; r >= 16L; r -= 16L) {
                k1 = Murmur3Hash.getLong(adr, o);
                k2 = Murmur3Hash.getLong(adr, o += 8L);
                o += 8L;
                h1 ^= Murmur3Hash.mixK1(k1);
                h1 = Long.rotateLeft(h1, 27);
                h1 += h2;
                h1 = h1 * 5L + 1390208809L;
                h2 ^= Murmur3Hash.mixK2(k2);
                h2 = Long.rotateLeft(h2, 31);
                h2 += h1;
                h2 = h2 * 5L + 944331445L;
            }
            if (r > 0L) {
                k1 = 0L;
                k2 = 0L;
                switch ((int)r) {
                    case 15: {
                        k2 ^= Murmur3Hash.toLong(Uns.getByte(adr, o + 14L)) << 48;
                    }
                    case 14: {
                        k2 ^= Murmur3Hash.toLong(Uns.getByte(adr, o + 13L)) << 40;
                    }
                    case 13: {
                        k2 ^= Murmur3Hash.toLong(Uns.getByte(adr, o + 12L)) << 32;
                    }
                    case 12: {
                        k2 ^= Murmur3Hash.toLong(Uns.getByte(adr, o + 11L)) << 24;
                    }
                    case 11: {
                        k2 ^= Murmur3Hash.toLong(Uns.getByte(adr, o + 10L)) << 16;
                    }
                    case 10: {
                        k2 ^= Murmur3Hash.toLong(Uns.getByte(adr, o + 9L)) << 8;
                    }
                    case 9: {
                        k2 ^= Murmur3Hash.toLong(Uns.getByte(adr, o + 8L));
                    }
                    case 8: {
                        k1 ^= Murmur3Hash.getLong(adr, o);
                        break;
                    }
                    case 7: {
                        k1 ^= Murmur3Hash.toLong(Uns.getByte(adr, o + 6L)) << 48;
                    }
                    case 6: {
                        k1 ^= Murmur3Hash.toLong(Uns.getByte(adr, o + 5L)) << 40;
                    }
                    case 5: {
                        k1 ^= Murmur3Hash.toLong(Uns.getByte(adr, o + 4L)) << 32;
                    }
                    case 4: {
                        k1 ^= Murmur3Hash.toLong(Uns.getByte(adr, o + 3L)) << 24;
                    }
                    case 3: {
                        k1 ^= Murmur3Hash.toLong(Uns.getByte(adr, o + 2L)) << 16;
                    }
                    case 2: {
                        k1 ^= Murmur3Hash.toLong(Uns.getByte(adr, o + 1L)) << 8;
                    }
                    case 1: {
                        k1 ^= Murmur3Hash.toLong(Uns.getByte(adr, o));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Should never get here.");
                    }
                }
                h1 ^= Murmur3Hash.mixK1(k1);
                h2 ^= Murmur3Hash.mixK2(k2);
            }
            h1 ^= (long)length;
            h1 += (h2 ^= (long)length);
            h2 += h1;
            h1 = Murmur3Hash.fmix64(h1);
            h2 = Murmur3Hash.fmix64(h2);
            return h1 += h2;
        }

        private static long getLong(long adr, long o) {
            long l = Murmur3Hash.toLong(Uns.getByte(adr, o + 7L)) << 56;
            l |= Murmur3Hash.toLong(Uns.getByte(adr, o + 6L)) << 48;
            l |= Murmur3Hash.toLong(Uns.getByte(adr, o + 5L)) << 40;
            l |= Murmur3Hash.toLong(Uns.getByte(adr, o + 4L)) << 32;
            l |= Murmur3Hash.toLong(Uns.getByte(adr, o + 3L)) << 24;
            l |= Murmur3Hash.toLong(Uns.getByte(adr, o + 2L)) << 16;
            l |= Murmur3Hash.toLong(Uns.getByte(adr, o + 1L)) << 8;
            return l |= Murmur3Hash.toLong(Uns.getByte(adr, o));
        }

        static long fmix64(long k) {
            k ^= k >>> 33;
            k *= -49064778989728563L;
            k ^= k >>> 33;
            k *= -4265267296055464877L;
            k ^= k >>> 33;
            return k;
        }

        static long mixK1(long k1) {
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            return k1 *= 5545529020109919103L;
        }

        static long mixK2(long k2) {
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            return k2 *= -8663945395140668459L;
        }

        static long toLong(byte value) {
            return value & 0xFF;
        }
    }

    static final class Crc32Hash
    extends Hasher {
        Crc32Hash() {
        }

        @Override
        long hash(byte[] array) {
            CRC32 crc = new CRC32();
            crc.update(array);
            long h2 = crc.getValue();
            h2 |= h2 << 32;
            return h2;
        }

        @Override
        long hash(long address, long offset, int length) {
            return Uns.crc32(address, offset, length);
        }
    }
}

