/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gridkit.jvmtool.stacktrace.CounterCollection;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;
import org.gridkit.jvmtool.stacktrace.analytics.PositionalStackMatcher;
import org.gridkit.jvmtool.stacktrace.analytics.StackFrameMatcher;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadSnapshotFilter;

public class BasicFilterFactory {
    public ThreadSnapshotFilter disjunction(ThreadSnapshotFilter ... subfilters) {
        return this.disjunction(Arrays.asList(subfilters));
    }

    public ThreadSnapshotFilter disjunction(Collection<ThreadSnapshotFilter> subfilters) {
        if (subfilters.isEmpty()) {
            return this.trueFilter();
        }
        return new DisjunctionFilter(subfilters.toArray(new ThreadSnapshotFilter[0]));
    }

    public ThreadSnapshotFilter conjunction(ThreadSnapshotFilter ... subfilters) {
        return this.conjunction(Arrays.asList(subfilters));
    }

    public ThreadSnapshotFilter conjunction(Collection<ThreadSnapshotFilter> subfilters) {
        if (subfilters.isEmpty()) {
            return this.falseFilter();
        }
        return new ConjunctionFilter(subfilters.toArray(new ThreadSnapshotFilter[0]));
    }

    public StackFrameMatcher matcherConjunction(StackFrameMatcher ... subfilters) {
        return this.matcherConjunction(Arrays.asList(subfilters));
    }

    public StackFrameMatcher matcherConjunction(Collection<StackFrameMatcher> subfilters) {
        if (subfilters.isEmpty()) {
            return this.falseFrameMatcher();
        }
        return new ConjunctionMatcher(subfilters.toArray(new StackFrameMatcher[0]));
    }

    public ThreadSnapshotFilter not(final ThreadSnapshotFilter filter) {
        return new ThreadSnapshotFilter(){

            @Override
            public boolean evaluate(ThreadSnapshot snapshot) {
                return !filter.evaluate(snapshot);
            }
        };
    }

    public ThreadSnapshotFilter followed(PositionalStackMatcher matcher, ThreadSnapshotFilter filter) {
        return new FollowedPredicate(matcher, filter);
    }

    public ThreadSnapshotFilter frameFilter(final StackFrameMatcher matcher) {
        return new ThreadSnapshotFilter(){

            @Override
            public boolean evaluate(ThreadSnapshot snapshot) {
                for (StackFrame frame : snapshot.stackTrace()) {
                    if (!matcher.evaluate(frame)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public ThreadSnapshotFilter falseFilter() {
        return new FalseFilter();
    }

    public StackFrameMatcher falseFrameMatcher() {
        return new FalseMatcher();
    }

    public ThreadSnapshotFilter trueFilter() {
        return new TrueFilter();
    }

    public ThreadSnapshotFilter threadStateMatter(String matcher) {
        return new ThreadStateMatcher(matcher);
    }

    public StackFrameMatcher patternFrameMatcher(String ... patterns) {
        return this.patternFrameMatcher(Arrays.asList(patterns));
    }

    public StackFrameMatcher patternFrameMatcher(Collection<String> patterns) {
        if (patterns.isEmpty()) {
            throw new IllegalArgumentException("Pattern list is empty");
        }
        return new PatternFrameMatcher(patterns);
    }

    public PositionalStackMatcher lastFrame(StackFrameMatcher matcher) {
        return new LastFrameMatcher(matcher);
    }

    public PositionalStackMatcher firstFrame(StackFrameMatcher matcher) {
        return new FirstFrameMatcher(matcher);
    }

    protected static String wildCardTranslate(String pattern) {
        String separator = ".";
        StringBuffer sb = new StringBuffer();
        String es = BasicFilterFactory.escape(separator);
        Matcher ss = Pattern.compile("^([*][*][" + es + "]).*").matcher(pattern);
        if (ss.matches()) {
            pattern = pattern.substring(ss.group(1).length());
            sb.append("(.*[" + es + "])?");
        }
        Matcher st = Pattern.compile(".*([" + es + "][*][*])$").matcher(pattern);
        boolean useSt = false;
        if (st.matches()) {
            pattern = pattern.substring(0, st.start(1));
            useSt = true;
        }
        for (int i = 0; i != pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '?') {
                sb.append("[^" + es + "]");
                continue;
            }
            if (c == '*') {
                if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '*') {
                    ++i;
                    sb.append(".*");
                    continue;
                }
                sb.append("[^" + es + "]*");
                continue;
            }
            if (c == '$') {
                sb.append("\\$");
                continue;
            }
            if (Character.isJavaIdentifierPart(c) || Character.isWhitespace(c)) {
                sb.append(c);
                continue;
            }
            sb.append('\\').append(c);
        }
        if (useSt) {
            sb.append("([" + es + "].*)?");
        }
        return sb.toString();
    }

    private static String escape(String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i != separator.length(); ++i) {
            char c = separator.charAt(i);
            if ("\\[]&-".indexOf(c) >= 0) {
                sb.append('\\').append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected static class ThreadSnapProxy
    implements ThreadSnapshot {
        ThreadSnapshot snap;
        StackFrameList stack;

        public ThreadSnapProxy(ThreadSnapshot snap, StackFrameList stack) {
            this.snap = snap;
            this.stack = stack;
        }

        @Override
        public long threadId() {
            return this.snap.threadId();
        }

        @Override
        public String threadName() {
            return this.snap.threadName();
        }

        @Override
        public long timestamp() {
            return this.snap.timestamp();
        }

        @Override
        public StackFrameList stackTrace() {
            return this.stack != null ? this.stack : this.snap.stackTrace();
        }

        @Override
        public Thread.State threadState() {
            return this.snap.threadState();
        }

        @Override
        public CounterCollection counters() {
            return this.snap.counters();
        }
    }

    protected static class ThreadStateMatcher
    implements ThreadSnapshotFilter {
        private final EnumSet<Thread.State> states;
        private final boolean matchNull;

        ThreadStateMatcher(String pattern) {
            Pattern regEx = Pattern.compile(BasicFilterFactory.wildCardTranslate(pattern));
            HashSet<Thread.State> st = new HashSet<Thread.State>();
            for (Thread.State s2 : Thread.State.values()) {
                if (!regEx.matcher(s2.toString()).matches()) continue;
                st.add(s2);
            }
            this.states = st.isEmpty() ? EnumSet.noneOf(Thread.State.class) : EnumSet.copyOf(st);
            this.matchNull = regEx.matcher(String.valueOf((Object)null)).matches();
        }

        @Override
        public boolean evaluate(ThreadSnapshot snapshot) {
            Thread.State state = snapshot.threadState();
            if (state == null) {
                return this.matchNull;
            }
            return this.states.contains((Object)state);
        }
    }

    protected static class PatternFrameMatcher
    implements StackFrameMatcher {
        private final Pattern regEx;

        PatternFrameMatcher(Collection<String> patterns) {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            for (String pattern : patterns) {
                sb.append(BasicFilterFactory.wildCardTranslate(pattern));
                sb.append('|');
            }
            sb.setCharAt(sb.length() - 1, ')');
            this.regEx = Pattern.compile(sb.toString());
        }

        @Override
        public boolean evaluate(StackFrame frame) {
            return this.regEx.matcher(frame).lookingAt();
        }
    }

    protected static class ConjunctionMatcher
    implements StackFrameMatcher {
        private final StackFrameMatcher[] matchers;

        public ConjunctionMatcher(StackFrameMatcher[] matcher) {
            this.matchers = matcher;
        }

        @Override
        public boolean evaluate(StackFrame frame) {
            for (StackFrameMatcher f : this.matchers) {
                if (!f.evaluate(frame)) continue;
                return true;
            }
            return false;
        }
    }

    protected static class ConjunctionFilter
    implements ThreadSnapshotFilter {
        private final ThreadSnapshotFilter[] filters;

        public ConjunctionFilter(ThreadSnapshotFilter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean evaluate(ThreadSnapshot snapshot) {
            for (ThreadSnapshotFilter f : this.filters) {
                if (!f.evaluate(snapshot)) continue;
                return true;
            }
            return false;
        }
    }

    protected static class DisjunctionFilter
    implements ThreadSnapshotFilter {
        private final ThreadSnapshotFilter[] filters;

        public DisjunctionFilter(ThreadSnapshotFilter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean evaluate(ThreadSnapshot snapshot) {
            for (ThreadSnapshotFilter f : this.filters) {
                if (f.evaluate(snapshot)) continue;
                return false;
            }
            return true;
        }
    }

    protected static class FollowedPredicate
    implements ThreadSnapshotFilter,
    PositionalStackMatcher {
        private final PositionalStackMatcher matcher;
        private final ThreadSnapshotFilter tailFilter;

        public FollowedPredicate(PositionalStackMatcher matcher, ThreadSnapshotFilter tailFilter) {
            this.matcher = matcher;
            this.tailFilter = tailFilter;
        }

        @Override
        public boolean evaluate(ThreadSnapshot snapshot) {
            int m4;
            int n = -1;
            while ((m4 = this.matcher.matchNext(snapshot, n + 1)) >= 0) {
                n = m4;
            }
            if (n >= 0) {
                StackFrameList remained = snapshot.stackTrace();
                remained = remained.fragment(0, n);
                return this.tailFilter.evaluate(new ThreadSnapProxy(snapshot, remained));
            }
            return false;
        }

        @Override
        public int matchNext(ThreadSnapshot snap, int matchFrom) {
            int n = matchFrom - 1;
            while (true) {
                int m4;
                if ((m4 = this.matcher.matchNext(snap, n + 1)) < 0) {
                    if (n >= matchFrom) {
                        StackFrameList remained = snap.stackTrace();
                        if (this.tailFilter.evaluate(new ThreadSnapProxy(snap, remained = remained.fragment(0, n)))) {
                            return n;
                        }
                    }
                    return -1;
                }
                n = m4;
            }
        }
    }

    protected class FirstFrameMatcher
    implements PositionalStackMatcher {
        private final StackFrameMatcher matcher;

        public FirstFrameMatcher(StackFrameMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public int matchNext(ThreadSnapshot snap, int matchFrom) {
            StackFrameList trace = snap.stackTrace();
            if (matchFrom > 0) {
                return -1;
            }
            for (int i = trace.depth(); i > 0; --i) {
                if (!this.matcher.evaluate(trace.frameAt(i - 1))) continue;
                return i;
            }
            return -1;
        }
    }

    protected class LastFrameMatcher
    implements PositionalStackMatcher {
        private final StackFrameMatcher matcher;

        public LastFrameMatcher(StackFrameMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public int matchNext(ThreadSnapshot snap, int matchFrom) {
            StackFrameList trace = snap.stackTrace();
            if (matchFrom > 0) {
                return -1;
            }
            for (int i = matchFrom; i < trace.depth(); ++i) {
                if (!this.matcher.evaluate(trace.frameAt(i))) continue;
                return i;
            }
            return -1;
        }
    }

    protected final class FalseFilter
    implements ThreadSnapshotFilter {
        protected FalseFilter() {
        }

        @Override
        public boolean evaluate(ThreadSnapshot snapshot) {
            return false;
        }
    }

    protected final class FalseMatcher
    implements StackFrameMatcher {
        protected FalseMatcher() {
        }

        @Override
        public boolean evaluate(StackFrame frame) {
            return false;
        }
    }

    protected final class TrueFilter
    implements ThreadSnapshotFilter {
        protected TrueFilter() {
        }

        @Override
        public boolean evaluate(ThreadSnapshot snapshot) {
            return true;
        }
    }
}

