/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0;

import org.openjdk.jmc.common.collection.FastAccessNumberMap;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.DecimalPrefix;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.LabeledIdentifier;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.LoaderContext;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.ArrayReader;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.BooleanReader;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.ChunkMetadata;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.CompositeReader;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.ConstantMap;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.ConstantReader;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.IValueReader;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.QuantityReader;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.StringReader;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.UTFStringParser;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.factories.GlobalObjectPool;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.factories.IPoolFactory;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ContentTypeDescriptor;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.DataType;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.EventTypeDescriptor;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ProducerDescriptor;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ValueDescriptor;

class ReaderFactory {
    private final FastAccessNumberMap<ConstantMap> constants = new FastAccessNumberMap(100, 5);
    private final ChunkMetadata metadata;
    private final FastAccessNumberMap<LabeledIdentifier> types = new FastAccessNumberMap();

    ReaderFactory(ChunkMetadata metadata, byte[] chunkData, LoaderContext context) throws InvalidJfrFileException {
        this.metadata = metadata;
        for (ProducerDescriptor pd : metadata.getProducers()) {
            for (ContentTypeDescriptor ct : pd.getContentTypes()) {
                IValueReader reader = this.createReader(ct.getDataStructure());
                IPoolFactory<?> factory = GlobalObjectPool.getFactory(ct, context);
                this.getConstantMap(ct.getContentTypeId()).init(reader, ct.getDataType(), factory);
            }
            for (EventTypeDescriptor etd : pd.getEventTypeDescriptors()) {
                this.types.put(etd.getIdentifier(), new LabeledIdentifier(pd.getURIString() + etd.getPath(), etd.getIdentifier(), etd.getLabel(), etd.getDescription()));
            }
        }
        int prevCpOffset = metadata.getPreviousCheckPoint();
        while (prevCpOffset != 0) {
            Offset offset = new Offset(chunkData, prevCpOffset);
            offset.increase(4);
            long timestamp = this.readTicksTimestamp(chunkData, offset);
            prevCpOffset = (int)NumberReaders.readLong(chunkData, offset);
            while (offset.get() < offset.getEnd()) {
                int contentTypeId = NumberReaders.readInt(chunkData, offset);
                int entries = NumberReaders.readInt(chunkData, offset);
                ConstantMap entry = this.getConstantMap(contentTypeId);
                for (int n = 0; n < entries; ++n) {
                    entry.readValue(chunkData, offset, timestamp);
                }
            }
        }
        for (ConstantMap cp : this.constants) {
            cp.setLoadDone();
        }
        ConstantMap threadPool = this.constants.get(8L);
        if (threadPool != null) {
            threadPool.touchAll();
        }
    }

    long readTicksTimestamp(byte[] data, Offset offset) throws InvalidJfrFileException {
        return this.metadata.asNanoTimestamp(NumberReaders.readLong(data, offset));
    }

    private ConstantMap getConstantMap(int contentTypeId) {
        ConstantMap constantMap = this.constants.get(contentTypeId);
        if (constantMap == null) {
            constantMap = new ConstantMap();
            this.constants.put(contentTypeId, constantMap);
        }
        return constantMap;
    }

    private IValueReader createReader(ValueDescriptor[] vds) throws InvalidJfrFileException {
        if (vds.length == 1) {
            return this.createReader(vds[0], null);
        }
        IValueReader[] readers = new IValueReader[vds.length];
        for (int i = 0; i < readers.length; ++i) {
            readers[i] = this.createReader(vds[i], null);
        }
        return new CompositeReader(readers);
    }

    IValueReader createReader(ValueDescriptor vd, String valueType) throws InvalidJfrFileException {
        if (vd.getDataType().isPrimitive()) {
            return this.createPrimitiveReader(vd.getDataType(), vd.getContentType(), valueType);
        }
        if (vd.getDataType() == DataType.ARRAY) {
            return new ArrayReader(this.createPrimitiveReader(vd.getInnerDataType(), vd.getContentType(), valueType));
        }
        if (vd.getDataType() == DataType.STRUCTARRAY) {
            return new ArrayReader(this.createReader(vd.getChildren()));
        }
        if (vd.getDataType() == DataType.STRUCT) {
            return this.createReader(vd.getChildren());
        }
        throw new InvalidJfrFileException();
    }

    private IValueReader createPrimitiveReader(DataType dataType, int contentType, String valueType) throws InvalidJfrFileException {
        if (dataType.isNumeric()) {
            switch (contentType) {
                case 2: {
                    return new QuantityReader(dataType, UnitLookup.EPOCH_MS);
                }
                case 3: {
                    return new QuantityReader(dataType, UnitLookup.MILLISECOND);
                }
                case 4: {
                    return new QuantityReader(dataType, UnitLookup.TIMESPAN.getUnit(DecimalPrefix.NANO));
                }
                case 5: {
                    return new QuantityReader(dataType, this.metadata.getTicksUnit());
                }
                case 11: {
                    return new QuantityReader(dataType, UnitLookup.PERCENT_UNITY);
                }
                case 1: {
                    return new QuantityReader(dataType, UnitLookup.BYTE);
                }
                case 6: {
                    return new QuantityReader(dataType, UnitLookup.ADDRESS_UNITY);
                }
                case 0: {
                    if ("org.openjdk.jmc.flightrecorder.value_interpretation.type_identifier".equals(valueType)) {
                        return new TypeIdentifierReader(dataType);
                    }
                    IUnit unit = UnitLookup.getUnitOrNull(valueType);
                    if (unit != null) {
                        return new QuantityReader(dataType, unit);
                    }
                    return new QuantityReader(dataType, UnitLookup.NUMBER_UNITY);
                }
            }
            return this.createConstantReader(dataType, contentType);
        }
        if (dataType == DataType.BOOLEAN) {
            return BooleanReader.INSTANCE;
        }
        if (dataType == DataType.STRING) {
            return StringReader.INSTANCE;
        }
        if (dataType == DataType.UTF8) {
            return UTFStringParser.INSTANCE;
        }
        throw new InvalidJfrFileException();
    }

    IValueReader createConstantReader(DataType dataType, int contentType) throws InvalidJfrFileException {
        return new ConstantReader(this.getConstantMap(contentType), dataType);
    }

    private class TypeIdentifierReader
    implements IValueReader {
        private final DataType dataType;

        TypeIdentifierReader(DataType dataType) {
            this.dataType = dataType;
        }

        @Override
        public Object readValue(byte[] bytes, Offset offset, long timestamp) throws InvalidJfrFileException {
            long typeId = NumberReaders.readKey(bytes, offset, this.dataType);
            return ReaderFactory.this.types.get(typeId);
        }

        @Override
        public ContentType<?> getValueType() {
            return UnitLookup.LABELED_IDENTIFIER;
        }
    }
}

