/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.types;

import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.LocalDate;
import org.apache.cassandra.cql3.functions.types.SettableByIndexData;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.spark.data.NativeType;
import org.apache.cassandra.spark.utils.RandomUtils;

public class Date
extends NativeType {
    public static final Date INSTANCE = new Date();

    public String name() {
        return "date";
    }

    @Override
    public AbstractType<?> dataType() {
        return SimpleDateType.instance;
    }

    @Override
    public Object randomValue(int minCollectionSize) {
        return RandomUtils.randomPositiveInt((int)30000);
    }

    @Override
    protected void setInnerValueInternal(SettableByIndexData<?> udtValue, int position, Object value) {
        udtValue.setDate(position, (LocalDate)value);
    }

    @Override
    public DataType driverDataType(boolean isFrozen) {
        return DataType.date();
    }

    @Override
    public Object convertForCqlWriter(Object value, CassandraVersion version, boolean isCollectionElement) {
        if (version.versionNumber() >= CassandraVersion.FOURZERO.versionNumber()) {
            return LocalDate.fromDaysSinceEpoch((int)((Integer)value));
        }
        return value;
    }
}

