/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.token;

import com.google.common.collect.Range;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import o.a.c.sidecar.client.shaded.common.response.TokenRangeReplicasResponse;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.TokenRangeMappingUtils;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.common.model.NodeState;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;

class TokenRangeMappingTest {
    TokenRangeMappingTest() {
    }

    @Test
    void testCreateTokenRangeMapping() {
        TokenRangeMapping<RingInstance> topology = this.createTestMapping(10);
        Assertions.assertThat((Comparable)topology.partitioner()).isEqualTo((Object)Partitioner.Murmur3Partitioner);
    }

    @Test
    void testTokenRangeMappingEqualsAndHashcode() {
        TokenRangeMapping<RingInstance> topology1 = this.createTestMapping(10);
        TokenRangeMapping<RingInstance> topology2 = this.createTestMapping(10);
        TokenRangeMapping<RingInstance> topology3 = this.createTestMapping(5);
        Assertions.assertThat(topology1).isEqualTo(topology2);
        Assertions.assertThat((int)topology1.hashCode()).isEqualTo(topology2.hashCode());
        Assertions.assertThat(topology1).isNotEqualTo(topology3);
        Assertions.assertThat((int)topology1.hashCode()).isNotEqualTo(topology3.hashCode());
    }

    @Test
    void testCreateTokenRangeMappingFailDueToIllegalTokenRangeReplicasResponse() {
        TokenRangeReplicasResponse invalidResponse = TokenRangeMappingUtils.mockSimpleTokenRangeReplicasResponse(10, 3);
        String invalidInstance = "127.0.3.1:9042";
        invalidResponse.writeReplicas().forEach(replicaInfo -> replicaInfo.replicasByDatacenter().put("dc3", Collections.singletonList(invalidInstance)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TokenRangeMapping.create(() -> invalidResponse, () -> Partitioner.Murmur3Partitioner, RingInstance::new)).isExactlyInstanceOf(RuntimeException.class)).hasMessage("No metadata found for instance: " + invalidInstance);
    }

    @Test
    void testCreateTokenRangeMappingWithPending() {
        TokenRangeReplicasResponse response = TokenRangeMappingUtils.mockSimpleTokenRangeReplicasResponse(10, 3);
        int i = 0;
        int pendingCount = 0;
        for (NodeState state : NodeState.values()) {
            String key = "localhost" + i + ":9042";
            ++i;
            TokenRangeReplicasResponse.ReplicaMetadata metadata = (TokenRangeReplicasResponse.ReplicaMetadata)response.replicaMetadata().get(key);
            TokenRangeReplicasResponse.ReplicaMetadata updatedMetadata = new TokenRangeReplicasResponse.ReplicaMetadata(state.name(), metadata.status(), metadata.fqdn(), metadata.address(), metadata.port(), metadata.datacenter());
            response.replicaMetadata().put(key, updatedMetadata);
            if (!state.isPending) continue;
            ++pendingCount;
        }
        TokenRangeMapping topology = TokenRangeMapping.create(() -> response, () -> Partitioner.Murmur3Partitioner, RingInstance::new);
        Assertions.assertThat((Collection)topology.pendingInstances()).hasSize(pendingCount);
    }

    @Test
    void testConsolidateListOfTokenRangeMappingFails() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TokenRangeMapping.consolidate(Collections.emptyList())).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot consolidate TokenRangeMapping from none");
        TokenRangeMapping<RingInstance> topologyWithMurmur3 = this.createTestMapping(5, Partitioner.Murmur3Partitioner);
        TokenRangeMapping<RingInstance> topologyWithRandom = this.createTestMapping(5, Partitioner.RandomPartitioner);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TokenRangeMapping.consolidate(Arrays.asList(topologyWithMurmur3, topologyWithRandom))).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Multiple Partitioners found: ").hasMessageContaining(Partitioner.Murmur3Partitioner.toString()).hasMessageContaining(Partitioner.RandomPartitioner.toString());
    }

    @Test
    void testConsolidateSingleTokenRangeMapping() {
        TokenRangeMapping<RingInstance> topology = this.createTestMapping(5);
        TokenRangeMapping consolidated = TokenRangeMapping.consolidate(Collections.singletonList(topology));
        Assertions.assertThat((Object)consolidated).isSameAs(topology);
    }

    @Test
    void testConsolidateFromTokenRangeMappingsWithSameRingLayout() {
        TokenRangeMapping<RingInstance> topology1 = TokenRangeMappingTest.createTestMapping(0L, 5, Partitioner.Murmur3Partitioner, "cluster1");
        TokenRangeMapping<RingInstance> topology2 = TokenRangeMappingTest.createTestMapping(0L, 5, Partitioner.Murmur3Partitioner, "cluster2");
        TokenRangeMapping consolidated = TokenRangeMapping.consolidate(Arrays.asList(topology1, topology2));
        ((AbstractCollectionAssert)((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)consolidated.allInstances()).describedAs("Consolidated allInstances contains instances from both topologies", new Object[0])).hasSize(10)).containsAll((Iterable)topology1.allInstances())).containsAll((Iterable)topology2.allInstances());
        Assertions.assertThat((Collection)consolidated.pendingInstances()).isEmpty();
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)consolidated.getTokenRanges().asMap()).describedAs("Consolidated TokenRanges contains instances and ranges from both topologies", new Object[0])).hasSize(10)).containsAllEntriesOf(topology1.getTokenRanges().asMap())).containsAllEntriesOf(topology2.getTokenRanges().asMap());
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)consolidated.getRangeMap().asMapOfRanges()).describedAs("Consolidated RangeMap has the same key set (ranges) as both topologies because the range layouts are the same", new Object[0])).hasSize(7)).containsOnlyKeys(topology1.getRangeMap().asMapOfRanges().keySet())).containsOnlyKeys(topology2.getRangeMap().asMapOfRanges().keySet());
        consolidated.getRangeMap().asMapOfRanges().forEach((range, instances) -> {
            if (instances.isEmpty()) {
                return;
            }
            ((ListAssert)Assertions.assertThat((List)instances).containsAll((Iterable)topology1.getRangeMap().asMapOfRanges().get(range))).containsAll((Iterable)topology2.getRangeMap().asMapOfRanges().get(range));
        });
    }

    @Test
    void testConsolidateFromTokenRangeMappingsWithDistinctRingLayout() {
        TokenRangeMapping<RingInstance> topology1 = TokenRangeMappingTest.createTestMapping(0L, 5, Partitioner.Murmur3Partitioner, "cluster1");
        TokenRangeMapping<RingInstance> topology2 = TokenRangeMappingTest.createTestMapping(1L, 5, Partitioner.Murmur3Partitioner, "cluster2");
        TokenRangeMapping consolidated = TokenRangeMapping.consolidate(Arrays.asList(topology1, topology2));
        ((AbstractCollectionAssert)((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)consolidated.allInstances()).describedAs("Consolidated allInstances contains instances from both topologies", new Object[0])).hasSize(10)).containsAll((Iterable)topology1.allInstances())).containsAll((Iterable)topology2.allInstances());
        Assertions.assertThat((Collection)consolidated.pendingInstances()).isEmpty();
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)consolidated.getTokenRanges().asMap()).describedAs("Consolidated TokenRanges contains instances and ranges from both topologies", new Object[0])).hasSize(10)).containsAllEntriesOf(topology1.getTokenRanges().asMap())).containsAllEntriesOf(topology2.getTokenRanges().asMap());
        List<Range> expectedConsolidatedRanges = Arrays.asList(TestUtils.range(Long.MIN_VALUE, 0L), TestUtils.range(0L, 1L), TestUtils.range(1L, 100L), TestUtils.range(100L, 101L), TestUtils.range(101L, 200L), TestUtils.range(200L, 201L), TestUtils.range(201L, 300L), TestUtils.range(300L, 301L), TestUtils.range(301L, 400L), TestUtils.range(400L, 401L), TestUtils.range(401L, 500L), TestUtils.range(500L, 501L), TestUtils.range(501L, Long.MAX_VALUE));
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)consolidated.getRangeMap().asMapOfRanges()).describedAs("Consolidated RangeMap has different key set (ranges) from both topologies because the range layouts are different", new Object[0])).hasSize(topology1.getRangeMap().asMapOfRanges().size() + topology2.getRangeMap().asMapOfRanges().size() - 1)).containsOnlyKeys(expectedConsolidatedRanges);
        expectedConsolidatedRanges.forEach(range -> {
            List instances = (List)consolidated.getRangeMap().asMapOfRanges().get(range);
            if (instances.isEmpty()) {
                return;
            }
            List<RingInstance> instancesOfCluster1 = this.getSoleValue(topology1.getRangeMap().subRangeMap(range).asMapOfRanges());
            List<RingInstance> instancesOfCluster2 = this.getSoleValue(topology2.getRangeMap().subRangeMap(range).asMapOfRanges());
            ((ListAssert)((ListAssert)Assertions.assertThat((List)instances).hasSize(instancesOfCluster1.size() + instancesOfCluster2.size())).containsAll(instancesOfCluster1)).containsAll(instancesOfCluster2);
        });
    }

    private TokenRangeMapping<RingInstance> createTestMapping(int instanceCount) {
        return this.createTestMapping(instanceCount, Partitioner.Murmur3Partitioner);
    }

    private TokenRangeMapping<RingInstance> createTestMapping(int instanceCount, Partitioner partitioner) {
        return TokenRangeMappingTest.createTestMapping(0L, instanceCount, partitioner, null);
    }

    public static TokenRangeMapping<RingInstance> createTestMapping(long startToken, int instanceCount, Partitioner partitioner, String clusterId) {
        return TokenRangeMapping.create(() -> TokenRangeMappingUtils.mockSimpleTokenRangeReplicasResponse(startToken, instanceCount, 3), () -> partitioner, metadata -> new RingInstance(metadata, clusterId));
    }

    private List<RingInstance> getSoleValue(Map<?, List<RingInstance>> map) {
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        Assertions.assertThat(map).hasSize(1);
        return map.values().iterator().next();
    }
}

