/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import org.jetbrains.annotations.NotNull;

public final class Preconditions {
    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private Preconditions() {
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean value, @NotNull String error, Object ... exceptionArguments) {
        if (!value) {
            throw new IllegalArgumentException(Preconditions.isEmpty(exceptionArguments) ? error : String.format(error, exceptionArguments));
        }
    }

    public static void checkState(boolean value, @NotNull String error, Object ... exceptionArguments) {
        if (!value) {
            throw new IllegalStateException(Preconditions.isEmpty(exceptionArguments) ? error : String.format(error, exceptionArguments));
        }
    }

    public static <T> T checkNotNull(T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return value;
    }

    public static <T> T checkNotNull(T value, @NotNull String error, Object ... exceptionArguments) {
        if (value == null) {
            throw new NullPointerException(Preconditions.isEmpty(exceptionArguments) ? error : String.format(error, exceptionArguments));
        }
        return value;
    }

    private static boolean isEmpty(Object ... exceptionArguments) {
        return exceptionArguments == null || exceptionArguments.length == 0;
    }
}

