/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.coordination;

import com.datastax.driver.core.Host;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.client.SidecarInstance;
import org.apache.cassandra.sidecar.cluster.InstancesMetadata;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.common.response.NodeSettings;
import org.apache.cassandra.sidecar.common.server.cluster.locator.Partitioner;
import org.apache.cassandra.sidecar.common.server.cluster.locator.Partitioners;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolver;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TokenRingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenRingProvider.class);
    protected final InstancesMetadata instancesMetadata;
    protected final InstanceMetadataFetcher fetcher;
    protected final DnsResolver dnsResolver;

    public TokenRingProvider(InstancesMetadata instancesMetadata, InstanceMetadataFetcher fetcher, DnsResolver dnsResolver) {
        this.instancesMetadata = instancesMetadata;
        this.fetcher = fetcher;
        this.dnsResolver = dnsResolver;
    }

    protected abstract Map<String, List<Range<BigInteger>>> getAllTokenRanges(Partitioner var1, @Nullable String var2);

    public abstract Map<String, List<Range<BigInteger>>> getPrimaryRanges(SidecarInstance var1, String var2);

    public Map<String, List<Range<BigInteger>>> getPrimaryTokenRanges(@Nullable String dc) {
        Set<String> instanceIpsManagedBySidecar = this.instanceIpsManagedBySidecar();
        if (instanceIpsManagedBySidecar.isEmpty()) {
            return Collections.emptyMap();
        }
        Partitioner partitioner = this.partitioner();
        return this.getAllTokenRanges(partitioner, dc).entrySet().stream().filter(entry -> instanceIpsManagedBySidecar.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public abstract Set<String> dcs();

    @Nullable
    public String localDc() {
        NodeSettings nodeSettings = this.fetcher.callOnFirstAvailableInstance(instance -> instance.delegate().nodeSettings());
        return nodeSettings.datacenter();
    }

    public Partitioner partitioner() {
        String[] tokens = this.fetcher.callOnFirstAvailableInstance(instance -> instance.delegate().nodeSettings().partitioner().split("\\."));
        return Partitioners.from((String)tokens[tokens.length - 1]);
    }

    protected String getIpFromHost(Host host) {
        return TokenRingProvider.getIpFromHost(this.dnsResolver, host);
    }

    protected static String getIpFromHost(DnsResolver dnsResolver, Host host) {
        InetAddress address = host.getAddress();
        String hostAddress = address.getHostAddress();
        if (hostAddress != null) {
            return hostAddress;
        }
        return TokenRingProvider.getIp(dnsResolver, address.getHostName());
    }

    protected String getIp(String nodeName) {
        return TokenRingProvider.getIp(this.dnsResolver, nodeName);
    }

    protected static String getIp(DnsResolver dnsResolver, String nodeName) {
        try {
            return dnsResolver.resolve(nodeName);
        }
        catch (UnknownHostException e) {
            LOGGER.error("Could not resolve hostname for host nodeName={}", (Object)nodeName);
            throw new RuntimeException(e);
        }
    }

    private Set<String> instanceIpsManagedBySidecar() {
        return this.instancesMetadata.instances().stream().map(InstanceMetadata::host).map(this::getIp).collect(Collectors.toSet());
    }
}

