/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.path;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.exp.path.CayennePathSegment;

class MultiSegmentCayennePath
implements CayennePath,
Serializable {
    private final List<CayennePathSegment> segments;
    private final int marker;
    private transient String fullPath;

    MultiSegmentCayennePath(List<CayennePathSegment> segments, int marker) {
        this.segments = segments;
        this.marker = marker;
    }

    @Override
    public List<CayennePathSegment> segments() {
        return this.segments;
    }

    @Override
    public int marker() {
        return this.marker;
    }

    @Override
    public String toString() {
        if (this.fullPath != null) {
            return this.fullPath;
        }
        this.fullPath = String.join((CharSequence)".", this.segments);
        return this.fullPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CayennePath)) {
            return false;
        }
        CayennePath that = (CayennePath)o;
        return that.marker() == this.marker && this.segments.equals(that.segments());
    }

    public int hashCode() {
        return 31 * this.marker + this.segments.hashCode();
    }

    @Override
    public Iterator<CayennePathSegment> iterator() {
        return new PathIterator();
    }

    class PathIterator
    implements Iterator<CayennePathSegment> {
        int position;

        PathIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.position < MultiSegmentCayennePath.this.segments.size();
        }

        @Override
        public CayennePathSegment next() {
            int next = this.position;
            if (next >= MultiSegmentCayennePath.this.segments.size()) {
                throw new NoSuchElementException();
            }
            CayennePathSegment segment = MultiSegmentCayennePath.this.segments.get(next);
            this.position = next + 1;
            return segment;
        }
    }
}

