/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen.templateeditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.FindAndReplaceView;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.FindController;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.FindView;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.TemplateEditorController;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;

public class FindAndReplaceController
extends FindController
implements ActionListener {
    private FindAndReplaceView view;
    private JButton nextButton;
    private JButton replaceButton;
    private JButton replaceAllButton;
    private static final String REPLACE = "replace";
    private static final String REPLACE_ALL = "replaceAll";

    public FindAndReplaceController(TemplateEditorController parent) {
        super(parent);
        this.initComponents();
        this.initListeners();
    }

    @Override
    protected void initComponents() {
        this.view = new FindAndReplaceView();
        this.nextButton = this.view.getNextButton();
        this.replaceButton = this.view.getReplaceButton();
        this.replaceAllButton = this.view.getReplaceAllButton();
    }

    @Override
    protected void initListeners() {
        this.nextButton.setActionCommand("FindNext");
        this.nextButton.addActionListener(this);
        this.replaceButton.setActionCommand(REPLACE);
        this.replaceButton.addActionListener(this);
        this.replaceAllButton.setActionCommand(REPLACE_ALL);
        this.replaceAllButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        SearchContext context = this.getSearchContext(true, this.view);
        if (context == null) {
            return;
        }
        switch (command) {
            case "FindNext": {
                boolean found = SearchEngine.find(this.parentView.getEditingTemplatePane(), context).wasFound();
                if (found) break;
                JOptionPane.showMessageDialog(this.view, "Text not found");
                break;
            }
            case "replace": {
                boolean found = SearchEngine.replace(this.parentView.getEditingTemplatePane(), context).wasFound();
                if (found) break;
                JOptionPane.showMessageDialog(this.view, "Text not found");
                break;
            }
            case "replaceAll": {
                boolean found = SearchEngine.replaceAll(this.parentView.getEditingTemplatePane(), context).wasFound();
                if (found) break;
                JOptionPane.showMessageDialog(this.view, "Text not found");
                break;
            }
        }
    }

    @Override
    protected SearchContext getSearchContext(boolean forward, FindView view) {
        SearchContext context = super.getSearchContext(forward, view);
        context.setReplaceWith(this.view.getReplaceWithField().getText());
        return context;
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public void startupAction() {
        this.view.setModal(true);
        this.view.pack();
        this.view.setResizable(false);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
    }
}

