/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.dialog.db.load.TransferableNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTree;

public class PrintTablesBiFunction
implements BiFunction<FilterContainer, DbImportTreeNode, Void> {
    private DbImportTree dbImportTree;

    public PrintTablesBiFunction(DbImportTree dbImportTree) {
        this.dbImportTree = dbImportTree;
    }

    @Override
    public Void apply(FilterContainer filterContainer, DbImportTreeNode root) {
        boolean isTransferable = this.dbImportTree.isTransferable();
        if (root.getChildCount() != 0) {
            root.removeAllChildren();
        }
        List<IncludeTable> includeTables = filterContainer.getIncludeTables();
        for (IncludeTable includeTable : includeTables) {
            DbImportTreeNode node;
            DbImportTreeNode dbImportTreeNode = node = !isTransferable ? new DbImportTreeNode(includeTable) : new TransferableNode(includeTable);
            if (isTransferable && includeTable.getIncludeColumns().isEmpty() && includeTable.getExcludeColumns().isEmpty()) {
                this.dbImportTree.printParams(Collections.singletonList(new IncludeColumn("Loading...")), node);
            }
            root.add(node);
            this.dbImportTree.packColumns(includeTable, node);
        }
        this.dbImportTree.reloadModelKeepingExpanded(root);
        return null;
    }
}

