/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing.components.tree;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.apache.cayenne.swing.components.tree.CheckBoxNodeData;

public class CheckBoxTreeCellRenderer
extends JCheckBox
implements TreeCellRenderer {
    private static final String TREE_SELECTION_BACKGROUND = "Tree.selectionBackground";
    private static final String TREE_BACKGROUND = "Tree.background";
    protected final TreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();

    public CheckBoxTreeCellRenderer() {
        this.setOpaque(false);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (!(value instanceof DefaultMutableTreeNode)) {
            return this.defaultRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        if (!(userObject instanceof CheckBoxNodeData)) {
            return this.defaultRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        CheckBoxNodeData data = (CheckBoxNodeData)node.getUserObject();
        this.setBackground(UIManager.getColor(selected ? TREE_SELECTION_BACKGROUND : TREE_BACKGROUND));
        this.setSelected(data.getState() != CheckBoxNodeData.State.INDETERMINATE && data.isSelected());
        return this;
    }
}

