/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.runtime;

import org.apache.cayenne.DataChannelQueryFilter;
import org.apache.cayenne.DataChannelSyncFilter;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ValueObjectType;
import org.apache.cayenne.configuration.runtime.DbAdapterDetector;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ListBuilder;
import org.apache.cayenne.di.MapBuilder;
import org.apache.cayenne.tx.TransactionFilter;

public class CoreModuleExtender {
    private final Binder binder;
    private MapBuilder<String> properties;
    private ListBuilder<String> projectLocations;
    private ListBuilder<DbAdapterDetector> adapterDetectors;
    private MapBuilder<PkGenerator> pkGenerators;
    private ListBuilder<DataChannelQueryFilter> queryFilters;
    private ListBuilder<DataChannelSyncFilter> syncFilters;
    private ListBuilder<Object> listeners;
    private ListBuilder<ExtendedType> defaultExtendedTypes;
    private ListBuilder<ExtendedType> userExtendedTypes;
    private ListBuilder<ExtendedTypeFactory> extendedTypeFactories;
    private ListBuilder<ValueObjectType> valueObjectTypes;

    protected CoreModuleExtender(Binder binder) {
        this.binder = binder;
    }

    protected CoreModuleExtender initAllExtensions() {
        this.contributeProperties();
        this.contributeProjectLocations();
        this.contributeAdapterDetectors();
        this.contributePkGenerators();
        this.contributeQueryFilters();
        this.contributeSyncFilters();
        this.contributeListeners();
        this.contributeDefaultExtendedTypes();
        this.contributeUserExtendedTypes();
        this.contributeExtendedTypeFactories();
        this.contributeValueObjectTypes();
        return this;
    }

    public CoreModuleExtender setProperty(String key, Object value) {
        this.contributeProperties().put(key, value != null ? value.toString() : null);
        return this;
    }

    public CoreModuleExtender syncContexts() {
        this.contributeProperties().put("cayenne.contexts_sync_strategy", "true");
        return this;
    }

    public CoreModuleExtender externalTransactions() {
        this.contributeProperties().put("cayenne.external_tx", "true");
        return this;
    }

    public CoreModuleExtender snapshotCacheSize(int size) {
        this.contributeProperties().put("cayenne.DataRowStore.snapshot.size", Integer.toString(size));
        return this;
    }

    public CoreModuleExtender addProjectLocation(String location) {
        this.contributeProjectLocations().add(location);
        return this;
    }

    public CoreModuleExtender addPkGenerator(Class<? extends DbAdapter> adapter, PkGenerator pkGenerator) {
        this.contributePkGenerators().put(adapter.getName(), pkGenerator);
        return this;
    }

    public CoreModuleExtender addPkGenerator(Class<? extends DbAdapter> adapter, Class<? extends PkGenerator> pkGeneratorType) {
        this.contributePkGenerators().put(adapter.getName(), (PkGenerator)((Object)pkGeneratorType));
        return this;
    }

    public CoreModuleExtender addQueryFilter(DataChannelQueryFilter queryFilter) {
        this.contributeQueryFilters().add(queryFilter);
        return this;
    }

    public CoreModuleExtender addQueryFilter(Class<? extends DataChannelQueryFilter> queryFilterType) {
        this.contributeQueryFilters().add((DataChannelQueryFilter)((Object)queryFilterType));
        return this;
    }

    public CoreModuleExtender addSyncFilter(DataChannelSyncFilter syncFilter) {
        this.contributeSyncFilters().add(syncFilter);
        return this;
    }

    public CoreModuleExtender addSyncFilter(Class<? extends DataChannelSyncFilter> syncFilterType) {
        this.contributeSyncFilters().add((DataChannelSyncFilter)((Object)syncFilterType));
        return this;
    }

    public CoreModuleExtender addSyncFilter(DataChannelSyncFilter syncFilter, boolean includeInTransaction) {
        if (includeInTransaction) {
            this.contributeSyncFilters().insertBefore(syncFilter, TransactionFilter.class);
        } else {
            this.contributeSyncFilters().addAfter(syncFilter, TransactionFilter.class);
        }
        return this;
    }

    public CoreModuleExtender addSyncFilter(Class<? extends DataChannelSyncFilter> syncFilterType, boolean includeInTransaction) {
        if (includeInTransaction) {
            this.contributeSyncFilters().insertBefore((DataChannelSyncFilter)((Object)syncFilterType), (Class<DataChannelSyncFilter>)TransactionFilter.class);
        } else {
            this.contributeSyncFilters().addAfter((DataChannelSyncFilter)((Object)syncFilterType), (Class<DataChannelSyncFilter>)TransactionFilter.class);
        }
        return this;
    }

    public CoreModuleExtender addListener(Object listener) {
        this.contributeListeners().add(listener);
        return this;
    }

    public CoreModuleExtender addListenerType(Class<?> listenerType) {
        this.contributeListeners().add(listenerType);
        return this;
    }

    public CoreModuleExtender addAdapterDetector(DbAdapterDetector adapterDetector) {
        this.contributeAdapterDetectors().add(adapterDetector);
        return this;
    }

    public CoreModuleExtender addAdapterDetector(Class<? extends DbAdapterDetector> adapterDetectorType) {
        this.contributeAdapterDetectors().add((DbAdapterDetector)((Object)adapterDetectorType));
        return this;
    }

    public CoreModuleExtender addDefaultExtendedType(ExtendedType<?> type) {
        this.contributeDefaultExtendedTypes().add(type);
        return this;
    }

    public CoreModuleExtender addDefaultExtendedType(Class<? extends ExtendedType<?>> type) {
        this.contributeDefaultExtendedTypes().add((ExtendedType)((Object)type));
        return this;
    }

    public CoreModuleExtender addUserExtendedType(ExtendedType<?> type) {
        this.contributeUserExtendedTypes().add(type);
        return this;
    }

    public CoreModuleExtender addUserExtendedType(Class<? extends ExtendedType<?>> type) {
        this.contributeUserExtendedTypes().add((ExtendedType)((Object)type));
        return this;
    }

    public CoreModuleExtender addExtendedTypeFactory(ExtendedTypeFactory factory) {
        this.contributeExtendedTypeFactories().add(factory);
        return this;
    }

    public CoreModuleExtender addExtendedTypeFactory(Class<? extends ExtendedTypeFactory> factoryType) {
        this.contributeExtendedTypeFactories().add((ExtendedTypeFactory)((Object)factoryType));
        return this;
    }

    public CoreModuleExtender addValueObjectType(ValueObjectType<?, ?> type) {
        this.contributeValueObjectTypes().add(type);
        return this;
    }

    public CoreModuleExtender addValueObjectType(Class<? extends ValueObjectType<?, ?>> type) {
        this.contributeValueObjectTypes().add((ValueObjectType)((Object)type));
        return this;
    }

    private ListBuilder<String> contributeProjectLocations() {
        if (this.projectLocations == null) {
            this.projectLocations = this.binder.bindList(String.class, "cayenne.project_locations");
        }
        return this.projectLocations;
    }

    private MapBuilder<String> contributeProperties() {
        if (this.properties == null) {
            this.properties = this.binder.bindMap(String.class, "cayenne.properties");
        }
        return this.properties;
    }

    private ListBuilder<DataChannelQueryFilter> contributeQueryFilters() {
        if (this.queryFilters == null) {
            this.queryFilters = this.binder.bindList(DataChannelQueryFilter.class);
        }
        return this.queryFilters;
    }

    private ListBuilder<DataChannelSyncFilter> contributeSyncFilters() {
        if (this.syncFilters == null) {
            this.syncFilters = this.binder.bindList(DataChannelSyncFilter.class);
        }
        return this.syncFilters;
    }

    private ListBuilder<Object> contributeListeners() {
        if (this.listeners == null) {
            this.listeners = this.binder.bindList(Object.class, "cayenne.domain_listeners");
        }
        return this.listeners;
    }

    private ListBuilder<DbAdapterDetector> contributeAdapterDetectors() {
        if (this.adapterDetectors == null) {
            this.adapterDetectors = this.binder.bindList(DbAdapterDetector.class, "cayenne.adapter_detectors");
        }
        return this.adapterDetectors;
    }

    private ListBuilder<ExtendedType> contributeDefaultExtendedTypes() {
        if (this.defaultExtendedTypes == null) {
            this.defaultExtendedTypes = this.binder.bindList(ExtendedType.class, "cayenne.default_types");
        }
        return this.defaultExtendedTypes;
    }

    private ListBuilder<ExtendedType> contributeUserExtendedTypes() {
        if (this.userExtendedTypes == null) {
            this.userExtendedTypes = this.binder.bindList(ExtendedType.class, "cayenne.user_types");
        }
        return this.userExtendedTypes;
    }

    private ListBuilder<ExtendedTypeFactory> contributeExtendedTypeFactories() {
        if (this.extendedTypeFactories == null) {
            this.extendedTypeFactories = this.binder.bindList(ExtendedTypeFactory.class, "cayenne.type_factories");
        }
        return this.extendedTypeFactories;
    }

    private ListBuilder<ValueObjectType> contributeValueObjectTypes() {
        if (this.valueObjectTypes == null) {
            this.valueObjectTypes = this.binder.bindList(ValueObjectType.class);
        }
        return this.valueObjectTypes;
    }

    private MapBuilder<PkGenerator> contributePkGenerators() {
        if (this.pkGenerators == null) {
            this.pkGenerators = this.binder.bindMap(PkGenerator.class);
        }
        return this.pkGenerators;
    }
}

