/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.lang.reflect.Field;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.spi.DIUtil;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.InjectionStack;

class FieldInjectingProvider<T>
implements Provider<T> {
    private DefaultInjector injector;
    private Provider<T> delegate;

    FieldInjectingProvider(Provider<T> delegate, DefaultInjector injector) {
        this.delegate = delegate;
        this.injector = injector;
    }

    @Override
    public T get() throws DIRuntimeException {
        T object = this.delegate.get();
        this.injectMembers(object, object.getClass());
        return object;
    }

    private void injectMembers(T object, Class<?> type) {
        if (type == null) {
            return;
        }
        for (Field field : type.getDeclaredFields()) {
            Inject inject = field.getAnnotation(Inject.class);
            if (inject == null) continue;
            this.injectMember(object, field, inject.value());
        }
        this.injectMembers(object, type.getSuperclass());
    }

    private void injectMember(Object object, Field field, String bindingName) {
        Object value = this.value(field, bindingName);
        field.setAccessible(true);
        try {
            field.set(object, value);
        }
        catch (Exception e) {
            String message = String.format("Error injecting into field %s.%s of type %s", field.getDeclaringClass().getName(), field.getName(), field.getType().getName());
            throw new DIRuntimeException(message, (Throwable)e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object value(Field field, String bindingName) {
        Class<?> fieldType = field.getType();
        InjectionStack stack = this.injector.getInjectionStack();
        if (Provider.class.equals(fieldType)) {
            Class<?> objectClass = DIUtil.parameterClass(field.getGenericType());
            if (objectClass == null) {
                throw new DIRuntimeException("Provider field %s.%s of type %s must be parameterized to be usable for injection", field.getDeclaringClass().getName(), field.getName(), fieldType.getName());
            }
            return this.injector.getProvider(Key.get(objectClass, bindingName));
        }
        Key<?> key = DIUtil.getKeyForTypeAndGenericType(fieldType, field.getGenericType(), bindingName);
        stack.push(key);
        try {
            Object obj = this.injector.getInstance(key);
            return obj;
        }
        finally {
            stack.pop();
        }
    }
}

