/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.bytes;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.cayenne.crypto.CayenneCryptoException;
import org.apache.cayenne.crypto.transformer.bytes.BytesEncryptor;

class CbcEncryptor
implements BytesEncryptor {
    private Cipher cipher;
    private byte[] iv;
    private Key key;
    private int blockSize;

    public CbcEncryptor(Cipher cipher, Key key, byte[] seedIv) {
        this.key = key;
        this.cipher = cipher;
        this.blockSize = cipher.getBlockSize();
        if (seedIv.length != this.blockSize) {
            throw new CayenneCryptoException("IV size is expected to be the same as block size. Was " + seedIv.length + "; block size was: " + this.blockSize, new Object[0]);
        }
        this.iv = Arrays.copyOf(seedIv, this.blockSize);
    }

    @Override
    public byte[] encrypt(byte[] input, int outputOffset, byte[] flags) {
        try {
            return this.doEncrypt(input, outputOffset);
        }
        catch (Exception e) {
            throw new CayenneCryptoException("Error on encryption", e, new Object[0]);
        }
    }

    private byte[] doEncrypt(byte[] plain, int outputOffset) throws InvalidKeyException, InvalidAlgorithmParameterException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.cipher.init(1, this.key, new IvParameterSpec(this.iv));
        byte[] encrypted = new byte[outputOffset + this.blockSize + this.cipher.getOutputSize(plain.length)];
        System.arraycopy(this.iv, 0, encrypted, outputOffset, this.blockSize);
        int encBytes = this.cipher.doFinal(plain, 0, plain.length, encrypted, outputOffset + this.blockSize);
        System.arraycopy(encrypted, outputOffset + encBytes, this.iv, 0, this.blockSize);
        return encrypted;
    }
}

